//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armauthorization

const (
	moduleName    = "armauthorization"
	moduleVersion = "v2.0.0"
)

// ApprovalMode - The type of rule
type ApprovalMode string

const (
	ApprovalModeNoApproval  ApprovalMode = "NoApproval"
	ApprovalModeParallel    ApprovalMode = "Parallel"
	ApprovalModeSerial      ApprovalMode = "Serial"
	ApprovalModeSingleStage ApprovalMode = "SingleStage"
)

// PossibleApprovalModeValues returns the possible values for the ApprovalMode const type.
func PossibleApprovalModeValues() []ApprovalMode {
	return []ApprovalMode{
		ApprovalModeNoApproval,
		ApprovalModeParallel,
		ApprovalModeSerial,
		ApprovalModeSingleStage,
	}
}

// AssignmentType - Assignment type of the role assignment schedule
type AssignmentType string

const (
	AssignmentTypeActivated AssignmentType = "Activated"
	AssignmentTypeAssigned  AssignmentType = "Assigned"
)

// PossibleAssignmentTypeValues returns the possible values for the AssignmentType const type.
func PossibleAssignmentTypeValues() []AssignmentType {
	return []AssignmentType{
		AssignmentTypeActivated,
		AssignmentTypeAssigned,
	}
}

// EnablementRules - The type of enablement rule
type EnablementRules string

const (
	EnablementRulesJustification             EnablementRules = "Justification"
	EnablementRulesMultiFactorAuthentication EnablementRules = "MultiFactorAuthentication"
	EnablementRulesTicketing                 EnablementRules = "Ticketing"
)

// PossibleEnablementRulesValues returns the possible values for the EnablementRules const type.
func PossibleEnablementRulesValues() []EnablementRules {
	return []EnablementRules{
		EnablementRulesJustification,
		EnablementRulesMultiFactorAuthentication,
		EnablementRulesTicketing,
	}
}

// MemberType - Membership type of the role assignment schedule
type MemberType string

const (
	MemberTypeDirect    MemberType = "Direct"
	MemberTypeGroup     MemberType = "Group"
	MemberTypeInherited MemberType = "Inherited"
)

// PossibleMemberTypeValues returns the possible values for the MemberType const type.
func PossibleMemberTypeValues() []MemberType {
	return []MemberType{
		MemberTypeDirect,
		MemberTypeGroup,
		MemberTypeInherited,
	}
}

// NotificationDeliveryMechanism - The type of notification.
type NotificationDeliveryMechanism string

const (
	NotificationDeliveryMechanismEmail NotificationDeliveryMechanism = "Email"
)

// PossibleNotificationDeliveryMechanismValues returns the possible values for the NotificationDeliveryMechanism const type.
func PossibleNotificationDeliveryMechanismValues() []NotificationDeliveryMechanism {
	return []NotificationDeliveryMechanism{
		NotificationDeliveryMechanismEmail,
	}
}

// NotificationLevel - The notification level.
type NotificationLevel string

const (
	NotificationLevelAll      NotificationLevel = "All"
	NotificationLevelCritical NotificationLevel = "Critical"
	NotificationLevelNone     NotificationLevel = "None"
)

// PossibleNotificationLevelValues returns the possible values for the NotificationLevel const type.
func PossibleNotificationLevelValues() []NotificationLevel {
	return []NotificationLevel{
		NotificationLevelAll,
		NotificationLevelCritical,
		NotificationLevelNone,
	}
}

// PrincipalType - The principal type of the assigned principal ID.
type PrincipalType string

const (
	PrincipalTypeDevice           PrincipalType = "Device"
	PrincipalTypeForeignGroup     PrincipalType = "ForeignGroup"
	PrincipalTypeGroup            PrincipalType = "Group"
	PrincipalTypeServicePrincipal PrincipalType = "ServicePrincipal"
	PrincipalTypeUser             PrincipalType = "User"
)

// PossiblePrincipalTypeValues returns the possible values for the PrincipalType const type.
func PossiblePrincipalTypeValues() []PrincipalType {
	return []PrincipalType{
		PrincipalTypeDevice,
		PrincipalTypeForeignGroup,
		PrincipalTypeGroup,
		PrincipalTypeServicePrincipal,
		PrincipalTypeUser,
	}
}

// RecipientType - The recipient type.
type RecipientType string

const (
	RecipientTypeAdmin     RecipientType = "Admin"
	RecipientTypeApprover  RecipientType = "Approver"
	RecipientTypeRequestor RecipientType = "Requestor"
)

// PossibleRecipientTypeValues returns the possible values for the RecipientType const type.
func PossibleRecipientTypeValues() []RecipientType {
	return []RecipientType{
		RecipientTypeAdmin,
		RecipientTypeApprover,
		RecipientTypeRequestor,
	}
}

// RequestType - The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign etc
type RequestType string

const (
	RequestTypeAdminAssign    RequestType = "AdminAssign"
	RequestTypeAdminExtend    RequestType = "AdminExtend"
	RequestTypeAdminRemove    RequestType = "AdminRemove"
	RequestTypeAdminRenew     RequestType = "AdminRenew"
	RequestTypeAdminUpdate    RequestType = "AdminUpdate"
	RequestTypeSelfActivate   RequestType = "SelfActivate"
	RequestTypeSelfDeactivate RequestType = "SelfDeactivate"
	RequestTypeSelfExtend     RequestType = "SelfExtend"
	RequestTypeSelfRenew      RequestType = "SelfRenew"
)

// PossibleRequestTypeValues returns the possible values for the RequestType const type.
func PossibleRequestTypeValues() []RequestType {
	return []RequestType{
		RequestTypeAdminAssign,
		RequestTypeAdminExtend,
		RequestTypeAdminRemove,
		RequestTypeAdminRenew,
		RequestTypeAdminUpdate,
		RequestTypeSelfActivate,
		RequestTypeSelfDeactivate,
		RequestTypeSelfExtend,
		RequestTypeSelfRenew,
	}
}

// RoleManagementPolicyRuleType - The type of rule
type RoleManagementPolicyRuleType string

const (
	RoleManagementPolicyRuleTypeRoleManagementPolicyApprovalRule              RoleManagementPolicyRuleType = "RoleManagementPolicyApprovalRule"
	RoleManagementPolicyRuleTypeRoleManagementPolicyAuthenticationContextRule RoleManagementPolicyRuleType = "RoleManagementPolicyAuthenticationContextRule"
	RoleManagementPolicyRuleTypeRoleManagementPolicyEnablementRule            RoleManagementPolicyRuleType = "RoleManagementPolicyEnablementRule"
	RoleManagementPolicyRuleTypeRoleManagementPolicyExpirationRule            RoleManagementPolicyRuleType = "RoleManagementPolicyExpirationRule"
	RoleManagementPolicyRuleTypeRoleManagementPolicyNotificationRule          RoleManagementPolicyRuleType = "RoleManagementPolicyNotificationRule"
)

// PossibleRoleManagementPolicyRuleTypeValues returns the possible values for the RoleManagementPolicyRuleType const type.
func PossibleRoleManagementPolicyRuleTypeValues() []RoleManagementPolicyRuleType {
	return []RoleManagementPolicyRuleType{
		RoleManagementPolicyRuleTypeRoleManagementPolicyApprovalRule,
		RoleManagementPolicyRuleTypeRoleManagementPolicyAuthenticationContextRule,
		RoleManagementPolicyRuleTypeRoleManagementPolicyEnablementRule,
		RoleManagementPolicyRuleTypeRoleManagementPolicyExpirationRule,
		RoleManagementPolicyRuleTypeRoleManagementPolicyNotificationRule,
	}
}

// Status - The status of the role assignment schedule.
type Status string

const (
	StatusAccepted                    Status = "Accepted"
	StatusAdminApproved               Status = "AdminApproved"
	StatusAdminDenied                 Status = "AdminDenied"
	StatusCanceled                    Status = "Canceled"
	StatusDenied                      Status = "Denied"
	StatusFailed                      Status = "Failed"
	StatusFailedAsResourceIsLocked    Status = "FailedAsResourceIsLocked"
	StatusGranted                     Status = "Granted"
	StatusInvalid                     Status = "Invalid"
	StatusPendingAdminDecision        Status = "PendingAdminDecision"
	StatusPendingApproval             Status = "PendingApproval"
	StatusPendingApprovalProvisioning Status = "PendingApprovalProvisioning"
	StatusPendingEvaluation           Status = "PendingEvaluation"
	StatusPendingExternalProvisioning Status = "PendingExternalProvisioning"
	StatusPendingProvisioning         Status = "PendingProvisioning"
	StatusPendingRevocation           Status = "PendingRevocation"
	StatusPendingScheduleCreation     Status = "PendingScheduleCreation"
	StatusProvisioned                 Status = "Provisioned"
	StatusProvisioningStarted         Status = "ProvisioningStarted"
	StatusRevoked                     Status = "Revoked"
	StatusScheduleCreated             Status = "ScheduleCreated"
	StatusTimedOut                    Status = "TimedOut"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusAccepted,
		StatusAdminApproved,
		StatusAdminDenied,
		StatusCanceled,
		StatusDenied,
		StatusFailed,
		StatusFailedAsResourceIsLocked,
		StatusGranted,
		StatusInvalid,
		StatusPendingAdminDecision,
		StatusPendingApproval,
		StatusPendingApprovalProvisioning,
		StatusPendingEvaluation,
		StatusPendingExternalProvisioning,
		StatusPendingProvisioning,
		StatusPendingRevocation,
		StatusPendingScheduleCreation,
		StatusProvisioned,
		StatusProvisioningStarted,
		StatusRevoked,
		StatusScheduleCreated,
		StatusTimedOut,
	}
}

// Type - Type of the role assignment schedule expiration
type Type string

const (
	TypeAfterDateTime Type = "AfterDateTime"
	TypeAfterDuration Type = "AfterDuration"
	TypeNoExpiration  Type = "NoExpiration"
)

// PossibleTypeValues returns the possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{
		TypeAfterDateTime,
		TypeAfterDuration,
		TypeNoExpiration,
	}
}

// UserType - The type of user.
type UserType string

const (
	UserTypeGroup UserType = "Group"
	UserTypeUser  UserType = "User"
)

// PossibleUserTypeValues returns the possible values for the UserType const type.
func PossibleUserTypeValues() []UserType {
	return []UserType{
		UserTypeGroup,
		UserTypeUser,
	}
}
