/*
 *
 *  Multimedia Messaging Service Daemon - The Next Generation
 *
 *  Copyright (C) 2021, Chris Talbot <chris@talbothome.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <glib/gprintf.h>
#include <math.h>

#include "geoclue-stumbler-maps-page.h"
#include "geoclue-stumbler-marker.h"

#define degToRad(angleInDegrees) ((angleInDegrees) * M_PI / 180.0)
#define radToDeg(angleInRadians) ((angleInRadians) * 180.0 / M_PI)

/*
 * We don't need the heading to be exact, so provide some slack for different
 * architectures.
 */
#define EPSILON 0.00001

static void
test_heading_adjustment (gconstpointer data)
{
  double adjusted_heading;
  double check_heading = 0.0;

  ShumateCoordinate *prev_location = shumate_coordinate_new_full (5, 5);

  check_heading = degToRad(0);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 5, 5);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 6, 5);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 5.000001, 5);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);

  check_heading = degToRad(315);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 6, 6);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 5.000001, 5.000001);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);

  check_heading = degToRad(270);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 5, 6);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 5, 5.000001);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);

  check_heading = degToRad(225);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 4, 6);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 4.999999, 5.000001);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);

  check_heading = degToRad(180);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 4, 5);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 4.999999, 5);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);

  check_heading = degToRad(135);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 4, 4);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 4.999999, 4.999999);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);

  check_heading = degToRad(90);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 5, 4);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 5, 4.999999);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);

  check_heading = degToRad(45);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 6, 4);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);
  adjusted_heading = maps_page_adjust_heading (SHUMATE_LOCATION (prev_location), 5.000001, 4.999999);
  g_assert_cmpfloat (adjusted_heading, <= , check_heading + EPSILON);
  g_assert_cmpfloat (adjusted_heading, >= , check_heading - EPSILON);

  g_object_unref (prev_location);
}

int
main (int    argc,
      char **argv)
{
  g_test_init (&argc, &argv, NULL);

  g_test_add_data_func ("/map_page/Heading Adjustment Test",
                        NULL, test_heading_adjustment);


  return g_test_run ();
}
