/* $Id$ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __INDIRECT_OPERAND_HPP_INCLUDED
#define __INDIRECT_OPERAND_HPP_INCLUDED

#include "intermediate/operands/Operand.hpp"
#include "intermediate/operands/Register.hpp"
#include <cassert>

namespace intermediate {

//! an indirect operand
/** This class represents an indirect operand. This means, that the source may
 *  only be of storage class pointer. When accessing an indirect operand, 
 *  the source pointer will get dereferenced.
 */
class IndirectOperand : public Operand {
public:

	//! c'tor
	/** @param source source of the operand (register, name).
	 *  @param t width to use for deferentiation.
	 */
	IndirectOperand(
		Register *source,
		enum OpType t
		) : 	Operand(t),
			src(source) {

		// can dereference only pointers!
		assert(source->type == OP_TYPE_POINTER);
	}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor &v) {
		v.visit(*this);
	}

	//! source of the operand.
	Register *src;

protected:
	virtual ~IndirectOperand() {
		util::MiscUtil::terminate(this->src);
	}
};

}; /* namespace intermediate */

#endif /* __INDIRECT_OPERAND_HPP_INCLUDED */
