# macro to convert a CMAKE list to a string
MACRO(LIST2STRING alist astring)
  FOREACH(elem ${${alist}})
   SET(${astring} "${${astring}} ${elem}")
  ENDFOREACH(elem)
ENDMACRO(LIST2STRING) 

# from http://www.cmake.org/Wiki/CMakeMacroParseArguments
MACRO(PARSE_ARGUMENTS prefix arg_names option_names)
  SET(DEFAULT_ARGS)
  FOREACH(arg_name ${arg_names})    
    SET(${prefix}_${arg_name})
  ENDFOREACH(arg_name)
  FOREACH(option ${option_names})
    SET(${prefix}_${option} FALSE)
  ENDFOREACH(option)

  SET(current_arg_name DEFAULT_ARGS)
  SET(current_arg_list)
  FOREACH(arg ${ARGN})            
    SET(larg_names ${arg_names})    
    LIST(FIND larg_names "${arg}" is_arg_name)                   
    IF (is_arg_name GREATER -1)
      SET(${prefix}_${current_arg_name} ${current_arg_list})
      SET(current_arg_name ${arg})
      SET(current_arg_list)
    ELSE (is_arg_name GREATER -1)
      SET(loption_names ${option_names})    
      LIST(FIND loption_names "${arg}" is_option)            
      IF (is_option GREATER -1)
	     SET(${prefix}_${arg} TRUE)
      ELSE (is_option GREATER -1)
	     SET(current_arg_list ${current_arg_list} ${arg})
      ENDIF (is_option GREATER -1)
    ENDIF (is_arg_name GREATER -1)
  ENDFOREACH(arg)
  SET(${prefix}_${current_arg_name} ${current_arg_list})
ENDMACRO(PARSE_ARGUMENTS)

include(CheckCXXCompilerFlag)
MACRO(set_sse_cxx_flags)
  IF(CMAKE_COMPILER_IS_GNUCXX)
    MESSAGE("-- Checking for -march=native support")
    CHECK_CXX_COMPILER_FLAG("-march=native" MARCHNATIVE)
    if (MARCHNATIVE)
      set(MARCH "-march=native")
    else()
      MESSAGE("-- Checking for -mtune=native support")
      CHECK_CXX_COMPILER_FLAG("-mtune=native" MTUNENATIVE)
      if (MTUNENATIVE)
        set(MARCH "-mtune=native")
      else()
        set(MARCH "-mtune=generic")
      endif()
    endif()

    set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} -msse2 ${MARCH}")
  ELSEIF(MSVC)
    set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} /arch:SSE2")
  ENDIF(CMAKE_COMPILER_IS_GNUCXX)
ENDMACRO(set_sse_cxx_flags)
