/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.Mapping;

public class DBRefEntry {
    String source = "";
    String version = "";
    String accessionId = "";
    Mapping map = null;

    public DBRefEntry() {
    }

    public DBRefEntry(String source, String version, String accessionId) {
        this(source, version, accessionId, null);
    }

    public DBRefEntry(String source, String version, String accessionId, Mapping map) {
        this.source = source.toUpperCase();
        this.version = version;
        this.accessionId = accessionId;
        this.map = map;
    }

    public DBRefEntry(DBRefEntry entry) {
        this(entry.source == null ? "" : new String(entry.source), entry.version == null ? "" : new String(entry.version), entry.accessionId == null ? "" : new String(entry.accessionId), entry.map == null ? null : new Mapping(entry.map));
    }

    public boolean equals(DBRefEntry entry) {
        if (entry == this) {
            return true;
        }
        if (entry == null) {
            return false;
        }
        return this.equalRef(entry) && (this.map == null && entry.map == null || this.map != null && entry.map != null && this.map.equals(entry.map));
    }

    public boolean equalRef(DBRefEntry entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        return this.source != null && entry.source != null && this.source.equalsIgnoreCase(entry.source) && this.accessionId != null && entry.accessionId != null && this.accessionId.equalsIgnoreCase(entry.accessionId) && this.version != null && entry.version != null && this.version.equalsIgnoreCase(entry.version);
    }

    public String getSource() {
        return this.source;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAccessionId() {
        return this.accessionId;
    }

    public void setAccessionId(String accessionId) {
        this.accessionId = accessionId;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Mapping getMap() {
        return this.map;
    }

    public void setMap(Mapping map) {
        this.map = map;
    }

    public boolean hasMap() {
        return this.map != null;
    }

    public String getSrcAccString() {
        return (this.source != null ? this.source : "") + ":" + (this.accessionId != null ? this.accessionId : "");
    }
}

