package org.eclipse.webdav.internal.kernel.utils;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */

import java.util.Enumeration;

public class MergedEnumeration extends EnumerationFilter {

	protected Enumeration first;
	protected Enumeration second;
/**
 * MergedEnumeration constructor comment.
 * @param underlyingEnum java.util.Enumeration
 */
public MergedEnumeration(Enumeration first, Enumeration second) {
	
	super();

	this.first = first;
	this.second = second;
}
public boolean hasMoreElements() {

	return (first.hasMoreElements() || second.hasMoreElements());
}
public Object nextElement() {

	if (first.hasMoreElements())
		return first.nextElement();

	return second.nextElement();
}
}
