/*
 * (C) Copyright 2005- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
 * virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
 */

#include "grib_api.h"
#include <assert.h>
/*
 * Test FA conversion to grib_api
 * philippe.marguinaud@meteo.fr 02/2016
 */

static double values[] = {
    276.857846883478, 276.794176778727, 277.181087123710, 277.271328891367, 277.738150007595,
    277.811501271569, 277.782801498740, 277.720243049346, 277.697362352800, 277.645937156907,
    277.434690429892, 277.479415166828, 277.480779740851, 277.470370683483, 277.466233617218,
    277.519636477424, 277.546507075768, 277.533196530853, 277.638535538066, 277.660223799155,
    277.516239354148, 277.435042994882, 277.233848743540, 277.204873528392, 277.217411121384,
    277.145056043542, 277.359707505178, 277.563426568591, 277.359606573371, 277.302689400583,
    277.135925984483, 277.013670202527, 277.249004656066, 277.362196243717, 277.472882266866,
    277.551374864505, 277.332048151829, 277.879973060166, 277.925942918285, 278.260846010953,
    278.144732099878, 278.206939585072, 277.936934540523, 278.025569678971, 278.307756924958,
    278.369318574429, 278.609267078466, 278.634490902502, 278.686706704875, 278.328553888493,
    278.418908930386, 279.060194431430, 279.114168787979, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 276.922836958812,
    276.932069336471, 277.225397205068, 277.545476457484, 277.807111956190, 277.768185575062,
    277.713814690105, 277.662213334460, 277.653334089351, 277.591821807616, 277.519290878870,
    277.499671640950, 277.471580060430, 277.398162354734, 277.371544952255, 277.453879058484,
    277.474032112632, 277.458747675572, 277.588871038908, 277.540124772655, 277.464264615292,
    277.039835665510, 277.050815441941, 277.165791541588, 277.284327024201, 277.353876090779,
    277.399785414714, 277.512330802008, 277.438449711794, 277.419894070553, 277.165764618769,
    277.034846715507, 277.230872118099, 277.277310155004, 277.272952146249, 277.486209474088,
    277.453656185210, 277.613143953527, 278.070672412350, 278.079989482462, 278.338031969208,
    278.163685044856, 278.214343856183, 278.255744502346, 277.941149161137, 278.165921759503,
    278.022894706983, 278.499780589025, 278.158397461806, 278.611643581705, 278.438079674786,
    278.816122996613, 278.628190436440, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 277.048057829677, 277.280372081890,
    277.423859756998, 277.465672699176, 277.728939006340, 277.726575834584, 277.688480429396,
    277.635385647721, 277.626062350091, 277.604239400215, 277.556926439833, 277.519394378669,
    277.425044031161, 277.318865067295, 277.309205651263, 277.348943116883, 277.361861210203,
    277.430978988228, 277.477408565654, 277.638923535542, 277.418799606607, 277.017513285449,
    276.976808425920, 277.159242736589, 277.315106840602, 277.327868258207, 277.390541905514,
    277.608373786211, 277.473011211489, 277.578037079299, 277.353975261579, 277.253195520645,
    277.219244477693, 277.303161046293, 277.197720889628, 277.568280002996, 277.565774183730,
    278.056333010069, 278.360857981015, 278.182020399473, 278.393376099219, 278.363774312832,
    278.203283980677, 278.146185013281, 278.348861342242, 278.330399393385, 278.059284960522,
    277.920499351734, 278.030061320993, 278.226766351540, 278.217750387710, 278.516389162421,
    278.535938385310, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 277.255920436446, 277.480949345724, 277.444597425498,
    277.647882845088, 277.496111688818, 277.670322939349, 277.765213822002, 277.666760657851,
    277.656928637994, 277.678906056191, 277.667906868059, 277.539641562735, 277.369487702737,
    277.285648882293, 277.326341650870, 277.351600146853, 277.359573895370, 277.493766228910,
    277.649003177440, 277.460872384943, 277.243514998577, 277.056578101319, 277.226617780177,
    277.271740370610, 277.294132332584, 277.308093611741, 277.378433184955, 277.570114302521,
    277.548859645865, 277.723889890260, 277.429263433352, 277.272737053512, 277.398599847739,
    277.309448997716, 277.328344724582, 277.207058029377, 277.696248070705, 277.835043755662,
    278.062452681475, 277.850550227440, 278.265559859820, 278.272872090840, 278.465229599008,
    278.217031341802, 278.386132964535, 278.224365564792, 278.232702192636, 278.099733855522,
    278.082038386312, 278.064057694079, 278.385342869231, 278.700953905968, 278.673157999290,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 277.459327717938, 277.559547836427, 277.422638507574, 277.572825627337,
    277.571463907280, 277.548694860479, 277.544037804342, 277.524653326012, 277.693130140178,
    277.706143234839, 277.497931516767, 277.349914202908, 277.161676307980, 277.258114023397,
    277.410663587516, 277.481076538026, 277.519833710823, 277.631696408897, 277.418308903785,
    277.304804629716, 277.259147844963, 277.382350427133, 277.299040041596, 277.256710875078,
    277.280373232168, 277.342518042564, 277.164290846344, 277.428166532894, 277.401545619979,
    277.739369780501, 277.395945166703, 277.460368035024, 277.476322888924, 277.493513518766,
    277.351824398612, 277.358401183558, 277.509306514214, 278.029530363332, 278.214265489018,
    278.152451178774, 278.452249056059, 278.282135844771, 278.031146456185, 278.126155437803,
    278.340924990343, 278.274408568623, 278.095792700955, 278.045155910991, 278.044971189736,
    278.227690671411, 278.277414153890, 278.322932576059, 278.574745416009, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    277.352885697217, 277.465676965878, 277.313718088585, 277.571636446583, 277.752813057885,
    277.876072319293, 277.600399390414, 277.629804333290, 277.509786900336, 277.350032286595,
    277.710697230771, 277.302689293788, 276.964102591939, 277.129868245471, 277.506377821286,
    277.620243311629, 277.670677617944, 277.590396381881, 277.259332104000, 277.282466682171,
    277.510494889930, 277.420372093899, 277.372440940559, 277.334025248344, 277.133405320679,
    277.432373537602, 277.458193421654, 277.573994485106, 277.560836748035, 277.504546294795,
    277.722963359918, 277.429148743501, 277.415671650080, 277.296250262619, 277.426094729653,
    277.013478567167, 277.173619712680, 277.722720050144, 278.152541665310, 278.471048817117,
    278.595955610324, 278.466217631891, 278.437646585921, 278.321089675788, 278.198112904595,
    277.952153564447, 278.065664545600, 278.357066253341, 277.965448681613, 278.124513612433,
    278.162667811909, 278.277405316586, 278.574537792479, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 277.390479450263,
    277.345673673084, 277.364302907561, 277.605928275352, 277.789929872344, 277.903984493908,
    277.966933216759, 277.912882971090, 277.703988459187, 277.351015681331, 277.674063100141,
    277.408395530420, 277.007259003699, 276.877336007904, 277.057623772846, 277.601455267293,
    277.323874590069, 277.238673158792, 277.337325747808, 277.439493917521, 277.541788857115,
    277.749810750892, 277.278504087019, 277.414256185858, 277.429899941764, 277.493551649852,
    277.511929075685, 277.190651115649, 277.443504438646, 277.605668250438, 277.771466436681,
    277.767262688689, 277.716100034677, 277.618374865972, 277.415460290735, 277.086306373890,
    277.176226842383, 277.650329975958, 277.765271071796, 278.463221024006, 278.702998001410,
    278.624355987396, 278.467009674144, 278.568028046137, 278.284237092204, 278.456297664446,
    278.609188468591, 278.571107283134, 278.248413926530, 278.155161517380, 278.404700226527,
    278.246987177160, 278.091060834030, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 277.419054703888, 277.313454081577,
    277.427414463702, 277.682584699189, 277.791193561005, 277.837885785253, 277.920062626646,
    277.919899324178, 277.689677224346, 277.410500912168, 277.630756408261, 277.629189004816,
    277.397411408199, 277.319060037245, 277.402102256687, 277.322768000649, 277.822242558531,
    277.887351499372, 277.454007146918, 277.676721339532, 277.602004218075, 277.714201570065,
    277.566677175978, 277.587799289763, 277.530615330753, 277.556498697055, 277.452480002766,
    277.522252203614, 277.645085515486, 277.845531596217, 277.946658451859, 277.602481754126,
    277.727335587639, 277.560791900289, 277.284230600351, 277.484662737021, 277.763836962967,
    277.845000815162, 278.010847594804, 278.693344887027, 278.809251065654, 278.723035732378,
    278.424896815390, 278.623465372965, 278.347354282196, 278.788885219380, 278.765666653428,
    278.053095427463, 278.334108537083, 278.163143059112, 278.791210402345, 278.564612083899,
    278.156097707067, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 277.260418446226, 277.335071352700, 277.491938938790,
    277.691206395263, 277.704209378278, 277.669286596309, 277.754719412166, 277.870079071509,
    277.502780644528, 277.754473095834, 277.727974436459, 277.557807112427, 277.336457025286,
    277.383919705566, 277.656951776528, 277.778531969694, 277.546679431981, 277.433886594239,
    277.849054763829, 277.827905512882, 277.852324775739, 277.715592971272, 277.705949179344,
    277.784233780020, 277.513796321220, 277.651505656888, 277.679417351708, 277.712133821933,
    277.640023428435, 277.845573550891, 277.939074922095, 277.983471194163, 277.686692172136,
    277.654194453924, 277.864032570137, 277.868319164885, 277.949388853803, 278.090141829888,
    278.064378565379, 278.473111038064, 278.567543171754, 278.829326294043, 278.294846275015,
    278.860106433048, 278.796593070403, 278.824386010090, 278.760223015153, 278.048034602279,
    278.456786976534, 278.270707527732, 278.883481216381, 278.331828953117, 278.594265837323,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 277.265976322594, 277.170431045594, 277.485489657589, 277.518150163777,
    277.594346099824, 277.525106574839, 277.660446242218, 277.653585064744, 277.344627321906,
    277.549004645704, 277.850802344347, 277.583257392330, 277.353933834212, 277.483162324227,
    277.802093742320, 277.620873269675, 277.778845766219, 277.705264213562, 277.541346709049,
    277.429472445857, 277.832567758240, 277.874496054447, 277.713531133238, 277.960569830321,
    277.669206881492, 277.755260958946, 277.586916719101, 277.841135564379, 277.718811273917,
    277.786742393662, 277.829134182740, 277.760954990401, 277.727290357312, 277.802718821044,
    277.926844650633, 277.940517920966, 277.860498676370, 277.948632515039, 278.482136788291,
    278.576025918865, 278.759903750249, 278.682290037298, 278.803929269590, 278.813600952805,
    278.879253548731, 278.646151177629, 278.776315233178, 278.693319468861, 278.379375494188,
    278.648541321932, 278.852157864598, 278.997643614525, 279.027698942229, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    277.366680878019, 277.381150787692, 277.486313780854, 277.312232782158, 277.401101882668,
    277.567697032357, 277.761418956830, 277.631564641376, 277.355216207498, 277.579622423646,
    277.946803922538, 277.745864795866, 277.554670208171, 277.653554412702, 277.886277698790,
    277.865648942958, 277.749235588755, 277.653323813329, 277.549350491474, 277.771809470937,
    277.894339690909, 277.969462462647, 278.118951046477, 278.108173032796, 277.923612184096,
    277.725656808996, 277.917004359488, 278.013510348155, 277.903413295852, 277.848269398192,
    277.837731396906, 277.733960635088, 277.766101554254, 277.546687146201, 277.856867293302,
    277.905478550194, 277.736223835135, 278.472986192106, 278.717220540209, 278.760841954155,
    278.638659440517, 278.681901711759, 278.363012975511, 278.807884722018, 278.838462052377,
    278.928798765744, 278.952453872397, 278.865733112592, 278.729566964511, 278.884998970494,
    278.942907006798, 278.960762454434, 278.688569887665, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 277.591550421937,
    277.499030877279, 277.305275168613, 277.541796080983, 277.195139366615, 277.331665964937,
    277.445626505916, 277.215335680856, 277.530907774801, 277.843341282378, 277.963214149135,
    277.927219319293, 277.797424178773, 277.813442210719, 277.933664495794, 277.858047474598,
    277.696277323311, 277.361473125741, 277.479932829295, 277.389415841575, 277.553020377427,
    277.924940171380, 278.159459379598, 278.037019105043, 277.914055069608, 277.647200588818,
    277.916937939818, 277.909534469069, 277.749633166238, 277.904591816623, 277.826866398276,
    277.903480594745, 277.699082807175, 277.688363481753, 277.605172407277, 277.842865865160,
    278.021216292518, 278.414517122505, 278.681556989763, 278.680320091635, 278.574125022233,
    278.370197434153, 278.734504756703, 278.493143759543, 278.779235286269, 278.935546444982,
    278.663643683160, 278.899996705338, 278.900791563301, 278.879832866026, 278.858705900529,
    278.815825789004, 278.824798215775, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 277.567216721718, 277.522475814565,
    277.303456918119, 277.208997427907, 277.424224609638, 277.567326891009, 277.516826173608,
    277.498907180864, 277.469773038402, 277.832555441150, 277.982833034908, 278.034185232461,
    277.939076079863, 277.902634532238, 277.970739026974, 277.895772802147, 277.735591951345,
    277.571305898374, 277.401061840836, 277.802603400487, 277.964968147081, 278.120946309288,
    278.120357306337, 278.027951015641, 277.674224913903, 277.745718315661, 277.676284056601,
    277.869144896292, 277.970562609159, 277.897871250900, 277.988896836592, 277.828464108029,
    277.787944526233, 277.592034339979, 277.887975166605, 277.726333366592, 278.031409362000,
    278.341449368467, 278.429430372404, 278.651974989787, 278.066148305173, 278.615426251337,
    278.658109595447, 278.764842621618, 278.797171571925, 278.930322025553, 278.589836306622,
    278.878563250804, 278.928365819420, 278.890061138998, 278.711334675770, 278.384119162997,
    278.646351915830, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 277.663311094642, 277.507469698425, 277.389870268662,
    277.406179041586, 277.420737084474, 277.458518864884, 277.735139471721, 277.538528827908,
    277.851206036120, 277.883910964943, 277.957774069964, 277.977068942386, 277.944430734847,
    277.548495261116, 277.973300201287, 277.918203113366, 277.766347699266, 277.602195991588,
    277.779284913253, 277.876179934937, 277.970720881483, 278.083009243663, 278.104572434708,
    277.809070170494, 277.861807626314, 277.891365545407, 277.598480819644, 277.808955771559,
    277.877037325444, 277.848094780278, 277.931719704904, 277.914973085381, 277.584619210738,
    277.926657140828, 278.195616408992, 278.085463190691, 277.980335449674, 278.380371866981,
    278.427298049019, 278.662228114450, 278.596051250816, 278.616744598565, 278.803046455795,
    278.791647475311, 278.497809355494, 278.866809060531, 278.869411961323, 278.852587248998,
    278.873678034993, 278.840736102112, 278.718548564065, 278.079520049554, 278.242255144442,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 277.663037557399, 277.570818671989, 277.407747457760, 277.335813345664,
    277.408696086859, 277.372137478768, 277.687262360450, 277.795853080682, 277.908241927909,
    277.869637561962, 277.892224175058, 277.606701811400, 277.922429208801, 277.536273731865,
    277.514854228159, 277.491556490133, 277.238066098239, 277.372640648916, 277.841348851264,
    277.929444260057, 277.976213790096, 278.044032057611, 277.835719155503, 277.767503822122,
    277.843943315539, 277.920171435982, 277.647907981291, 277.916193738411, 277.839013360636,
    277.803033017271, 277.864319377224, 277.746027317625, 277.651770176824, 278.063583343182,
    278.140685366536, 278.122090447834, 278.051809880199, 278.142408676546, 278.306266717218,
    278.732451854741, 278.748488287575, 278.749619678915, 278.800360568621, 278.706276462243,
    278.492046737934, 278.862935429038, 278.836729260372, 278.789661732480, 278.792523085067,
    278.785266852082, 278.004813712433, 278.206206534037, 278.268595922962, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    277.655861325454, 277.470105519071, 277.399821904234, 277.079715748819, 277.206531740859,
    277.468381791645, 277.363994499400, 277.823385911566, 277.933105323249, 277.866664229846,
    277.852775583871, 277.877579704086, 277.963875663629, 277.928717010393, 277.828398792983,
    277.296954832861, 277.401013285608, 277.627465823518, 277.658221668447, 277.774377222669,
    277.868027943365, 278.023351410815, 277.746712993709, 278.009216578254, 277.993159001656,
    277.680853664988, 277.661928822189, 277.876061141195, 277.861750611024, 277.598049579725,
    277.828212743813, 277.655101339813, 277.951762031896, 277.838019817885, 278.179159164042,
    278.237226454496, 278.178567686687, 278.271357845148, 278.743948910507, 278.860705502890,
    278.683448271915, 278.784519721920, 278.823631988977, 278.720806055127, 278.798185740840,
    278.751147075398, 278.657468304086, 278.445253830843, 278.647530368995, 278.649158962300,
    278.320344550426, 278.521904549617, 278.418647841440, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 277.402768933310,
    277.337648751023, 277.288997139047, 277.307430980466, 277.273543109168, 277.307022035080,
    277.641453325741, 277.844770093515, 277.953627149863, 277.942556409526, 278.215884948157,
    277.975149183501, 277.975145850398, 277.900981141501, 277.505402827533, 277.362760181571,
    277.548236940679, 277.664353875572, 277.502568484867, 277.584445002441, 277.713270317726,
    277.965355998582, 277.690792988212, 278.006179713121, 278.001384579859, 277.828691144649,
    277.561216736042, 277.889988864492, 277.754326137754, 277.904050492162, 277.709121972134,
    277.690236890821, 278.007302124024, 278.153784599132, 278.279221305941, 278.375074001404,
    278.132932590898, 278.527166347114, 278.731939115244, 278.786940471844, 278.668914201410,
    278.548949997938, 278.592784358004, 278.703220908555, 278.607776530910, 278.504228677905,
    278.163645789480, 278.248484564569, 278.501193898172, 278.642560007634, 278.370053886907,
    278.408249992376, 278.403262082509, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 277.207648756580, 277.331137219044,
    277.479780517975, 277.377551184413, 277.272600399963, 277.500350726646, 277.705863349177,
    277.864606993211, 277.966389026012, 278.042544067771, 278.322542195089, 278.031457007641,
    277.941373758310, 277.636410155692, 277.858031016031, 277.252349029484, 277.532160327080,
    277.374767480318, 277.358447349268, 277.596000095572, 277.677202591650, 277.510417183120,
    277.771541403309, 277.999812504068, 277.710912956346, 277.651416447672, 277.782845548063,
    277.920184623648, 278.100817677521, 277.830890386789, 277.549163570987, 277.924816153170,
    277.939889612067, 278.226842544695, 278.334446154499, 278.384165815707, 278.595962695245,
    278.279446869139, 278.639495704751, 278.773812076980, 278.436948614430, 278.920203762416,
    278.841422131634, 278.427836855974, 278.741570912682, 278.508545454593, 278.339874209391,
    278.557063084230, 278.416922724100, 278.706534660227, 278.334083779964, 278.643830203774,
    278.639844363161, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 277.374416670460, 277.500945802563, 277.426407890967,
    277.396874709479, 277.318086237064, 277.616856624914, 277.899994797892, 277.698238913389,
    277.977172419143, 278.341279558064, 278.388060688379, 278.293360918814, 277.904418999468,
    277.876108809024, 277.943923864864, 277.721133375911, 277.442202818399, 277.253739466136,
    277.509607250232, 277.667492305596, 277.591852155885, 277.835292482825, 277.968936425109,
    277.955535101385, 277.936720370208, 277.583707892174, 277.868800957519, 277.945079514213,
    278.033236526786, 277.903343895031, 278.056619912872, 278.157071041598, 278.283239136885,
    278.176795659042, 278.214399736990, 278.377534497257, 278.505800329270, 278.397309694119,
    278.669295404261, 278.768294086585, 278.677030612244, 278.800406330589, 278.667560270694,
    278.786628105936, 278.570032149640, 278.492115471478, 278.447513823625, 278.631423391505,
    278.397821811388, 278.495161908060, 278.272485916042, 278.556447973070, 278.677966110168,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 277.317281721922, 277.505968584604, 277.114499942864, 277.204273695860,
    277.333957324466, 277.623957317731, 277.644603479615, 278.000151120404, 277.641642354499,
    278.324675421874, 278.417063688056, 278.331839246209, 277.968470256881, 277.964794190107,
    278.037060222090, 277.649723985672, 277.168203186638, 277.143187050201, 277.273553266251,
    277.552393261269, 277.634517104997, 277.802271465379, 277.881739212292, 277.940910603072,
    277.879001692426, 277.745720318329, 277.913410218013, 278.101729803357, 277.802314274772,
    277.915739600581, 278.217977656900, 278.416638900017, 278.379485432682, 278.328422581059,
    278.343399135787, 278.412171676156, 278.436343517073, 278.543604914389, 278.063377717316,
    278.540875146925, 278.533646068312, 278.735677942685, 278.780712168233, 278.761366160987,
    278.038154721897, 277.866532120266, 278.165321893048, 278.680388296020, 278.573200036194,
    278.586831345728, 278.488241868816, 278.717947283378, 278.836911122056, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    277.480116247201, 277.368756132519, 277.384832941860, 277.308509322704, 277.345442414908,
    277.590676884641, 277.990539450091, 278.008983298761, 277.523442305010, 277.718274275941,
    277.715931444292, 277.879291396559, 277.831199273422, 277.864571039565, 277.936717108059,
    277.383879543378, 277.479777256307, 277.499848020363, 277.547859827789, 277.305533315021,
    277.482950172282, 277.774397519738, 277.898868170053, 277.817079364159, 277.711025079660,
    277.980058933637, 278.099658611097, 278.100938650431, 278.142922246411, 277.996704723186,
    278.305020752925, 278.407688919361, 278.163649151564, 278.023096003471, 278.332110722164,
    278.268480918882, 278.421591670262, 278.546119434891, 278.568382938671, 278.587036101537,
    278.647194694244, 278.632463274801, 278.809178187614, 278.560416104309, 278.581259006153,
    278.321975280033, 278.397446094076, 278.464681382615, 278.596423306474, 278.667946458021,
    278.738020433360, 278.814420875995, 279.011631604617, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 277.428218736626,
    277.508626172290, 277.415642785172, 277.326956949725, 277.422044581352, 277.628551397821,
    278.032568055647, 277.613158572540, 277.713901836099, 277.885738420719, 277.917749048996,
    278.013884830796, 277.837463066963, 278.076080916673, 277.808832386222, 277.917564486129,
    277.577955670404, 277.241692902309, 277.577689403392, 277.226372942221, 277.416783611213,
    277.772320420235, 277.599211176025, 277.836487250781, 277.809253831983, 277.951052110206,
    278.127684219100, 277.805451324327, 278.205782665344, 277.865170697282, 278.375832904428,
    278.485020997838, 278.294257990030, 277.778871781181, 278.041861178526, 278.230259905805,
    278.579538089333, 278.512225093511, 278.620858449128, 278.484717004610, 278.559119647309,
    278.617542855681, 278.820763331162, 278.736385000030, 278.489854683578, 278.188909713201,
    278.004895490409, 278.007836877641, 278.638253545765, 278.730478954238, 278.787710783790,
    278.859125519494, 279.227392202470, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 277.393891145112, 277.465694686045,
    277.467507921517, 277.411878635866, 277.504059151580, 277.630651160882, 277.879970074861,
    277.995167439470, 277.902552985162, 277.839877260391, 277.886479575329, 277.964201298207,
    277.748472501319, 278.029116825528, 278.009583787838, 277.934526840383, 277.918798670404,
    277.415532843179, 277.226805056122, 277.387098345780, 277.370489382575, 277.592402088486,
    277.700296833394, 277.892605230371, 277.891485508185, 278.129626663091, 278.237884596150,
    278.280404041963, 278.283057722739, 278.176984809500, 278.428645957507, 278.109976506484,
    278.299865428307, 277.995343116520, 277.977547389843, 278.172188036825, 278.514038655551,
    278.675018218984, 278.625249773115, 278.608351762487, 278.536197132141, 278.726854763747,
    278.805234471385, 278.674105241850, 278.663153403020, 278.298350908914, 278.124861199903,
    278.252964651486, 278.482059693182, 278.696680548966, 278.654309837275, 278.837647755382,
    278.841089485443, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 277.328655950263, 277.427619472960, 277.487446231366,
    277.482177271494, 277.494902394691, 277.591252248805, 277.971747475921, 278.009447854320,
    277.958400013211, 277.920394743774, 277.910344201103, 277.904280958818, 277.937158186883,
    278.076707899491, 278.062378531395, 277.668974757625, 277.800233651596, 277.541009600309,
    277.635857852503, 277.317816179233, 277.324195107430, 277.304573477618, 277.583966858675,
    277.801468375244, 277.858184963214, 278.015052891651, 278.279565568836, 278.150440976593,
    278.333103904681, 278.001182976533, 278.378488809734, 278.398697539971, 278.106032442229,
    277.965961371387, 278.143415892015, 278.377058446346, 278.574510298617, 278.436449113920,
    278.556672883167, 278.474960861679, 277.671139137360, 278.608670196079, 278.823152806552,
    278.860633331916, 278.712151986816, 278.295366943143, 277.973512496151, 278.147084138199,
    278.272905044223, 278.608690016513, 278.742172545861, 278.836415342435, 278.950088390739,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 277.310255947307, 277.438715269565, 277.535027802511, 277.514844555789,
    277.462658101701, 277.525339149085, 277.905885035111, 278.029200074722, 278.012440418427,
    277.996696426728, 277.957260620693, 277.882273913448, 277.923722117905, 278.057432597146,
    278.044128097293, 277.761271445925, 277.825323905342, 277.691879001328, 277.446628829196,
    277.285529192993, 277.207992853587, 277.564191085190, 277.712353241969, 277.873266532172,
    278.065423477158, 278.272705886866, 278.158741722804, 278.295227598450, 278.196699266996,
    278.353184502646, 278.349997851807, 278.141054038599, 277.886475692701, 277.859485979835,
    277.988073922406, 278.056957014442, 278.165448109257, 278.437202004743, 278.532793916627,
    278.729865755553, 278.336824160806, 278.305882985596, 278.713096825648, 278.851216364801,
    278.766735587507, 278.187401602110, 277.936089073750, 278.098752788839, 278.239953058972,
    278.622711192950, 278.843801280644, 278.884179584854, 278.970925282742, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    277.333993153785, 277.421151644708, 277.494771266272, 277.504859778772, 277.471450172707,
    277.495380050697, 277.897156708496, 278.087047727013, 278.045437799738, 278.056224065926,
    278.016178427298, 277.909517544432, 277.875464078132, 277.670207024597, 277.846114070057,
    277.728674807606, 277.481683080213, 277.678434290214, 277.452220611572, 277.118933743421,
    277.289809580767, 277.553585984918, 277.846040916297, 277.958533555517, 277.851453386475,
    277.929222688602, 278.241588928175, 278.028359727517, 278.357330703968, 278.540247369890,
    278.402603488606, 278.262877702620, 278.294646895428, 278.106029411922, 277.786973188420,
    277.901937357612, 278.009410152606, 278.354845055124, 278.644262693781, 278.840216526960,
    278.726204045146, 278.600937232653, 278.803160024776, 278.814239641429, 278.406107089989,
    278.204915060477, 278.086114594041, 277.967943887986, 278.030839062421, 278.631386341730,
    278.299910112812, 278.884560848832, 278.886180066033, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 277.403818020342,
    277.385736612011, 277.419079763626, 277.484883608931, 277.520716730724, 277.513550730617,
    277.891587970187, 278.087015712643, 278.064211437361, 278.083756882686, 278.081608204113,
    278.004930191931, 277.667983116988, 277.465515703008, 277.770465817560, 277.486273012311,
    277.812487190729, 277.521348154187, 277.263007792215, 277.559643310698, 277.428266858300,
    277.713431147430, 277.934927582205, 278.100297973144, 278.141264584283, 278.086993250781,
    278.379658327306, 278.359962783622, 278.333521305086, 278.570844647226, 278.406928088404,
    278.423636196882, 278.392152949565, 278.201452070097, 277.856477990354, 277.873435248789,
    278.096769778375, 278.407680402316, 278.908043981651, 278.827575506572, 278.712139062362,
    278.769591044403, 278.756261553376, 278.826156376636, 278.419163229658, 278.090389246096,
    278.124356160438, 278.035593626588, 278.254910218263, 277.366924718560, 278.253233151469,
    278.902280750162, 279.023193013234, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 277.489905843838, 277.288144403828,
    277.451382178926, 277.543372549140, 277.562640697184, 277.535439380058, 277.787699174599,
    277.995109516110, 278.012353528589, 278.018214990669, 278.026842232206, 278.025758889394,
    278.001468911932, 277.958981418954, 277.934824068020, 277.751018859661, 277.513289938194,
    277.478190521822, 277.696713037172, 277.504466132445, 277.486066884529, 277.853056781128,
    278.077295875773, 278.234774297493, 278.327662456752, 278.433621081338, 278.296684198791,
    278.342578057961, 278.285379040344, 277.983925074627, 278.248926266098, 278.525007446921,
    278.445876128392, 278.104398493173, 277.910536085917, 277.940945008878, 278.081826796893,
    278.529637105590, 278.698715957456, 278.794762804276, 278.861716433298, 278.335244079482,
    278.692137237630, 278.680804581213, 278.556629862749, 278.398770705898, 278.455259276313,
    278.292491405216, 278.409341863253, 278.567127873446, 278.775114227671, 278.952795140027,
    279.084767747687, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 277.524648375830, 277.496311267119, 277.564912458774,
    277.619013556894, 277.606746819707, 277.595920519719, 277.854151971529, 278.023987432708,
    278.002073841870, 277.986021680999, 278.024941876269, 278.000914649286, 277.592433020840,
    277.681860660305, 277.885631704720, 277.778259318705, 277.871014021210, 277.876428015559,
    277.788723284443, 277.787820645805, 277.938530551964, 277.864376078717, 278.173275923391,
    278.289334853041, 278.451226379450, 278.501430038586, 278.374869508469, 278.453566275875,
    278.262940769041, 278.201339865362, 278.504357434437, 278.550458514972, 278.415280015529,
    278.309083469218, 278.099364666955, 278.034272070086, 278.181290664566, 278.418559586295,
    278.627322595506, 278.729885168807, 278.788171788983, 278.676468137618, 278.430465953748,
    278.583736392926, 278.738818934276, 278.497103463576, 278.513281650723, 278.121679354076,
    278.516294602332, 278.829577561129, 278.956682360007, 279.057955060579, 279.348107461088,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 277.474572686648, 277.620526101819, 277.579876191216, 277.360462826964,
    277.549474136816, 277.588274409193, 277.894949427885, 278.083728110620, 277.555347984217,
    277.733247247895, 278.015445953589, 277.664549184972, 277.226566090387, 277.319835583899,
    277.669759532369, 277.815087621214, 277.874161852679, 278.107783063761, 278.140316595456,
    278.161088443851, 278.102908173169, 278.119213950167, 278.224356967513, 278.368545269317,
    278.424386685907, 278.174769159603, 278.434721663051, 278.475700763337, 278.510069020504,
    278.551175436030, 278.571361830045, 278.638092447369, 278.646605205673, 278.513270253124,
    278.141327144780, 278.115950680075, 278.337373363097, 278.274464616686, 278.499148651879,
    278.595423351542, 278.569133302757, 278.443504364184, 278.470116786663, 278.405474202063,
    278.476174607142, 278.351734796539, 278.057044240619, 278.525864307774, 278.636236054564,
    278.673533956426, 278.958480628853, 279.107513277297, 279.177226197697, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    277.580570122543, 277.634318472725, 277.659616485035, 277.618057346549, 277.522030659488,
    277.362267071782, 277.372186333198, 278.055229170801, 277.784391394722, 277.537574683026,
    277.784340466299, 277.547947537627, 277.451990151210, 277.480643933265, 277.666856164943,
    277.711808172746, 277.673179528355, 278.161015825933, 277.956039470577, 278.147107822033,
    277.923934558538, 278.104047544295, 277.992356939665, 278.206672410603, 278.508947854374,
    278.256305068195, 278.356204246512, 278.556714187128, 278.604795250140, 278.664440436865,
    278.766423700238, 278.736535640997, 278.720042846867, 278.499145050840, 278.185061618328,
    278.500779492250, 278.288933571022, 278.296811610179, 278.411719697789, 278.517980608444,
    278.463145591579, 278.387209307015, 278.498542676419, 278.586457379716, 278.312529862807,
    278.273753392221, 278.452376606509, 278.515187531602, 278.424686213262, 278.745884182673,
    279.143006916710, 278.919075152226, 279.321139034238, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 277.662378493687,
    277.678435934163, 277.662375895032, 277.591158494953, 277.510569010252, 277.571350359624,
    277.754121208130, 277.990973977522, 277.757628494100, 277.561287021943, 277.486634316690,
    277.525042945477, 277.532619439937, 277.572471674363, 277.443489464657, 277.644319445620,
    277.665981899947, 278.128702193914, 278.134993079919, 277.939643867877, 277.829674444778,
    277.920407262541, 278.225109521812, 278.454420846245, 278.335636048648, 278.439755866968,
    278.556282205556, 278.641783528936, 278.681789272875, 278.705946366072, 278.807551296203,
    278.775139246657, 278.816740548483, 278.723779732785, 278.140623274423, 278.551611396458,
    278.438468292334, 278.371046387243, 278.432387336449, 278.271114366293, 278.280713350360,
    278.328592293660, 278.509010393596, 278.315046309223, 278.168349319322, 278.279893722304,
    278.388489929202, 278.028546414610, 278.067008312878, 278.735603677916, 278.875197099938,
    278.916380807791, 279.081185555734, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 277.675564771386, 277.635443490043,
    277.555593388636, 277.474215655524, 277.508785537502, 277.559272826965, 277.898963108355,
    278.160478537993, 277.698446328836, 277.535506294291, 277.650670399939, 277.713715654254,
    277.734628640441, 277.634344419146, 277.955083825013, 277.839312734512, 278.032298048669,
    277.878980044522, 277.940977547635, 278.228734022884, 278.183322722407, 278.317956053497,
    278.223938712345, 278.281454807630, 278.286552318883, 278.286369796342, 278.414024043537,
    278.659360323843, 278.716814326172, 278.768624030203, 278.839142757595, 278.825723621249,
    278.854881582904, 278.492476448520, 278.560515417031, 278.575788272122, 278.498507193087,
    278.406864865871, 278.466947148140, 278.325092661631, 278.469051212641, 278.408787619500,
    278.661902048190, 278.661367318075, 278.459305901808, 278.222284106910, 278.377818887784,
    277.959327267209, 278.623834307258, 278.738685964726, 278.800554549259, 278.851954436327,
    278.995254298110, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 277.584969222118, 277.627926693726, 277.432600717237,
    277.459047042982, 277.597393070604, 277.234297430406, 277.627802486716, 277.768761653507,
    277.858521156621, 277.718058564950, 277.536424253963, 277.886264022321, 277.953425182639,
    277.898146408245, 277.845543290783, 278.043517097872, 278.101299101003, 278.285342963779,
    278.272056517909, 277.993274994819, 277.857694108392, 278.387036994248, 278.124588570184,
    278.166963674206, 278.394923902234, 278.402876708228, 277.959213287923, 278.570898673058,
    278.714369994443, 278.790925545959, 278.865460063705, 278.887653108598, 278.925165577904,
    278.445683950808, 278.454662353423, 278.661881572607, 278.503970146357, 278.416849170500,
    278.313604733026, 278.551157387306, 278.536725681615, 278.621164456571, 278.693420303848,
    278.659085456184, 278.410157301715, 278.248100222314, 278.068519937287, 277.489258886793,
    278.582901560003, 278.758730417454, 278.753965383538, 278.760787016072, 279.095432709613,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 277.617881541072, 277.711309115784, 277.528121492641, 277.692656014265,
    277.729855515134, 277.324286569399, 277.806867446539, 277.771307124788, 277.941974315568,
    277.793422663721, 277.560140843400, 277.640329086171, 277.719016393704, 277.775996718354,
    277.776543735559, 278.069109429862, 278.047555848040, 278.042547866743, 277.879970814221,
    278.078945404616, 278.172068463404, 278.338754643149, 278.107330216076, 278.112910048865,
    278.445453513808, 278.413972889685, 278.281435948761, 278.688102249953, 278.748755950831,
    278.825775954851, 278.864385587829, 278.887954649503, 278.923518570963, 278.497911197741,
    278.577311671993, 278.567434824410, 278.538279003744, 278.579915443113, 278.528959489854,
    278.497061723077, 278.590410175821, 278.685518588178, 278.714343026087, 278.633658175898,
    278.394357807741, 278.239312017157, 278.085722164932, 278.380059590956, 278.739705486505,
    278.694694263682, 278.672923745762, 278.696715687286, 278.853484672915, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    277.864490745271, 277.943292827263, 277.719654098130, 277.620485639589, 277.472319039130,
    277.693129006556, 278.133689973093, 277.965457344363, 278.104287602920, 277.823621279948,
    277.618839688350, 277.615190026184, 277.755976640115, 277.813120706528, 277.967931066943,
    277.982623081629, 277.997140146694, 277.975617671251, 278.039568336506, 277.889611169291,
    278.218105661708, 278.124968954386, 278.376454955636, 278.278665136291, 278.301183298592,
    278.397428714062, 278.196778796572, 278.746656377329, 278.846907930532, 278.786561698973,
    278.841304821452, 278.874397654021, 278.909276839009, 278.143937356126, 278.097256838341,
    278.545815137404, 278.494309833488, 278.700417405390, 278.612579318198, 278.560830208376,
    278.548054206682, 278.619008303868, 278.609079484424, 278.483923041726, 278.208681314237,
    278.090402297370, 278.747716499947, 278.515614144343, 278.526325760542, 278.605377647849,
    278.717274877437, 278.819420463325, 278.599577926182, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 278.068675398310,
    277.997973826578, 277.749167591392, 277.971702730095, 277.895766091276, 277.766323744104,
    278.114006780512, 278.215465587629, 277.865744497808, 277.621846139857, 277.619176720160,
    277.665176866961, 277.892488116900, 277.825831734535, 277.991463449834, 277.928833353682,
    277.746440198884, 277.792686927302, 277.910135077567, 277.533121937113, 278.131357931757,
    278.388181942261, 278.402417692803, 278.227304284300, 278.415814342073, 278.378254025897,
    278.601248279164, 278.758242092388, 278.847426423313, 278.280248973563, 278.725834255314,
    278.842186363034, 278.868778923155, 278.494225795144, 278.020128379151, 278.679498884784,
    278.912318616850, 278.814308937895, 278.701152379232, 278.573422817796, 278.532102069194,
    278.542072630317, 278.495785291661, 278.388540928046, 277.931685199925, 278.182962322534,
    278.499946233316, 278.539211829192, 278.586336069633, 278.553089371418, 278.596056981041,
    278.533478404021, 278.457299600740, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 278.084632811174, 277.820012443785,
    277.847308696263, 277.849503278643, 277.798568623574, 277.797575835420, 278.095663099731,
    278.176160746854, 278.055153965908, 277.658857926577, 277.600990658349, 277.654026836536,
    277.704990323093, 277.793048321917, 277.910121578336, 277.820873697740, 277.745501713345,
    277.917800418041, 277.944391515021, 278.049145512055, 278.043694650275, 278.359223099294,
    278.070771695770, 278.214994954607, 278.330759821265, 278.205028068094, 278.559361787443,
    278.733217829340, 278.744268100279, 278.596208016795, 278.640483841563, 278.694916381717,
    278.907613386036, 278.818024141397, 278.832740735832, 278.864929258857, 279.066035941021,
    278.954370093400, 278.808689512194, 278.608053707239, 278.495744514278, 278.455081259502,
    278.372791655716, 278.141900258419, 278.157538472382, 278.129509127672, 278.226019505944,
    278.517786152116, 278.439174014992, 278.709414812548, 278.622228174999, 278.479038464346,
    278.411419063810, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 278.059317675418, 277.775909541424, 277.981685147100,
    277.820433102725, 277.757691649352, 277.791125337952, 278.114244862593, 278.017847302545,
    277.739587601083, 277.595204498445, 277.444481155752, 277.508867798333, 277.654580807842,
    277.801555631030, 277.946216001618, 277.717518898982, 277.766353468943, 277.682654248428,
    277.981754049258, 278.135151366502, 278.237042418896, 278.307870507241, 278.340706625625,
    278.321035354200, 278.320273358697, 278.158571181206, 278.405855009476, 278.698752162175,
    278.489714021957, 278.447399946515, 278.208281541154, 278.274999857765, 278.742819250719,
    278.267292067544, 278.472633364801, 278.954199073712, 278.507525942737, 278.740647038251,
    278.712056316088, 278.578495872832, 278.539513494423, 278.291124747294, 278.285971725264,
    278.217669844021, 278.204961536595, 278.111539468452, 277.987196715585, 278.301219174750,
    278.308770143463, 278.450474529455, 278.387913656980, 278.345354979068, 278.308192795967,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 278.078766967738, 278.054694472586, 277.996546131957, 277.478107514078,
    277.498293431515, 277.439272646630, 278.170812997380, 278.031766350648, 277.926719630068,
    277.660631490707, 277.405466505229, 277.448131221500, 277.639980374018, 277.771980499881,
    277.699632610951, 277.872363280302, 277.869398539167, 277.927769742648, 277.856196077938,
    278.052767006803, 278.215030316361, 277.961917700862, 278.291818910231, 278.337805197442,
    278.117323423329, 278.455733028684, 278.701018948664, 278.676322213600, 278.350822146256,
    278.266243351366, 278.328051517560, 278.614915559626, 278.558300997375, 278.813314535584,
    278.881108562772, 278.123693523522, 278.802821050470, 278.781438747715, 278.621781876457,
    278.564387365762, 278.583461368131, 278.350036130682, 278.383351889379, 278.383019058144,
    278.217555758541, 278.167422809838, 278.238477919987, 278.226153636247, 278.084761209123,
    278.088484041540, 278.083492218972, 278.205027655804, 278.230216899737, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    278.045557859900, 277.849040307617, 277.906197759880, 277.593465692124, 277.699758481137,
    277.871410461793, 278.058125626538, 278.204525836660, 277.952696685466, 277.738482364071,
    277.391817333672, 277.414211293355, 277.713291394110, 277.795254016927, 277.757654239367,
    277.707136929518, 277.820516499087, 277.833903133206, 277.958888974124, 277.727592050621,
    277.979297315556, 278.041516057377, 278.241728050372, 278.352662301885, 278.378421828891,
    278.668011089711, 278.720413573120, 278.293463018845, 278.471858803908, 278.456120759094,
    278.451834597551, 278.400966141086, 278.228702595541, 278.199778173421, 278.229599019782,
    278.763504882934, 278.797467161442, 278.406340958912, 278.639263357618, 278.738466024170,
    278.356147734832, 278.377301134964, 278.324739430270, 278.365219303220, 278.277074392752,
    278.246691447173, 278.325438536989, 278.410510194260, 278.004569449865, 277.972537483973,
    277.956821946510, 278.172942728027, 278.345344049598, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 277.996969175390,
    277.862497775047, 277.649762377272, 277.559149409384, 277.580356760509, 277.718009367429,
    278.068756822897, 277.878009666029, 277.969360198421, 277.610090666218, 277.828347857057,
    277.544325721216, 277.732583265551, 278.116016214294, 277.972299696618, 277.687262934771,
    277.957182102556, 277.863999567218, 278.051999720662, 278.158060596001, 278.155762387840,
    278.127890904723, 278.223511374158, 278.356916537157, 278.639719890896, 278.714037786705,
    278.558389050067, 278.315362526995, 278.636748281842, 278.421360309160, 278.615746331257,
    278.298886265158, 278.533659911339, 278.333792298766, 278.643055170670, 278.858025832867,
    279.020835079354, 278.870273814320, 278.740600676717, 278.482283444293, 278.534910048501,
    278.346778954967, 278.353117018506, 278.419908994646, 278.281125729824, 278.285144148911,
    278.365767158905, 278.333351670498, 277.972629892376, 277.989686782478, 278.095826308077,
    278.302698360631, 278.382668003966, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 277.875713517719, 277.634128413762,
    277.832973471346, 277.448621515103, 277.593144967346, 277.620070785560, 278.022268231048,
    277.650661530718, 277.728550931249, 277.789574269136, 277.607135652596, 277.558983827518,
    277.867823445271, 277.980868124118, 278.152155038418, 277.872425545108, 278.032213134824,
    278.055596269546, 277.794984263919, 277.846180947964, 278.137493702594, 278.095071965260,
    278.130969913741, 278.103726648322, 278.796162214483, 278.772300848655, 278.550498461136,
    278.394793765962, 278.623206154742, 278.611024899396, 278.578628218960, 278.276590748045,
    278.468413343561, 278.450779339504, 278.554459701664, 278.806252974651, 279.013699273923,
    278.748514001816, 278.788419863602, 278.642315613660, 278.454524896995, 278.491218667764,
    278.463773729676, 278.435969444734, 278.300796479766, 278.136749416946, 278.373140364489,
    278.132948804942, 278.027912210990, 278.148274414281, 278.336173789580, 278.280453796923,
    278.416601405752, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 277.958466871634, 277.914274026264, 277.771935237925,
    277.604840373088, 277.681191841525, 277.734814857704, 277.836253334677, 277.790546207519,
    277.679698274453, 277.762322999726, 277.735323729530, 277.547356221084, 277.724659181931,
    278.062792028695, 277.919073079645, 277.773076074541, 278.020996741625, 278.022325061818,
    277.919346621275, 277.950865675377, 278.008524131751, 278.023480753982, 277.924336723588,
    278.332258375312, 278.736366682898, 278.523695501482, 278.502092576710, 278.225439092820,
    278.256232776798, 278.449499552010, 278.137549943998, 278.422050300432, 278.431511965178,
    278.274661992411, 278.431568551580, 278.753808621318, 278.761885574921, 278.415607975957,
    278.555121959527, 278.654993170504, 278.544139116180, 278.520795378936, 278.533770309691,
    278.547957275597, 278.407434870158, 278.298762571130, 278.487164079960, 278.392357298054,
    278.268034972770, 278.187199824354, 278.276694644393, 278.256517908057, 278.378067854440,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 277.976299775529, 278.042031136275, 277.464188145920, 277.771621894762,
    277.784361473567, 277.859883815950, 277.814022087487, 277.852386883815, 277.843778414429,
    277.700529593730, 277.720782097285, 277.895752429155, 278.233578251075, 278.276392982912,
    277.953661711230, 277.591545218148, 277.985804556808, 277.938997069968, 277.916409711425,
    277.888611552732, 277.925456871836, 277.977042887254, 278.082218353152, 278.472003946117,
    278.646240659087, 278.404855822350, 278.163989456392, 277.954560473176, 278.556236453466,
    278.296451614769, 278.277688882445, 278.374637286269, 278.332791290590, 278.203289210287,
    278.562584129166, 278.329198281083, 278.823530241748, 278.763160870026, 278.543114999088,
    278.556718492736, 278.657498589218, 278.499789731658, 278.592487422433, 278.649244580966,
    278.669257850905, 278.201148346028, 278.586350077861, 278.457878133903, 278.245990792454,
    278.112034510986, 278.055946777769, 278.159436781041, 278.294828313829, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    278.055463728037, 277.938769906207, 277.908616747506, 277.697182984726, 277.767438599440,
    277.618954673948, 277.849284086165, 277.888500733412, 277.803726801356, 277.887984809149,
    277.963831684250, 278.063254030007, 278.264222060266, 278.247209209771, 278.010146150856,
    277.737515908542, 277.889412006510, 277.981344866797, 277.913904542254, 277.836061245756,
    277.808859499689, 277.970758433246, 278.239527080226, 278.275624726729, 278.397363141215,
    278.343527616747, 278.259845839951, 278.368292580968, 278.583172394714, 278.290379278148,
    278.385955212872, 278.352217326569, 278.420090515247, 278.134725529508, 278.418675419067,
    278.363034465810, 278.431779148022, 278.438454682849, 278.264539348808, 278.429698158323,
    278.607118714023, 278.464672697985, 278.443469155020, 278.604002661624, 278.807929770258,
    278.629594459038, 278.763699668360, 278.301897413578, 278.088831652212, 277.971815866599,
    277.908876996953, 277.949580119805, 277.929385688745, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 278.164247814763,
    278.017634128271, 278.126496201983, 278.041275562602, 277.963103307992, 277.882098915321,
    277.832817052899, 278.194630071008, 277.940734107132, 278.028855985157, 277.589337692257,
    278.007707016965, 278.159356263938, 278.097452374726, 277.964902829032, 277.890310856301,
    277.995095341973, 277.660207908446, 277.786361546086, 277.815119589775, 277.914655235766,
    278.276761510933, 278.028707200239, 278.334143087463, 278.232784850170, 278.182589303626,
    278.197293256951, 278.305926587915, 278.318792747211, 278.484167044288, 278.357400768639,
    278.328509261854, 278.448253183213, 278.163374893923, 278.104866385859, 278.044914087322,
    278.173224770928, 278.338413210359, 278.380896912261, 278.730673471804, 278.450424564609,
    278.503155223128, 278.491430165703, 278.474964969620, 278.246765035551, 278.931615118388,
    278.559599207653, 278.156636961710, 278.008740658705, 277.932135871154, 277.822627679854,
    277.736249285180, 277.878138412578, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 278.082480645173, 278.043241069493,
    277.697041095551, 277.989863518743, 277.717897740312, 277.701839125518, 277.861708621096,
    278.280953208980, 277.804372502188, 277.704826013697, 277.596403430525, 277.712365023901,
    278.034041843709, 277.947346670070, 277.846022907482, 277.820870191912, 277.874461715493,
    277.769161099427, 277.750268832592, 277.850701911325, 277.878534019060, 278.027904999404,
    278.090516114696, 278.109187477565, 278.190939004850, 278.278788556568, 278.380627825278,
    278.407390272678, 278.511725032938, 278.506674787575, 278.442874478011, 278.405398330435,
    278.395518040659, 278.357905587250, 278.210737031126, 278.122068999623, 278.170689655080,
    278.152435924905, 278.236404166308, 278.676963499355, 278.364031374287, 278.396399598455,
    278.375591815009, 278.342047071761, 278.407524619964, 278.529076426794, 278.148144221518,
    278.042521318864, 277.942078734795, 277.821562712711, 277.728530388654, 277.736969229001,
    277.907471093473, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 277.819603551272, 277.828647314803, 277.754535652466,
    277.824122707543, 277.762454320427, 277.748628587305, 278.031167797444, 277.857054897891,
    277.780437750936, 277.673341198976, 277.580777138276, 277.728655867446, 277.897137734936,
    277.750051876006, 277.442585133617, 277.536109280911, 277.666042104756, 277.637084619762,
    277.954517294964, 277.933011800326, 277.638355177335, 277.771459546012, 277.907366166404,
    278.038032680944, 278.223370782900, 278.077760957702, 278.513395348027, 278.519194273139,
    278.542309039934, 278.482080267916, 278.340394482155, 278.341759181533, 278.301704207586,
    278.255804929780, 278.195762993763, 278.152065600453, 278.109495057418, 278.225701450697,
    278.493902456915, 278.637437629165, 278.359832350456, 278.305034727926, 278.296015493113,
    278.356150546679, 278.036917652359, 277.636846916859, 278.031252957091, 278.053317552121,
    277.856967881711, 277.828489726312, 277.819981618468, 277.859938918796, 277.956551311373,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 277.884653219230, 277.884698802114, 277.844277877433, 277.934802186492,
    277.864463150351, 277.803952962222, 277.862512817816, 278.030331030810, 277.751952165263,
    277.680464702272, 277.585446567641, 277.958894193742, 277.524642689383, 277.589772555767,
    277.547487191290, 277.553287779719, 277.547903182893, 277.780326455565, 278.007585878669,
    277.822118711121, 277.682976359764, 277.843136947080, 277.894178961775, 277.954909292289,
    278.221226702389, 278.236512222249, 278.471628587781, 278.517076530718, 278.553486136797,
    278.548068978131, 278.394215898281, 278.289120256620, 278.234843510822, 278.157199428167,
    278.206792433064, 278.242705298579, 278.226263767876, 278.437906673139, 278.580162411397,
    278.567277080119, 278.296662334949, 278.275257848275, 278.404346162035, 278.002008395328,
    277.160000000000, 277.422452606158, 278.124308422995, 278.212576318432, 278.016005178567,
    277.861666847072, 277.831807919342, 277.987901581353, 278.061939469824, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    277.932091130649, 277.951064758320, 277.839412458507, 277.841315615141, 277.806577252520,
    277.842248927079, 277.988730868827, 277.881229491595, 277.827771128070, 277.852117171922,
    277.977131550724, 277.890734880932, 277.363447936035, 277.674357318546, 277.874045802482,
    277.619616361043, 277.959695749966, 278.034434774544, 278.011503092349, 277.792532523158,
    277.883473108928, 277.906659808602, 277.859039495732, 277.950830457718, 278.150472303852,
    278.280666827875, 278.497788485655, 278.510726053483, 278.601565268380, 278.496480151954,
    278.430095137542, 278.316738350851, 278.171640925745, 278.099215960220, 278.139092052815,
    278.217292849195, 278.260283772674, 278.395024109814, 278.411196388457, 278.432581257165,
    278.381536736126, 278.363111710685, 278.429680484566, 277.793989872273, 277.160000000000,
    277.160000000000, 278.256273592222, 278.264019723457, 278.140777061859, 277.960057434051,
    277.915191160621, 277.936547331889, 278.099249337367, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 277.917465588048,
    277.806536213298, 277.829468329766, 277.894769654517, 277.878874487338, 278.213198285885,
    277.882881751217, 277.892374439465, 277.858339532912, 277.923051748953, 277.681370662730,
    277.510761769121, 277.346031782172, 277.635591850736, 277.505752171465, 277.838565919297,
    278.145230449989, 278.110256581579, 277.857261961129, 277.892771986443, 277.933046869362,
    277.858290703051, 277.761688955039, 277.868954215183, 278.100209314485, 278.316913494119,
    278.444218906419, 278.557360529658, 278.561171208143, 278.461978486569, 278.557371359122,
    278.268552022994, 278.168263392393, 278.004287261093, 278.100378738598, 278.174276275285,
    278.571381129483, 278.432024829889, 278.351912980210, 278.426658874171, 278.422291931680,
    278.425551948989, 278.455607158869, 278.142898669707, 277.160000000000, 277.160000000000,
    278.358691525700, 278.271973931751, 278.175217065772, 278.113413453687, 278.060115945570,
    278.072147299547, 278.221325526498, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 277.947472331137, 277.986181501038,
    277.984568003653, 278.110290656444, 277.897470824458, 277.874164089902, 277.898939913517,
    277.902875083266, 277.889547948396, 277.798750008214, 277.895056427821, 277.559027635660,
    277.397787394390, 277.415750853834, 277.795000812736, 278.022111292969, 278.209968407002,
    278.081682250882, 278.091845240573, 277.941999949457, 277.909072268308, 277.784844781870,
    277.659181293741, 277.950679245143, 278.025258482602, 278.291405558634, 278.461051894477,
    278.543413260710, 278.637341256470, 278.536026584681, 278.345094023061, 278.314548843661,
    278.141679812436, 277.941455855832, 278.086647453443, 278.112323026882, 278.109913998848,
    278.098115462881, 278.381213778877, 278.424512212838, 278.401413477507, 278.394564786766,
    277.894149214730, 277.375874807682, 277.160000000000, 278.149965464308, 278.077148773966,
    278.225807651780, 278.284892879974, 278.351353534523, 278.240233215773, 278.349246487147,
    278.349466760844, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000, 288.000000000000,
    288.000000000000, 288.000000000000, 279.240455299468, 279.223818551588, 279.285849037670,
    279.376293488344, 279.461192356391, 279.551808319930, 279.628646083334, 279.652829397263,
    279.616525840893, 279.502069589155, 279.291108765522, 279.053106080215, 278.902689297837,
    278.875704607117, 278.947740010309, 279.107704342158, 279.293681458493, 279.389614320839,
    279.411224941796, 279.444212582782, 279.386698602138, 279.136632845345, 278.940936666674,
    279.114221831018, 279.555753115819, 279.953434278201, 280.226196904095, 280.405256334886,
    280.410401720828, 280.251580808077, 280.098019623178, 279.974301676744, 279.757509415710,
    279.521564884780, 279.499039528544, 279.701996418489, 279.925134655518, 280.065775204607,
    280.157363074379, 280.210875088178, 280.228483742292, 280.242147600516, 280.253696133409,
    280.268103214047, 280.320185953974, 280.334307179838, 280.179831259660, 279.974644702474,
    279.996541178206, 280.236144650250, 280.430297213138, 280.482837320704, 280.457167561948,
    280.368438239921, 280.237631095078, 280.139468565491, 280.058914690017, 279.931995170108,
    279.790325543831, 279.694221168621, 279.601661392615, 279.495094732655, 279.400305289408,
    279.315406421361, 279.170992589248, 279.122968987120, 279.185857037526, 279.307459658628,
    279.447414156257, 279.576963540092, 279.657803270340, 279.678727839839, 279.638593829489,
    279.510130693798, 279.301628221226, 279.100500801839, 278.988560072117, 278.974724701028,
    279.039385051036, 279.169048776781, 279.318322140061, 279.420543807447, 279.465423007055,
    279.468796093395, 279.383211173889, 279.191917158746, 279.053391934990, 279.156356824790,
    279.471311615411, 279.820168782296, 280.098305477953, 280.261471383277, 280.248379234602,
    280.089100954212, 279.926106561752, 279.809077617043, 279.659975766627, 279.501440708651,
    279.482574293529, 279.633677127367, 279.825485681103, 279.976645685896, 280.097276400764,
    280.174628702763, 280.192294527831, 280.188521244807, 280.196296494675, 280.219850928100,
    280.263243682879, 280.275020899592, 280.180917507803, 280.066804281795, 280.125290168672,
    280.362949828249, 280.587574510106, 280.668985949904, 280.616788868068, 280.490498228663,
    280.363864563528, 280.257412245478, 280.131064435118, 279.982362781387, 279.855843458162,
    279.757509415710, 279.634477520736, 279.518134627486, 279.422430448960, 279.301399537407,
    279.066598425575, 279.006454581005, 279.065626519341, 279.211698309147, 279.406079555854,
    279.575362753355, 279.659346886123, 279.668951606549, 279.614810712245, 279.477714762361,
    279.291623304116, 279.135260742427, 279.045559514167, 279.027379150504, 279.089638320405,
    279.211583967237, 279.338331974281, 279.433350101348, 279.488062705201, 279.486633431328,
    279.403907059567, 279.254061986738, 279.134288836193, 279.172764888850, 279.399447725084,
    279.708456736394, 279.964353930589, 280.087328654609, 280.053540620255, 279.905525017983,
    279.744302925125, 279.629846673388, 279.535743281599, 279.456733021908, 279.457876441006,
    279.562213433724, 279.709028445943, 279.857215561080, 280.002143931787, 280.100420803284,
    280.113627293870, 280.091559305273, 280.106995463100, 280.164566614698, 280.221223031018,
    280.227511836058, 280.166796281940, 280.117915115488, 280.205157992687, 280.436986214863,
    280.676989883592, 280.785042988379, 280.731302290760, 280.595006734245, 280.462141435025,
    280.330190871084, 280.161879579817, 280.001686564148, 279.887230312410, 279.769572487197,
    279.608579078159, 279.472969573104, 279.366345742189, 279.220731320023, 278.926872611765,
    278.881364531654, 278.941165350494, 279.107361316429, 279.349823336219, 279.555124235315,
    279.648370062780, 279.657231560791, 279.594858048980, 279.449300797769, 279.279102864990,
    279.156814192429, 279.084607276373, 279.061052842948, 279.111248941363, 279.216443498405,
    279.328441399081, 279.431749314611, 279.511274112896, 279.525624022579, 279.454617696576,
    279.326783441388, 279.211183770552, 279.203065494955, 279.353482277333, 279.594915219935,
    279.794384681630, 279.871851325538, 279.829087451263, 279.710686403636, 279.579536233063,
    279.486233234644, 279.434950888086, 279.410081522698, 279.424259919517, 279.498524989950,
    279.624358261716, 279.778090959479, 279.931023263874, 280.032330195982, 280.046737276620,
    280.015807790012, 280.018609166803, 280.078867353282, 280.150102363105, 280.176515344275,
    280.155247749047, 280.155933800506, 280.263815392429, 280.485638697495, 280.723469869937,
    280.847759525920, 280.806825122202, 280.666184573113, 280.512566217259, 280.352087346816,
    280.173428112710, 280.012091677942, 279.876825198616, 279.728295057749, 279.552723055209,
    279.402363443785, 279.254576525332, 279.074545188308, 278.792063500078, 278.765650518908,
    278.830882578465, 279.019032191087, 279.293738629448, 279.517277063162, 279.622357278294,
    279.646254737448, 279.592056672189, 279.448328891536, 279.283562199474, 279.169791999195,
    279.110905915633, 279.105703358736, 279.159043859671, 279.239997931829, 279.325754364200,
    279.426489586758, 279.520307123772, 279.551522465155, 279.502412614884, 279.403907059567,
    279.305458675206, 279.267725844962, 279.333072246429, 279.477371736632, 279.617554918081,
    279.673753966761, 279.623843723122, 279.509902009978, 279.398532989806, 279.334215665527,
    279.320437465393, 279.333072246429, 279.360399962878, 279.425917877209, 279.551751148975,
    279.712973241832, 279.857558586810, 279.950404217590, 279.981390875154, 279.965840375417,
    279.949546653266, 279.977160224490, 280.044278925559, 280.106423753550, 280.144328096658,
    280.197382742819, 280.319728586334, 280.514567200681, 280.716094816753, 280.831294290905,
    280.809912353767, 280.682078098579, 280.512966413944, 280.338595001456, 280.166338914300,
    279.997684597304, 279.819425559882, 279.641966915829, 279.479658574828, 279.323296013139,
    279.126284902505, 278.919611900491, 278.663943390116, 278.635872451253, 278.714768369034,
    278.939335879936, 279.234966887797, 279.462164262625, 279.579536233063, 279.613667293147,
    279.557754099241, 279.422258936095, 279.273099914724, 279.160301620679, 279.104045401044,
    279.120339123194, 279.186371576120, 279.254633696287, 279.324610945102, 279.415912960099,
    279.503327350163, 279.544947805340, 279.525223825895, 279.451873490740, 279.359942595239,
    279.299512895895, 279.299970263534, 279.366460084099, 279.468510238620, 279.518877849899,
    279.450730071642, 279.310718403058, 279.198949186201, 279.159386885400, 279.179282377710,
    279.227706176523, 279.276816026794, 279.339704077199, 279.455246577080, 279.610637232536,
    279.746761276187, 279.834861717709, 279.879798088271, 279.885629525673, 279.875395924743,
    279.895577271828, 279.960923673294, 280.039133539617, 280.106137898776, 280.185090987512,
    280.316469841904, 280.499531239539, 280.676532515953, 280.779268721933, 280.774980900315,
    280.668928778949, 280.494271511687, 280.303091838455, 280.126605100635, 279.943315019181,
    279.733497614647, 279.533456443403, 279.369032777070, 279.193232090709, 278.974724701028,
    278.776684513206, 278.477337393277, 278.425769191944, 278.545142145805, 278.845003804328,
    279.186257234210, 279.442668966999, 279.589884175903, 279.616983208532, 279.523623039157,
    279.377551249352, 279.241884573341, 279.128514569747, 279.069113947591, 279.093354432475,
    279.156013799060, 279.215357250261, 279.294424680907, 279.396417664474, 279.488805927615,
    279.561470211310, 279.584338593276, 279.506586094593, 279.365716861685, 279.260465133688,
    279.228049202252, 279.263152168569, 279.346850446563, 279.384926302536, 279.287735679182,
    279.118681165502, 279.009884838300, 278.999765579281, 279.055793115096, 279.139091196406,
    279.206552923204, 279.259093030770, 279.356112141259, 279.517105550297, 279.681186190900,
    279.784379764520, 279.807991368899, 279.779234378578, 279.764598614120, 279.813822806301,
    279.907468830450, 279.993796972370, 280.053540620255, 280.119458731271, 280.251409295212,
    280.463342025078, 280.675217583990, 280.789616664772, 280.782813321138, 280.675389096854,
    280.489526322429, 280.273134258080, 280.072292693467, 279.874195334690, 279.652486371533,
    279.437866606786, 279.233594784879, 279.015659104747, 278.793149748221, 278.609916837722,
    278.278039444447, 278.221211515262, 278.401014168466, 278.772568204452, 279.153212422270,
    279.444384095647, 279.618984191954, 279.628074373785, 279.498410648040, 279.344049069773,
    279.206610094159, 279.080376625709, 279.029322962971, 279.074373675443, 279.126685099190,
    279.162645629830, 279.242742137665, 279.351767148686, 279.452445200289, 279.569245461179,
    279.648770259464, 279.570846247916, 279.375721778795, 279.219645071880, 279.156013799060,
    279.166704767629, 279.232965904375, 279.254862380107, 279.131601801312, 278.940307786170,
    278.834598690534, 278.852035831783, 278.945624684977, 279.059509227166, 279.135375084336,
    279.175966462325, 279.264581442442, 279.446042053339, 279.658031954160, 279.793812972081,
    279.790782911470, 279.698680503104, 279.650028020472, 279.710629232681, 279.826171732562,
    279.931480631514, 280.008375565873, 280.071149274369, 280.185319671332, 280.405427847751,
    280.652120518204, 280.782241611589, 280.760745332541, 280.639542908123, 280.451907834096,
    280.226482758870, 280.002544128472, 279.780835165315, 279.552780226163, 279.330785408232,
    279.096041467356, 278.847748010164, 278.625009969819, 278.440576469267, 278.096350149730,
    278.070394536199, 278.305481502805, 278.723172499407, 279.140120273594, 279.458219466736,
    279.619441559593, 279.587482995796, 279.450272704003, 279.311976164066, 279.151897490307,
    278.991590132728, 278.964262416279, 279.057565414699, 279.110848744678, 279.115708275846,
    279.175451923731, 279.273671624273, 279.378923352270, 279.532427366214, 279.652257687714,
    279.582966490358, 279.372234350545, 279.184370592698, 279.073115914435, 279.055564431277,
    279.140348957414, 279.183455857419, 279.030009014430, 278.774740700739, 278.632785219688,
    278.674634358685, 278.827795346899, 278.977697590684, 279.039842418675, 279.051848319207,
    279.138576657812, 279.348279720436, 279.602690469803, 279.771058932025, 279.762711972608,
    279.633848640231, 279.556153312503, 279.607664342881, 279.721663226979, 279.841322035614,
    279.946287908836, 280.009804839746, 280.088243389888, 280.289885347869, 280.563848563817,
    280.727185982006, 280.709577327893, 280.579627747373, 280.394736879182, 280.175657779951,
    279.933024247296, 279.673182257212, 279.415970131054, 279.180025600124, 278.938421144658,
    278.683210001922, 278.455841114229, 278.261631380386, 277.941131007138, 277.966000372526,
    278.239391878925, 278.690642226061, 279.154870379962, 279.488577243795, 279.591484962640,
    279.499382554274, 279.378065787946, 279.270984589392, 279.083235173455, 278.890283200620,
    278.882622292662, 279.001137682198, 279.046359907535, 279.033553613635, 279.073458940165,
    279.153498277044, 279.279102864990, 279.478858181460, 279.608007368610, 279.522536791014,
    279.321638055446, 279.132745220410, 278.967120964025, 278.916810523700, 279.055735944141,
    279.162588458876, 278.986158892011, 278.647764009875, 278.455212233725, 278.525875533999,
    278.751586463999, 278.936991870785, 278.962775971451, 278.923213670651, 279.010285034985,
    279.265381835811, 279.562499288499, 279.744017070351, 279.719890927377, 279.567816187306,
    279.484632447906, 279.544033070062, 279.658603663709, 279.771058932025, 279.864419101400,
    279.899522067717, 279.941314035759, 280.136266992016, 280.447905867252, 280.660295964757,
    280.667213650302, 280.534005325352, 280.343283019759, 280.121574056603, 279.869335803522,
    279.580336626432, 279.282304438465, 279.009084444932, 278.747527326200, 278.486313233198,
    278.257286387813, 278.072967229170, 277.832734876621, 277.928782080877, 278.259516055054,
    278.741524375934, 279.215242908351, 279.510416548572, 279.531626972845, 279.398304305986,
    279.305801700935, 279.217586917503, 279.013715292280, 278.826308902072, 278.825336995838,
    278.901088511099, 278.911836650623, 278.914523685504, 278.944767120653, 278.984443763364,
    279.143607701844, 279.421115516997, 279.532198682394, 279.369490144709, 279.175623436596,
    279.045273659392, 278.877476906720, 278.808128538409, 278.992847893736, 279.154127157548,
    278.970494050365, 278.596996201912, 278.388550900295, 278.466303398978, 278.711623966514,
    278.898973185767, 278.883880053670, 278.801782562413, 278.914009146910, 279.254004815783,
    279.617497747126, 279.797872109880, 279.722920987987, 279.523508697248, 279.433064246574,
    279.512074506265, 279.634420349781, 279.724636116635, 279.773059915447, 279.762197434013,
    279.783636542106, 279.992196185632, 280.333335273604, 280.578827354005, 280.616388671383,
    280.501589393916, 280.301891248401, 280.061601724898, 279.796328494097, 279.497438741807,
    279.181626386862, 278.861812065073, 278.555661601509, 278.284156736622, 278.068336381822,
    277.909000930477
};

#define ILCHAM 3128
#define NSTRON 10
#define NSMAX 31
#define NMSMAX 31

int main(int argc, char* argv[])
{
    grib_handle* h = NULL;
    size_t len     = 0;
    const char* outfile;

    assert(argc == 2);
    outfile = argv[1];

    GRIB_CHECK(((h = grib_handle_new_from_samples(NULL, "regular_ll_pl_grib2")) == NULL), 0);
    /*GRIB_CHECK (((h = grib_handle_new_from_samples (NULL, "reduced_gg_ml_grib2")) == NULL), 0);*/
    len = strlen("lambert");
    GRIB_CHECK(grib_set_string(h, "gridType", "lambert", &len), 0);

    GRIB_CHECK(grib_set_long(h, "centre", 85), 0);

    GRIB_CHECK(grib_set_long(h, "grib2LocalSectionPresent", 1), 0);
    GRIB_CHECK(grib_set_long(h, "grib2LocalSectionNumber", 1), 0);
    len = strlen("SURFTEMPERATURE");
    GRIB_CHECK(grib_set_string(h, "faFieldName", "SURFTEMPERATURE", &len), 0);

    GRIB_CHECK(grib_set_long(h, "Nx", 64), 0);
    GRIB_CHECK(grib_set_long(h, "Ny", 64), 0);
    GRIB_CHECK(grib_set_double(h, "DxInMetres", 2500.00000000000), 0);
    GRIB_CHECK(grib_set_double(h, "DyInMetres", 2500.00000000000), 0);
    GRIB_CHECK(grib_set_long(h, "iScansNegatively", 0), 0);
    GRIB_CHECK(grib_set_long(h, "jScansPositively", 1), 0);
    GRIB_CHECK(grib_set_long(h, "jPointsAreConsecutive", 0), 0);
    GRIB_CHECK(grib_set_long(h, "uvRelativeToGrid", 1), 0);
    GRIB_CHECK(grib_set_double(h, "latitudeOfFirstGridPointInDegrees", 66.7684949529709), 0);
    GRIB_CHECK(grib_set_double(h, "longitudeOfFirstGridPointInDegrees", 25.1580207144963), 0);
    GRIB_CHECK(grib_set_double(h, "latitudeOfSouthernPoleInDegrees", 0.000000000000000E+000), 0);
    GRIB_CHECK(grib_set_double(h, "longitudeOfSouthernPoleInDegrees", 0.000000000000000E+000), 0);
    GRIB_CHECK(grib_set_double(h, "LaDInDegrees", 67.3600000000000), 0);
    GRIB_CHECK(grib_set_double(h, "LoVInDegrees", 26.6400000000000), 0);
    GRIB_CHECK(grib_set_double(h, "Latin1InDegrees", 67.3600000000000), 0);
    GRIB_CHECK(grib_set_double(h, "Latin2InDegrees", 67.3600000000000), 0);
    GRIB_CHECK(grib_set_long(h, "projectionCentreFlag", 0), 0);
    GRIB_CHECK(grib_set_long(h, "NV", 0), 0);
    GRIB_CHECK(grib_set_long(h, "year", 2009), 0);
    GRIB_CHECK(grib_set_long(h, "month", 5), 0);
    GRIB_CHECK(grib_set_long(h, "day", 28), 0);
    GRIB_CHECK(grib_set_long(h, "hour", 0), 0);
    GRIB_CHECK(grib_set_long(h, "minute", 0), 0);
    GRIB_CHECK(grib_set_long(h, "second", 0), 0);
    len = strlen("s");
    GRIB_CHECK(grib_set_string(h, "indicatorOfUnitOfTimeRange", "s", &len), 0);

    GRIB_CHECK(grib_set_long(h, "scaledValueOfFirstFixedSurface", 0), 0);

    len = strlen("s");
    GRIB_CHECK(grib_set_string(h, "stepUnits", "s", &len), 0);
    GRIB_CHECK(grib_set_long(h, "endStep", 3600), 0);
    GRIB_CHECK(grib_set_long(h, "bitsPerValue", 16), 0);
    len = strlen("grid_simple");
    GRIB_CHECK(grib_set_string(h, "packingType", "grid_simple", &len), 0);
    GRIB_CHECK(grib_set_long(h, "numberOfDataPoints", 4096), 0);

    len = sizeof(values) / sizeof(values[0]);
    GRIB_CHECK(grib_set_double_array(h, "values", values, len), 0);
    len = strlen("SURFTEMPERATURE");
    GRIB_CHECK(grib_set_string(h, "CLNOMA", "SURFTEMPERATURE", &len), 0);
    GRIB_CHECK(grib_set_long(h, "INGRIB", 120), 0);
    GRIB_CHECK(grib_set_long(h, "LLCOSP", 0), 0);
    GRIB_CHECK(grib_set_long(h, "INBITS", 16), 0);

    GRIB_CHECK(grib_write_message(h, outfile, "w"), 0);

    GRIB_CHECK(grib_handle_delete(h), 0);

    printf("ALL OK\n");
    return 0;
}
