/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "TestTransformationManager.h"



// For better test error messages
char* camitk::toString(const camitk::FrameOfReference& frame) {
    return QTest::toString("Frame " + frame.getName());
}

QString camitk::toString(const vtkSmartPointer<vtkMatrix4x4>& m) {
    return (m == nullptr) ? QString("\nNULL MATRIX\n") :
           QString("\n  %1, %2, %3, %4\n  %5, %6, %7, %8\n  %9, %10, %11, %12\n  %13, %14, %15, %16\n").arg(
               m->GetElement(0, 0)).arg(m->GetElement(0, 1)).arg(m->GetElement(0, 2)).arg(m->GetElement(0, 3)).arg(
               m->GetElement(1, 0)).arg(m->GetElement(1, 1)).arg(m->GetElement(1, 2)).arg(m->GetElement(1, 3)).arg(
               m->GetElement(2, 0)).arg(m->GetElement(2, 1)).arg(m->GetElement(2, 2)).arg(m->GetElement(2, 3)).arg(
               m->GetElement(3, 0)).arg(m->GetElement(3, 1)).arg(m->GetElement(3, 2)).arg(m->GetElement(3, 3));
}

char* camitk::toString(const camitk::Transformation& tr) {
    auto m = vtkSmartPointer<vtkMatrix4x4>::New();
    tr.getTransform()->GetMatrix(m);
    return QTest::toString("Transformation(" + tr.getName() + QString("\n  %1, %2, %3, %4\n  %5, %6, %7, %8\n  %9, %10, %11, %12\n  %13, %14, %15, %16\n)").arg(
                               m->GetElement(0, 0)).arg(m->GetElement(0, 1)).arg(m->GetElement(0, 2)).arg(m->GetElement(0, 3)).arg(
                               m->GetElement(1, 0)).arg(m->GetElement(1, 1)).arg(m->GetElement(1, 2)).arg(m->GetElement(1, 3)).arg(
                               m->GetElement(2, 0)).arg(m->GetElement(2, 1)).arg(m->GetElement(2, 2)).arg(m->GetElement(2, 3)).arg(
                               m->GetElement(3, 0)).arg(m->GetElement(3, 1)).arg(m->GetElement(3, 2)).arg(m->GetElement(3, 3)));
}


QTEST_MAIN(TestTransformationManager)
