#define XERR "memoryaccess"
#include "memoryaccess.ih"

// truncate.cc updates d_maxSize and ensures that
//             newSize <= d_nBlocks * d_blockSize

// if truncate's new size is less than d_writtenUntil then the bytes
// from the new size till d_writtenUntil are set to 0, 

    // by truncate.cc

void MemoryAccess::setZero(size_t from)
{
    size_t toDo = d_writtenUntil - from;      // #bytes to set to 0

    while (toDo > 0)
    {
        load(from);                         // from is OK, set by truncate

        size_t avail = min(d_writtenUntil, d_blockEnd) - from;
        memset(ptr(from), 0, avail);
        toDo -= avail;
        from = d_blockEnd;
    }
}

