/*
 * Copyright (c) 2017 - 2021, Broadcom
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef USBH_XHCI_REGS_H
#define USBH_XHCI_REGS_H

#include <lib/mmio.h>
#include <platform_def.h>

#define XHCI_LEN (8096U)

#define XHC_CPLIVER_OFFSET			0x000U
#define XHC_SPARAMS1_OFFSET			0x004U
#define XHC_SPARAMS2_OFFSET			0x008U
#define XHC_SPARAMS3_OFFSET			0x00cU
#define XHC_CPARAMS1_OFFSET			0x010U
#define XHC_DBOFF_OFFSET			0x014U
#define XHC_RTOFF_OFFSET			0x018U
#define XHC_CPARAMS2_OFFSET			0x01cU
#define XHC_USBCMD_OFFSET			0x020U
#define XHC_USBSTS_OFFSET			0x024U
#define XHC_PAGESIZE_OFFSET			0x028U
#define XHC_DNCTRL_OFFSET			0x034U
#define XHC_CRCRL_OFFSET			0x038U
#define XHC_CRCRH_OFFSET			0x03cU
#define XHC_DCBAAPL_OFFSET			0x050U
#define XHC_DCBAAPH_OFFSET			0x054U
#define XHC_CONFIG_OFFSET			0x058U
#define XHC_PORTSC1_OFFSET			0x420U
#define XHC_PORTPM1_OFFSET			0x424U
#define XHC_PORTLC1_OFFSET			0x428U
#define XHC_PORTSC2_OFFSET			0x430U
#define XHC_PORTPM2_OFFSET			0x434U
#define XHC_PORTLC2_OFFSET			0x43cU
#define XHC_PORTSC3_OFFSET			0x440U
#define XHC_PORTPM3_OFFSET			0x444U
#define XHC_PORTLI3_OFFSET			0x44cU
#define XHC_MFINDEX_OFFSET			0x4a0U
#define XHC_IMAN0_OFFSET			0x4c0U
#define XHC_IMOD0_OFFSET			0x4c4U
#define XHC_ERSTSZ0_OFFSET			0x4c8U
#define XHC_ERSTBAL0_OFFSET			0x4d0U
#define XHC_ERSTBAH0_OFFSET			0x4d4U
#define XHC_ERDPL0_OFFSET			0x4d8U
#define XHC_ERDPH0_OFFSET			0x4dcU
#define XHC_IMAN1_OFFSET			0x4e0U
#define XHC_IMOD1_OFFSET			0x4e4U
#define XHC_ERSTSZ1_OFFSET			0x4e8U
#define XHC_ERSTBAL1_OFFSET			0x4f0U
#define XHC_ERSTBAH1_OFFSET			0x4f4U
#define XHC_ERDPL1_OFFSET			0x4f8U
#define XHC_ERDPH1_OFFSET			0x4fcU
#define XHC_DBLCMD_OFFSET			0x8c0U
#define XHC_DBLDVX1_OFFSET			0x8c4U
#define XHC_DBLDVX2_OFFSET			0x8c8U
#define XHC_DBLDVX3_OFFSET			0x8ccU
#define XHC_DBLDVX4_OFFSET			0x8d0U
#define XHC_DBLDVX5_OFFSET			0x8d4U
#define XHC_DBLDVX6_OFFSET			0x8d8U
#define XHC_DBLDVX7_OFFSET			0x8dcU
#define XHC_DBLDVX8_OFFSET			0x8e0U
#define XHC_DBLDVX9_OFFSET			0x8e4U
#define XHC_DBLDVX10_OFFSET			0x8e8U
#define XHC_DBLDVX11_OFFSET			0x8ecU
#define XHC_DBLDVX12_OFFSET			0x8f0U
#define XHC_DBLDVX13_OFFSET			0x8f4U
#define XHC_DBLDVX14_OFFSET			0x8f8U
#define XHC_DBLDVX15_OFFSET			0x8fcU
#define XHC_DBLDVX16_OFFSET			0x900U
#define XHC_ECHSPT3_OFFSET			0x940U
#define XHC_PNSTR3_OFFSET			0x944U
#define XHC_PSUM3_OFFSET			0x948U
#define XHC_PTSLTYP3_OFFSET			0x94cU
#define XHC_ECHSPT2_OFFSET			0x950U
#define XHC_PNSTR2_OFFSET			0x954U
#define XHC_PSUM2_OFFSET			0x958U
#define XHC_PTSLTYP2_OFFSET			0x95cU
#define XHC_ECHRSVP_OFFSET			0x960U
#define XHC_ECHRSVI_OFFSET			0x968U
#define XHC_ECHRSVM_OFFSET			0xae8U
#define XHC_ECHRSVD_OFFSET			0xaf8U
#define XHC_ECHRSVO_OFFSET			0xb38U
#define XHC_ECHCTT_OFFSET			0xbf0U
#define XHC_CTTMTS0_OFFSET			0xbf8U
#define XHC_CTTMTS1_OFFSET			0xbfcU
#define XHC_ECHBIU_OFFSET			0xc00U
#define XHC_BIUSPC_OFFSET			0xc04U
#define XHC_AXIWRA_OFFSET			0xc08U
#define XHC_AXIRDA_OFFSET			0xc0cU
#define XHC_AXILPM_OFFSET			0xc10U
#define XHC_AXIQOS_OFFSET			0xc14U
#define XHC_ECHCSR_OFFSET			0xc20U
#define XHC_CSRSPC_OFFSET			0xc24U
#define XHC_ECHAIU_OFFSET			0xc30U
#define XHC_AIUDMA_OFFSET			0xc34U
#define XHC_AIUFLA_OFFSET			0xc38U
#define XHC_AIUCFG_OFFSET			0xc3cU
#define XHC_ECHFSC_OFFSET			0xc40U
#define XHC_FSCPOC_OFFSET			0xc54U
#define XHC_FSCGOC_OFFSET			0xc58U
#define XHC_FSCNOC_OFFSET			0xc5cU
#define XHC_FSCAIC_OFFSET			0xc60U
#define XHC_FSCPIC_OFFSET			0xc64U
#define XHC_FSCGIC_OFFSET			0xc68U
#define XHC_FSCNIC_OFFSET			0xc6cU
#define XHC_ECHPRT_OFFSET			0xc70U
#define XHC_PRTHSC_OFFSET			0xc78U
#define XHC_PRTHSR_OFFSET			0xc7cU
#define XHC_ECHRHS_OFFSET			0xc80U
#define XHC_RHSDES_OFFSET			0xc84U
#define XHC_RHSHSC0_OFFSET			0xc90U
#define XHC_RHSHSR0_OFFSET			0xc94U
#define XHC_RHSHSC1_OFFSET			0xc98U
#define XHC_RHSHSR1_OFFSET			0xc9cU
#define XHC_RHSHSC2_OFFSET			0xca0U
#define XHC_RHSHSR2_OFFSET			0xca4U
#define XHC_RHSHSC3_OFFSET			0xca8U
#define XHC_RHSHSR3_OFFSET			0xcacU
#define XHC_ECHSSP_OFFSET			0xcb0U
#define XHC_SSPVER_OFFSET			0xcb4U
#define XHC_SSPMGN_OFFSET			0xcb8U
#define XHC_ECHFSC2_OFFSET			0xcc0U
#define XHC_FSC2POC_OFFSET			0xcd4U
#define XHC_FSC2GOC_OFFSET			0xcd8U
#define XHC_FSC2NOC_OFFSET			0xcdcU
#define XHC_FSC2AIC_OFFSET			0xce0U
#define XHC_FSC2PIC_OFFSET			0xce4U
#define XHC_FSC2GIC_OFFSET			0xce8U
#define XHC_FSC2NIC_OFFSET			0xcecU
#define XHC_ECHPRT2_OFFSET			0xcf0U
#define XHC_PRT2HSC_OFFSET			0xcf8U
#define XHC_PRT2HSR_OFFSET			0xcfcU
#define XHC_ECHRH2_OFFSET			0xd00U
#define XHC_RH2DES_OFFSET			0xd04U
#define XHC_RH2HSC0_OFFSET			0xd10U
#define XHC_RH2HSR0_OFFSET			0xd14U
#define XHC_RH2HSC1_OFFSET			0xd18U
#define XHC_RH2HSR1_OFFSET			0xd1cU
#define XHC_RH2HSC2_OFFSET			0xd20U
#define XHC_RH2HSR2_OFFSET			0xd24U
#define XHC_RH2HSC3_OFFSET			0xd28U
#define XHC_RH2HSR3_OFFSET			0xd2cU
#define XHC_ECHU2P_OFFSET			0xd30U
#define XHC_U2PVER_OFFSET			0xd34U
#define XHC_U2PMGN_OFFSET			0xd38U
#define XHC_ECHRSV2_OFFSET			0xd40U
#define XHC_ECHIRA_OFFSET			0xf90U
#define XHC_IRAADR_OFFSET			0xf98U
#define XHC_IRADAT_OFFSET			0xf9cU
#define XHC_ECHHST_OFFSET			0xfa0U
#define XHC_HSTDBG_OFFSET			0xfa4U
#define XHC_HSTNPL_OFFSET			0xfa8U
#define XHC_HSTNPH_OFFSET			0xfacU
#define XHC_ECHRBV_OFFSET			0xfb0U
#define XHC_RBVPDT_OFFSET			0xfb4U
#define XHC_RBVMGN_OFFSET			0xfbcU

#define XHC_CPLIVER_BASE			0x000U
#define XHC_CPLIVER__IVH_L			31U
#define XHC_CPLIVER__IVH_R			24U
#define XHC_CPLIVER__IVH_WIDTH			8U
#define XHC_CPLIVER__IVH_RESETVALUE		0x01U
#define XHC_CPLIVER__IVL_L			23U
#define XHC_CPLIVER__IVL_R			16U
#define XHC_CPLIVER__IVL_WIDTH			8U
#define XHC_CPLIVER__IVL_RESETVALUE		0x10U
#define XHC_CPLIVER__reserved_L			15U
#define XHC_CPLIVER__reserved_R			8U
#define XHC_CPLIVER__reserved_WIDTH		8U
#define XHC_CPLIVER__reserved_RESETVALUE	0x00U
#define XHC_CPLIVER__CPL_L			7U
#define XHC_CPLIVER__CPL_R			0U
#define XHC_CPLIVER__CPL_WIDTH			8U
#define XHC_CPLIVER__CPL_RESETVALUE		0x00U
#define XHC_CPLIVER_WIDTH			32U
#define XHC_CPLIVER__WIDTH			32U
#define XHC_CPLIVER_ALL_L			31U
#define XHC_CPLIVER_ALL_R			0U
#define XHC_CPLIVER__ALL_L			31U
#define XHC_CPLIVER__ALL_R			0U
#define XHC_CPLIVER_DATAMASK			0xffffffffU
#define XHC_CPLIVER_RDWRMASK			0x00000000U
#define XHC_CPLIVER_RESETVALUE			0x01100000U

#define XHC_SPARAMS1_OFFSET			0x004U
#define XHC_SPARAMS1_BASE			0x004U
#define XHC_SPARAMS1__NPTS_L			31U
#define XHC_SPARAMS1__NPTS_R			24U
#define XHC_SPARAMS1__NPTS_WIDTH		8U
#define XHC_SPARAMS1__NPTS_RESETVALUE		0x00U
#define XHC_SPARAMS1__reserved_L		23U
#define XHC_SPARAMS1__reserved_R		19U
#define XHC_SPARAMS1__reserved_WIDTH		5U
#define XHC_SPARAMS1__reserved_RESETVALUE	0x0U
#define XHC_SPARAMS1__MITS_L			18U
#define XHC_SPARAMS1__MITS_R			8U
#define XHC_SPARAMS1__MITS_WIDTH		11U
#define XHC_SPARAMS1__MITS_RESETVALUE		0x1U
#define XHC_SPARAMS1__MSLS_L			7U
#define XHC_SPARAMS1__MSLS_R			0U
#define XHC_SPARAMS1__MSLS_WIDTH		8U
#define XHC_SPARAMS1__MSLS_RESETVALUE		0x00U
#define XHC_SPARAMS1_WIDTH			32U
#define XHC_SPARAMS1__WIDTH			32U
#define XHC_SPARAMS1_ALL_L			31U
#define XHC_SPARAMS1_ALL_R			0U
#define XHC_SPARAMS1__ALL_L			31U
#define XHC_SPARAMS1__ALL_R			0U
#define XHC_SPARAMS1_DATAMASK			0xffffffffU
#define XHC_SPARAMS1_RDWRMASK			0x00000000U
#define XHC_SPARAMS1_RESETVALUE			0x00000100U

#define XHC_SPARAMS2_OFFSET			0x008U
#define XHC_SPARAMS2_BASE			0x008U
#define XHC_SPARAMS2__MSPBSL_L			31U
#define XHC_SPARAMS2__MSPBSL_R			27U
#define XHC_SPARAMS2__MSPBSL_WIDTH		5U
#define XHC_SPARAMS2__MSPBSL_RESETVALUE		0x0U
#define XHC_SPARAMS2__SPR			26U
#define XHC_SPARAMS2__SPR_L			26U
#define XHC_SPARAMS2__SPR_R			26U
#define XHC_SPARAMS2__SPR_WIDTH			1U
#define XHC_SPARAMS2__SPR_RESETVALUE		0x1U
#define XHC_SPARAMS2__MSPBSH_L			25U
#define XHC_SPARAMS2__MSPBSH_R			21U
#define XHC_SPARAMS2__MSPBSH_WIDTH		5U
#define XHC_SPARAMS2__MSPBSH_RESETVALUE		0x0U
#define XHC_SPARAMS2__reserved_L		20U
#define XHC_SPARAMS2__reserved_R		8U
#define XHC_SPARAMS2__reserved_WIDTH		13U
#define XHC_SPARAMS2__reserved_RESETVALUE	0x0U
#define XHC_SPARAMS2__MERST_L			7U
#define XHC_SPARAMS2__MERST_R			4U
#define XHC_SPARAMS2__MERST_WIDTH		4U
#define XHC_SPARAMS2__MERST_RESETVALUE		0x0U
#define XHC_SPARAMS2__IST_L			3U
#define XHC_SPARAMS2__IST_R			0U
#define XHC_SPARAMS2__IST_WIDTH			4U
#define XHC_SPARAMS2__IST_RESETVALUE		0x0U
#define XHC_SPARAMS2_WIDTH			32U
#define XHC_SPARAMS2__WIDTH			32U
#define XHC_SPARAMS2_ALL_L			31U
#define XHC_SPARAMS2_ALL_R			0U
#define XHC_SPARAMS2__ALL_L			31U
#define XHC_SPARAMS2__ALL_R			0U
#define XHC_SPARAMS2_DATAMASK			0xffffffffU
#define XHC_SPARAMS2_RDWRMASK			0x00000000U
#define XHC_SPARAMS2_RESETVALUE			0x04000000U

#define XHC_SPARAMS3_OFFSET			0x00cU
#define XHC_SPARAMS3_BASE			0x00cU
#define XHC_SPARAMS3__U2L_L			31U
#define XHC_SPARAMS3__U2L_R			16U
#define XHC_SPARAMS3__U2L_WIDTH			16U
#define XHC_SPARAMS3__U2L_RESETVALUE		0x0000U
#define XHC_SPARAMS3__reserved_L		15U
#define XHC_SPARAMS3__reserved_R		8U
#define XHC_SPARAMS3__reserved_WIDTH		8U
#define XHC_SPARAMS3__reserved_RESETVALUE	0x00U
#define XHC_SPARAMS3__U1L_L			7U
#define XHC_SPARAMS3__U1L_R			0U
#define XHC_SPARAMS3__U1L_WIDTH			8U
#define XHC_SPARAMS3__U1L_RESETVALUE		0x00U
#define XHC_SPARAMS3_WIDTH			32U
#define XHC_SPARAMS3__WIDTH			32U
#define XHC_SPARAMS3_ALL_L			31U
#define XHC_SPARAMS3_ALL_R			0U
#define XHC_SPARAMS3__ALL_L			31U
#define XHC_SPARAMS3__ALL_R			0U
#define XHC_SPARAMS3_DATAMASK			0xffffffffU
#define XHC_SPARAMS3_RDWRMASK			0x00000000U
#define XHC_SPARAMS3_RESETVALUE			0x00000000U

#define XHC_CPARAMS1_OFFSET			0x010U
#define XHC_CPARAMS1_BASE			0x010U
#define XHC_CPARAMS1__XECP_L			31U
#define XHC_CPARAMS1__XECP_R			16U
#define XHC_CPARAMS1__XECP_WIDTH		16U
#define XHC_CPARAMS1__XECP_RESETVALUE		0x0000U
#define XHC_CPARAMS1__MPSA_L			15U
#define XHC_CPARAMS1__MPSA_R			12U
#define XHC_CPARAMS1__MPSA_WIDTH		4U
#define XHC_CPARAMS1__MPSA_RESETVALUE		0x0U
#define XHC_CPARAMS1__CFC			11U
#define XHC_CPARAMS1__CFC_L			11U
#define XHC_CPARAMS1__CFC_R			11U
#define XHC_CPARAMS1__CFC_WIDTH			1U
#define XHC_CPARAMS1__CFC_RESETVALUE		0x0U
#define XHC_CPARAMS1__SEC			10U
#define XHC_CPARAMS1__SEC_L			10U
#define XHC_CPARAMS1__SEC_R			10U
#define XHC_CPARAMS1__SEC_WIDTH			1U
#define XHC_CPARAMS1__SEC_RESETVALUE		0x0U
#define XHC_CPARAMS1__SPC			9U
#define XHC_CPARAMS1__SPC_L			9U
#define XHC_CPARAMS1__SPC_R			9U
#define XHC_CPARAMS1__SPC_WIDTH			1U
#define XHC_CPARAMS1__SPC_RESETVALUE		0x0U
#define XHC_CPARAMS1__PAE			8U
#define XHC_CPARAMS1__PAE_L			8U
#define XHC_CPARAMS1__PAE_R			8U
#define XHC_CPARAMS1__PAE_WIDTH			1U
#define XHC_CPARAMS1__PAE_RESETVALUE		0x1U
#define XHC_CPARAMS1__NSS			7U
#define XHC_CPARAMS1__NSS_L			7U
#define XHC_CPARAMS1__NSS_R			7U
#define XHC_CPARAMS1__NSS_WIDTH			1U
#define XHC_CPARAMS1__NSS_RESETVALUE		0x0U
#define XHC_CPARAMS1__LTC			6U
#define XHC_CPARAMS1__LTC_L			6U
#define XHC_CPARAMS1__LTC_R			6U
#define XHC_CPARAMS1__LTC_WIDTH			1U
#define XHC_CPARAMS1__LTC_RESETVALUE		0x1U
#define XHC_CPARAMS1__LRC			5U
#define XHC_CPARAMS1__LRC_L			5U
#define XHC_CPARAMS1__LRC_R			5U
#define XHC_CPARAMS1__LRC_WIDTH			1U
#define XHC_CPARAMS1__LRC_RESETVALUE		0x0U
#define XHC_CPARAMS1__PIND			4U
#define XHC_CPARAMS1__PIND_L			4U
#define XHC_CPARAMS1__PIND_R			4U
#define XHC_CPARAMS1__PIND_WIDTH		1U
#define XHC_CPARAMS1__PIND_RESETVALUE		0x0U

#define XHC_CPARAMS1__PPC_L			3U
#define XHC_CPARAMS1__PPC_R			3U
#define XHC_CPARAMS1__PPC_WIDTH			1U
#define XHC_CPARAMS1__PPC_RESETVALUE		0x0U
#define XHC_CPARAMS1__CSZ			2U
#define XHC_CPARAMS1__CSZ_L			2U
#define XHC_CPARAMS1__CSZ_R			2U
#define XHC_CPARAMS1__CSZ_WIDTH			1U
#define XHC_CPARAMS1__CSZ_RESETVALUE		0x1U
#define XHC_CPARAMS1__BNC			1U
#define XHC_CPARAMS1__BNC_L			1U
#define XHC_CPARAMS1__BNC_R			1U
#define XHC_CPARAMS1__BNC_WIDTH			1U
#define XHC_CPARAMS1__BNC_RESETVALUE		0x0U
#define XHC_CPARAMS1__AC64			0U
#define XHC_CPARAMS1__AC64_L			0U
#define XHC_CPARAMS1__AC64_R			0U
#define XHC_CPARAMS1__AC64_WIDTH		1U
#define XHC_CPARAMS1__AC64_RESETVALUE		0x0U
#define XHC_CPARAMS1_WIDTH			32U
#define XHC_CPARAMS1__WIDTH			32U
#define XHC_CPARAMS1_ALL_L			31U
#define XHC_CPARAMS1_ALL_R			0U
#define XHC_CPARAMS1__ALL_L			31U
#define XHC_CPARAMS1__ALL_R			0U
#define XHC_CPARAMS1_DATAMASK			0xffffffffU
#define XHC_CPARAMS1_RDWRMASK			0x00000000U
#define XHC_CPARAMS1_RESETVALUE			0x00000144U

#define XHC_DBOFF_OFFSET			0x014U
#define XHC_DBOFF_BASE				0x014U
#define XHC_DBOFF__DBO_L			15U
#define XHC_DBOFF__DBO_R			2U
#define XHC_DBOFF__DBO_WIDTH			14U
#define XHC_DBOFF__DBO_RESETVALUE		0x0U
#define XHC_DBOFF__reserved_L			1U
#define XHC_DBOFF__reserved_R			0U
#define XHC_DBOFF__reserved_WIDTH		2U
#define XHC_DBOFF__reserved_RESETVALUE		0x0U
#define XHC_DBOFF__RESERVED_L			31U
#define XHC_DBOFF__RESERVED_R			16U
#define XHC_DBOFF_WIDTH				16U
#define XHC_DBOFF__WIDTH			16U
#define XHC_DBOFF_ALL_L				15U
#define XHC_DBOFF_ALL_R				0U
#define XHC_DBOFF__ALL_L			15U
#define XHC_DBOFF__ALL_R			0U
#define XHC_DBOFF_DATAMASK			0x0000ffffU
#define XHC_DBOFF_RDWRMASK			0xffff0000U
#define XHC_DBOFF_RESETVALUE			0x0000U

#define XHC_RTOFF_OFFSET			0x018U
#define XHC_RTOFF_BASE				0x018U
#define XHC_RTOFF__RTO_L			15U
#define XHC_RTOFF__RTO_R			5U
#define XHC_RTOFF__RTO_WIDTH			11U
#define XHC_RTOFF__RTO_RESETVALUE		0x0U
#define XHC_RTOFF__reserved_L			4U
#define XHC_RTOFF__reserved_R			0U
#define XHC_RTOFF__reserved_WIDTH		5U
#define XHC_RTOFF__reserved_RESETVALUE		0x0U
#define XHC_RTOFF__RESERVED_L			31U
#define XHC_RTOFF__RESERVED_R			16U
#define XHC_RTOFF_WIDTH				16U
#define XHC_RTOFF__WIDTH			16U
#define XHC_RTOFF_ALL_L				15U
#define XHC_RTOFF_ALL_R				0U
#define XHC_RTOFF__ALL_L			15U
#define XHC_RTOFF__ALL_R			0U
#define XHC_RTOFF_DATAMASK			0x0000ffffU
#define XHC_RTOFF_RDWRMASK			0xffff0000U
#define XHC_RTOFF_RESETVALUE			0x0000U

#define XHC_CPARAMS2_OFFSET			0x01cU
#define XHC_CPARAMS2_BASE			0x01cU
#define XHC_CPARAMS2__reserved_L		31U
#define XHC_CPARAMS2__reserved_R		6U
#define XHC_CPARAMS2__reserved_WIDTH		26U
#define XHC_CPARAMS2__reserved_RESETVALUE	0x0U
#define XHC_CPARAMS2__CIC			5U
#define XHC_CPARAMS2__CIC_L			5U
#define XHC_CPARAMS2__CIC_R			5U
#define XHC_CPARAMS2__CIC_WIDTH			1U
#define XHC_CPARAMS2__CIC_RESETVALUE		0x0U
#define XHC_CPARAMS2__LEC			4U
#define XHC_CPARAMS2__LEC_L			4U
#define XHC_CPARAMS2__LEC_R			4U
#define XHC_CPARAMS2__LEC_WIDTH			1U
#define XHC_CPARAMS2__LEC_RESETVALUE		0x0U
#define XHC_CPARAMS2__CTC			3U
#define XHC_CPARAMS2__CTC_L			3U
#define XHC_CPARAMS2__CTC_R			3U
#define XHC_CPARAMS2__CTC_WIDTH			1U
#define XHC_CPARAMS2__CTC_RESETVALUE		0x0U
#define XHC_CPARAMS2__FSC			2U
#define XHC_CPARAMS2__FSC_L			2U
#define XHC_CPARAMS2__FSC_R			2U
#define XHC_CPARAMS2__FSC_WIDTH			1U
#define XHC_CPARAMS2__FSC_RESETVALUE		0x0U
#define XHC_CPARAMS2__CMC			1U
#define XHC_CPARAMS2__CMC_L			1U
#define XHC_CPARAMS2__CMC_R			1U
#define XHC_CPARAMS2__CMC_WIDTH			1U
#define XHC_CPARAMS2__CMC_RESETVALUE		0x0U
#define XHC_CPARAMS2__U3C			0U
#define XHC_CPARAMS2__U3C_L			0U
#define XHC_CPARAMS2__U3C_R			0U
#define XHC_CPARAMS2__U3C_WIDTH			1U
#define XHC_CPARAMS2__U3C_RESETVALUE		0x0U
#define XHC_CPARAMS2_WIDTH			32U
#define XHC_CPARAMS2__WIDTH			32U
#define XHC_CPARAMS2_ALL_L			31U
#define XHC_CPARAMS2_ALL_R			0U
#define XHC_CPARAMS2__ALL_L			31U
#define XHC_CPARAMS2__ALL_R			0U
#define XHC_CPARAMS2_DATAMASK			0xffffffffU
#define XHC_CPARAMS2_RDWRMASK			0x00000000U
#define XHC_CPARAMS2_RESETVALUE			0x00000000U

#define XHC_USBCMD_OFFSET			0x020U
#define XHC_USBCMD_BASE				0x020U
#define XHC_USBCMD__CME				13U
#define XHC_USBCMD__CME_L			13U
#define XHC_USBCMD__CME_R			13U
#define XHC_USBCMD__CME_WIDTH			1U
#define XHC_USBCMD__CME_RESETVALUE		0x0U
#define XHC_USBCMD__SPE				12U
#define XHC_USBCMD__SPE_L			12U
#define XHC_USBCMD__SPE_R			12U
#define XHC_USBCMD__SPE_WIDTH			1U
#define XHC_USBCMD__SPE_RESETVALUE		0x0U
#define XHC_USBCMD__EU3S			11U
#define XHC_USBCMD__EU3S_L			11U
#define XHC_USBCMD__EU3S_R			11U
#define XHC_USBCMD__EU3S_WIDTH			1U
#define XHC_USBCMD__EU3S_RESETVALUE		0x0U
#define XHC_USBCMD__EWE				10U
#define XHC_USBCMD__EWE_L			10U
#define XHC_USBCMD__EWE_R			10U
#define XHC_USBCMD__EWE_WIDTH			1U
#define XHC_USBCMD__EWE_RESETVALUE		0x0U
#define XHC_USBCMD__CRS				9U
#define XHC_USBCMD__CRS_L			9U
#define XHC_USBCMD__CRS_R			9U
#define XHC_USBCMD__CRS_WIDTH			1U
#define XHC_USBCMD__CRS_RESETVALUE		0x0U
#define XHC_USBCMD__CSS				8U
#define XHC_USBCMD__CSS_L			8U
#define XHC_USBCMD__CSS_R			8U
#define XHC_USBCMD__CSS_WIDTH			1U
#define XHC_USBCMD__CSS_RESETVALUE		0x0U
#define XHC_USBCMD__LRST			7U
#define XHC_USBCMD__LRST_L			7U
#define XHC_USBCMD__LRST_R			7U
#define XHC_USBCMD__LRST_WIDTH			1U
#define XHC_USBCMD__LRST_RESETVALUE		0x0U
#define XHC_USBCMD__reserved_L			6U
#define XHC_USBCMD__reserved_R			4U
#define XHC_USBCMD__reserved_WIDTH		3U
#define XHC_USBCMD__reserved_RESETVALUE		0x0U
#define XHC_USBCMD__HSEE			3U
#define XHC_USBCMD__HSEE_L			3U
#define XHC_USBCMD__HSEE_R			3U
#define XHC_USBCMD__HSEE_WIDTH			1U
#define XHC_USBCMD__HSEE_RESETVALUE		0x0U
#define XHC_USBCMD__INTE			2U
#define XHC_USBCMD__INTE_L			2U
#define XHC_USBCMD__INTE_R			2U
#define XHC_USBCMD__INTE_WIDTH			1U
#define XHC_USBCMD__INTE_RESETVALUE		0x0U
#define XHC_USBCMD__RST				1U
#define XHC_USBCMD__RST_L			1U
#define XHC_USBCMD__RST_R			1U
#define XHC_USBCMD__RST_WIDTH			1U
#define XHC_USBCMD__RST_RESETVALUE		0x0U
#define XHC_USBCMD__RS				0U
#define XHC_USBCMD__RS_L			0U
#define XHC_USBCMD__RS_R			0U
#define XHC_USBCMD__RS_WIDTH			1U
#define XHC_USBCMD__RS_RESETVALUE		0x0U
#define XHC_USBCMD__RESERVED_L			31U
#define XHC_USBCMD__RESERVED_R			14U
#define XHC_USBCMD_WIDTH			14U
#define XHC_USBCMD__WIDTH			14U
#define XHC_USBCMD_ALL_L			13U
#define XHC_USBCMD_ALL_R			0U
#define XHC_USBCMD__ALL_L			13U
#define XHC_USBCMD__ALL_R			0U
#define XHC_USBCMD_DATAMASK			0x00003fffU
#define XHC_USBCMD_RDWRMASK			0xffffc000U
#define XHC_USBCMD_RESETVALUE			0x0000U

#define XHC_USBSTS_OFFSET			0x024U
#define XHC_USBSTS_BASE				0x024U
#define XHC_USBSTS__CE				12U
#define XHC_USBSTS__CE_L			12U
#define XHC_USBSTS__CE_R			12U
#define XHC_USBSTS__CE_WIDTH			1U
#define XHC_USBSTS__CE_RESETVALUE		0x0U
#define XHC_USBSTS__CNR				11U
#define XHC_USBSTS__CNR_L			11U
#define XHC_USBSTS__CNR_R			11U
#define XHC_USBSTS__CNR_WIDTH			1U
#define XHC_USBSTS__CNR_RESETVALUE		0x1U

#define XHC_USBSTS__SRE				10U
#define XHC_USBSTS__SRE_L			10U
#define XHC_USBSTS__SRE_R			10U
#define XHC_USBSTS__SRE_WIDTH			1U
#define XHC_USBSTS__SRE_RESETVALUE		0x0U
#define XHC_USBSTS__RSS				9U
#define XHC_USBSTS__RSS_L			9U
#define XHC_USBSTS__RSS_R			9U
#define XHC_USBSTS__RSS_WIDTH			1U
#define XHC_USBSTS__RSS_RESETVALUE		0x0U
#define XHC_USBSTS__SSS				8U
#define XHC_USBSTS__SSS_L			8U
#define XHC_USBSTS__SSS_R			8U
#define XHC_USBSTS__SSS_WIDTH			1U
#define XHC_USBSTS__SSS_RESETVALUE		0x0U
#define XHC_USBSTS__PCD				4U
#define XHC_USBSTS__PCD_L			4U
#define XHC_USBSTS__PCD_R			4U
#define XHC_USBSTS__PCD_WIDTH			1U
#define XHC_USBSTS__PCD_RESETVALUE		0x0U
#define XHC_USBSTS__EINT			3U
#define XHC_USBSTS__EINT_L			3U
#define XHC_USBSTS__EINT_R			3U
#define XHC_USBSTS__EINT_WIDTH			1U
#define XHC_USBSTS__EINT_RESETVALUE		0x0U
#define XHC_USBSTS__HSE				2U
#define XHC_USBSTS__HSE_L			2U
#define XHC_USBSTS__HSE_R			2U
#define XHC_USBSTS__HSE_WIDTH			1U
#define XHC_USBSTS__HSE_RESETVALUE		0x0U
#define XHC_USBSTS__reserved			1U
#define XHC_USBSTS__reserved_L			1U
#define XHC_USBSTS__reserved_R			1U
#define XHC_USBSTS__reserved_WIDTH		1U
#define XHC_USBSTS__reserved_RESETVALUE		0x0U

#define XHC_USBSTS__CH_L			0U
#define XHC_USBSTS__CH_R			0U
#define XHC_USBSTS__CH_WIDTH			1U
#define XHC_USBSTS__CH_RESETVALUE		0x1U
#define XHC_USBSTS__RESERVED_L			31U
#define XHC_USBSTS__RESERVED_R			13U
#define XHC_USBSTS_WIDTH			13U
#define XHC_USBSTS__WIDTH			13U
#define XHC_USBSTS_ALL_L			12U
#define XHC_USBSTS_ALL_R			0U
#define XHC_USBSTS__ALL_L			12U
#define XHC_USBSTS__ALL_R			0U
#define XHC_USBSTS_DATAMASK			0x00001f1fU
#define XHC_USBSTS_RDWRMASK			0xffffe0e0U
#define XHC_USBSTS_RESETVALUE			0x0801U

#define XHC_PAGESIZE_OFFSET			0x028U
#define XHC_PAGESIZE_BASE			0x028U
#define XHC_PAGESIZE__reserved_L		31U
#define XHC_PAGESIZE__reserved_R		16U
#define XHC_PAGESIZE__reserved_WIDTH		16U
#define XHC_PAGESIZE__reserved_RESETVALUE	0x0000U
#define XHC_PAGESIZE__PS_L			15U
#define XHC_PAGESIZE__PS_R			0U
#define XHC_PAGESIZE__PS_WIDTH			16U
#define XHC_PAGESIZE__PS_RESETVALUE		0x0000U
#define XHC_PAGESIZE_WIDTH			32U
#define XHC_PAGESIZE__WIDTH			32U
#define XHC_PAGESIZE_ALL_L			31U
#define XHC_PAGESIZE_ALL_R			0U
#define XHC_PAGESIZE__ALL_L			31U
#define XHC_PAGESIZE__ALL_R			0U
#define XHC_PAGESIZE_DATAMASK			0xffffffffU
#define XHC_PAGESIZE_RDWRMASK			0x00000000U
#define XHC_PAGESIZE_RESETVALUE			0x00000000U

#define XHC_DNCTRL_OFFSET			0x034U
#define XHC_DNCTRL_BASE				0x034U
#define XHC_DNCTRL__reserved_L			31U
#define XHC_DNCTRL__reserved_R			16U
#define XHC_DNCTRL__reserved_WIDTH		16U
#define XHC_DNCTRL__reserved_RESETVALUE		0x0000U
#define XHC_DNCTRL__DNE_L			15U
#define XHC_DNCTRL__DNE_R			0U
#define XHC_DNCTRL__DNE_WIDTH			16U
#define XHC_DNCTRL__DNE_RESETVALUE		0x0000U
#define XHC_DNCTRL_WIDTH			32U
#define XHC_DNCTRL__WIDTH			32U
#define XHC_DNCTRL_ALL_L			31U
#define XHC_DNCTRL_ALL_R			0U
#define XHC_DNCTRL__ALL_L			31U
#define XHC_DNCTRL__ALL_R			0U
#define XHC_DNCTRL_DATAMASK			0xffffffffU
#define XHC_DNCTRL_RDWRMASK			0x00000000U
#define XHC_DNCTRL_RESETVALUE			0x00000000U

#define XHC_CRCRL_OFFSET			0x038U
#define XHC_CRCRL_BASE				0x038U
#define XHC_CRCRL__CRPL_L			31U
#define XHC_CRCRL__CRPL_R			6U
#define XHC_CRCRL__CRPL_WIDTH			26U
#define XHC_CRCRL__CRPL_RESETVALUE		0x0U
#define XHC_CRCRL__reserved_L			5U
#define XHC_CRCRL__reserved_R			4U
#define XHC_CRCRL__reserved_WIDTH		2U
#define XHC_CRCRL__reserved_RESETVALUE		0x0U
#define XHC_CRCRL__CRR				3U
#define XHC_CRCRL__CRR_L			3U
#define XHC_CRCRL__CRR_R			3U
#define XHC_CRCRL__CRR_WIDTH			1U
#define XHC_CRCRL__CRR_RESETVALUE		0x0U
#define XHC_CRCRL__CA				2U
#define XHC_CRCRL__CA_L				2U
#define XHC_CRCRL__CA_R				2U
#define XHC_CRCRL__CA_WIDTH			1U
#define XHC_CRCRL__CA_RESETVALUE		0x0U
#define XHC_CRCRL__CS				1U
#define XHC_CRCRL__CS_L				1U
#define XHC_CRCRL__CS_R				1U
#define XHC_CRCRL__CS_WIDTH			1U
#define XHC_CRCRL__CS_RESETVALUE		0x0U
#define XHC_CRCRL__RCS				0U
#define XHC_CRCRL__RCS_L			0U
#define XHC_CRCRL__RCS_R			0U
#define XHC_CRCRL__RCS_WIDTH			1U
#define XHC_CRCRL__RCS_RESETVALUE		0x0U
#define XHC_CRCRL_WIDTH				32U
#define XHC_CRCRL__WIDTH			32U
#define XHC_CRCRL_ALL_L				31U
#define XHC_CRCRL_ALL_R				0U
#define XHC_CRCRL__ALL_L			31U
#define XHC_CRCRL__ALL_R			0U
#define XHC_CRCRL_DATAMASK			0xffffffffU
#define XHC_CRCRL_RDWRMASK			0x00000000U
#define XHC_CRCRL_RESETVALUE			0x00000000U

#define XHC_CRCRH_OFFSET			0x03cU
#define XHC_CRCRH_BASE				0x03cU
#define XHC_CRCRH__CRPH_L			31U
#define XHC_CRCRH__CRPH_R			0U
#define XHC_CRCRH__CRPH_WIDTH			32U
#define XHC_CRCRH__CRPH_RESETVALUE		0x00000000U
#define XHC_CRCRH_WIDTH				32U
#define XHC_CRCRH__WIDTH			32U
#define XHC_CRCRH_ALL_L				31U
#define XHC_CRCRH_ALL_R				0U
#define XHC_CRCRH__ALL_L			31U
#define XHC_CRCRH__ALL_R			0U
#define XHC_CRCRH_DATAMASK			0xffffffffU
#define XHC_CRCRH_RDWRMASK			0x00000000U
#define XHC_CRCRH_RESETVALUE			0x00000000U

#define XHC_DCBAAPL_OFFSET			0x050U
#define XHC_DCBAAPL_BASE			0x050U
#define XHC_DCBAAPL__DCAL_L			31U
#define XHC_DCBAAPL__DCAL_R			6U
#define XHC_DCBAAPL__DCAL_WIDTH			26U
#define XHC_DCBAAPL__DCAL_RESETVALUE		0x0U

#define XHC_DCBAAPL__reserved_L			5U
#define XHC_DCBAAPL__reserved_R			0U
#define XHC_DCBAAPL__reserved_WIDTH		6U
#define XHC_DCBAAPL__reserved_RESETVALUE	0x0U
#define XHC_DCBAAPL_WIDTH			32U
#define XHC_DCBAAPL__WIDTH			32U
#define XHC_DCBAAPL_ALL_L			31U
#define XHC_DCBAAPL_ALL_R			0U
#define XHC_DCBAAPL__ALL_L			31U
#define XHC_DCBAAPL__ALL_R			0U
#define XHC_DCBAAPL_DATAMASK			0xffffffffU
#define XHC_DCBAAPL_RDWRMASK			0x00000000U
#define XHC_DCBAAPL_RESETVALUE			0x00000000U

#define XHC_DCBAAPH_OFFSET			0x054U
#define XHC_DCBAAPH_BASE			0x054U
#define XHC_DCBAAPH__DCAH_L			31U
#define XHC_DCBAAPH__DCAH_R			0U
#define XHC_DCBAAPH__DCAH_WIDTH			32U
#define XHC_DCBAAPH__DCAH_RESETVALUE		0x00000000U
#define XHC_DCBAAPH_WIDTH			32U
#define XHC_DCBAAPH__WIDTH			32U
#define XHC_DCBAAPH_ALL_L			31U
#define XHC_DCBAAPH_ALL_R			0U
#define XHC_DCBAAPH__ALL_L			31U
#define XHC_DCBAAPH__ALL_R			0U
#define XHC_DCBAAPH_DATAMASK			0xffffffffU
#define XHC_DCBAAPH_RDWRMASK			0x00000000U
#define XHC_DCBAAPH_RESETVALUE			0x00000000U

#define XHC_CONFIG_OFFSET			0x058U
#define XHC_CONFIG_BASE				0x058U
#define XHC_CONFIG__reserved_L			31U
#define XHC_CONFIG__reserved_R			10U
#define XHC_CONFIG__reserved_WIDTH		22U
#define XHC_CONFIG__reserved_RESETVALUE		0x0U
#define XHC_CONFIG__CIE				9U
#define XHC_CONFIG__CIE_L			9U
#define XHC_CONFIG__CIE_R			9U
#define XHC_CONFIG__CIE_WIDTH			1U
#define XHC_CONFIG__CIE_RESETVALUE		0x0U
#define XHC_CONFIG__U3E				8U
#define XHC_CONFIG__U3E_L			8U
#define XHC_CONFIG__U3E_R			8U
#define XHC_CONFIG__U3E_WIDTH			1U
#define XHC_CONFIG__U3E_RESETVALUE		0x0U
#define XHC_CONFIG__MSE_L			7U
#define XHC_CONFIG__MSE_R			0U
#define XHC_CONFIG__MSE_WIDTH			8U
#define XHC_CONFIG__MSE_RESETVALUE		0x00U
#define XHC_CONFIG_WIDTH			32U
#define XHC_CONFIG__WIDTH			32U
#define XHC_CONFIG_ALL_L			31U
#define XHC_CONFIG_ALL_R			0U
#define XHC_CONFIG__ALL_L			31U
#define XHC_CONFIG__ALL_R			0U
#define XHC_CONFIG_DATAMASK			0xffffffffU
#define XHC_CONFIG_RDWRMASK			0x00000000U
#define XHC_CONFIG_RESETVALUE			0x00000000U

#define XHC_PORTSC1_OFFSET			0x420U
#define XHC_PORTSC1_BASE			0x420U

#define XHC_PORTSC1__WPR_L			31U
#define XHC_PORTSC1__WPR_R			31U
#define XHC_PORTSC1__WPR_WIDTH			1U
#define XHC_PORTSC1__WPR_RESETVALUE		0x0U

#define XHC_PORTSC1__DNR_L			30U
#define XHC_PORTSC1__DNR_R			30U
#define XHC_PORTSC1__DNR_WIDTH			1U
#define XHC_PORTSC1__DNR_RESETVALUE		0x0U

#define XHC_PORTSC1__WOE_L			27U
#define XHC_PORTSC1__WOE_R			27U
#define XHC_PORTSC1__WOE_WIDTH			1U
#define XHC_PORTSC1__WOE_RESETVALUE		0x0U

#define XHC_PORTSC1__WDE_L			26U
#define XHC_PORTSC1__WDE_R			26U
#define XHC_PORTSC1__WDE_WIDTH			1U
#define XHC_PORTSC1__WDE_RESETVALUE		0x0U

#define XHC_PORTSC1__WCE_L			25U
#define XHC_PORTSC1__WCE_R			25U
#define XHC_PORTSC1__WCE_WIDTH			1U
#define XHC_PORTSC1__WCE_RESETVALUE		0x0U

#define XHC_PORTSC1__CAS_L			24U
#define XHC_PORTSC1__CAS_R			24U
#define XHC_PORTSC1__CAS_WIDTH			1U
#define XHC_PORTSC1__CAS_RESETVALUE		0x0U

#define XHC_PORTSC1__CEC_L			23U
#define XHC_PORTSC1__CEC_R			23U
#define XHC_PORTSC1__CEC_WIDTH			1U
#define XHC_PORTSC1__CEC_RESETVALUE		0x0U

#define XHC_PORTSC1__PLC_L			22U
#define XHC_PORTSC1__PLC_R			22U
#define XHC_PORTSC1__PLC_WIDTH			1U
#define XHC_PORTSC1__PLC_RESETVALUE		0x0U

#define XHC_PORTSC1__PRC_L			21U
#define XHC_PORTSC1__PRC_R			21U
#define XHC_PORTSC1__PRC_WIDTH			1U
#define XHC_PORTSC1__PRC_RESETVALUE		0x0U

#define XHC_PORTSC1__OCC_L			20U
#define XHC_PORTSC1__OCC_R			20U
#define XHC_PORTSC1__OCC_WIDTH			1U
#define XHC_PORTSC1__OCC_RESETVALUE		0x0U

#define XHC_PORTSC1__WRC_L			19U
#define XHC_PORTSC1__WRC_R			19U
#define XHC_PORTSC1__WRC_WIDTH			1U
#define XHC_PORTSC1__WRC_RESETVALUE		0x0U

#define XHC_PORTSC1__PEC_L			18U
#define XHC_PORTSC1__PEC_R			18U
#define XHC_PORTSC1__PEC_WIDTH			1U
#define XHC_PORTSC1__PEC_RESETVALUE		0x0U

#define XHC_PORTSC1__CSC_L			17U
#define XHC_PORTSC1__CSC_R			17U
#define XHC_PORTSC1__CSC_WIDTH			1U
#define XHC_PORTSC1__CSC_RESETVALUE		0x0U

#define XHC_PORTSC1__LWS_L			16U
#define XHC_PORTSC1__LWS_R			16U
#define XHC_PORTSC1__LWS_WIDTH			1U
#define XHC_PORTSC1__LWS_RESETVALUE		0x0U
#define XHC_PORTSC1__PIC_L			15U
#define XHC_PORTSC1__PIC_R			14U
#define XHC_PORTSC1__PIC_WIDTH			2U
#define XHC_PORTSC1__PIC_RESETVALUE		0x0U
#define XHC_PORTSC1__PS_L			13U
#define XHC_PORTSC1__PS_R			10U
#define XHC_PORTSC1__PS_WIDTH			4U
#define XHC_PORTSC1__PS_RESETVALUE		0x0U

#define XHC_PORTSC1__PP_L			9U
#define XHC_PORTSC1__PP_R			9U
#define XHC_PORTSC1__PP_WIDTH			1U
#define XHC_PORTSC1__PP_RESETVALUE		0x0U
#define XHC_PORTSC1__PLS_L			8U
#define XHC_PORTSC1__PLS_R			5U
#define XHC_PORTSC1__PLS_WIDTH			4U
#define XHC_PORTSC1__PLS_RESETVALUE		0x5U

#define XHC_PORTSC1__PRST_L			4U
#define XHC_PORTSC1__PRST_R			4U
#define XHC_PORTSC1__PRST_WIDTH			1U
#define XHC_PORTSC1__PRST_RESETVALUE		0x0U

#define XHC_PORTSC1__OCA_L			3U
#define XHC_PORTSC1__OCA_R			3U
#define XHC_PORTSC1__OCA_WIDTH			1U
#define XHC_PORTSC1__OCA_RESETVALUE		0x0U
#define XHC_PORTSC1__reserved			2U
#define XHC_PORTSC1__reserved_L			2U
#define XHC_PORTSC1__reserved_R			2U
#define XHC_PORTSC1__reserved_WIDTH		1U
#define XHC_PORTSC1__reserved_RESETVALUE	0x0U

#define XHC_PORTSC1__PED_L			1U
#define XHC_PORTSC1__PED_R			1U
#define XHC_PORTSC1__PED_WIDTH			1U
#define XHC_PORTSC1__PED_RESETVALUE		0x0U

#define XHC_PORTSC1__CCS_L			0U
#define XHC_PORTSC1__CCS_R			0U
#define XHC_PORTSC1__CCS_WIDTH			1U
#define XHC_PORTSC1__CCS_RESETVALUE		0x0U
#define XHC_PORTSC1__RESERVED_L			29U
#define XHC_PORTSC1__RESERVED_R			28U
#define XHC_PORTSC1_WIDTH			32U
#define XHC_PORTSC1__WIDTH			32U
#define XHC_PORTSC1_ALL_L			31U
#define XHC_PORTSC1_ALL_R			0U
#define XHC_PORTSC1__ALL_L			31U
#define XHC_PORTSC1__ALL_R			0U
#define XHC_PORTSC1_DATAMASK			0xcfffffffU
#define XHC_PORTSC1_RDWRMASK			0x30000000U
#define XHC_PORTSC1_RESETVALUE			0x000000a0U

#define XHC_PORTPM1_OFFSET			0x424U
#define XHC_PORTPM1_BASE			0x424U
#define XHC_PORTPM1__reserved_L			31U
#define XHC_PORTPM1__reserved_R			17U
#define XHC_PORTPM1__reserved_WIDTH		15U
#define XHC_PORTPM1__reserved_RESETVALUE	0x0U
#define XHC_PORTPM1__FLA			16U
#define XHC_PORTPM1__FLA_L			16U
#define XHC_PORTPM1__FLA_R			16U
#define XHC_PORTPM1__FLA_WIDTH			1U
#define XHC_PORTPM1__FLA_RESETVALUE		0x0U
#define XHC_PORTPM1__U2T_L			15U
#define XHC_PORTPM1__U2T_R			8U
#define XHC_PORTPM1__U2T_WIDTH			8U
#define XHC_PORTPM1__U2T_RESETVALUE		0x00U
#define XHC_PORTPM1__U1T_L			7U
#define XHC_PORTPM1__U1T_R			0U
#define XHC_PORTPM1__U1T_WIDTH			8U
#define XHC_PORTPM1__U1T_RESETVALUE		0x00U
#define XHC_PORTPM1_WIDTH			32U
#define XHC_PORTPM1__WIDTH			32U
#define XHC_PORTPM1_ALL_L			31U
#define XHC_PORTPM1_ALL_R			0U
#define XHC_PORTPM1__ALL_L			31U
#define XHC_PORTPM1__ALL_R			0U
#define XHC_PORTPM1_DATAMASK			0xffffffffU
#define XHC_PORTPM1_RDWRMASK			0x00000000U
#define XHC_PORTPM1_RESETVALUE			0x00000000U

#define XHC_PORTLC1_OFFSET			0x428U
#define XHC_PORTLC1_BASE			0x428U
#define XHC_PORTLC1__reserved_L			31U
#define XHC_PORTLC1__reserved_R			0U
#define XHC_PORTLC1__reserved_WIDTH		32U
#define XHC_PORTLC1__reserved_RESETVALUE	0x00000000U
#define XHC_PORTLC1_WIDTH			32U
#define XHC_PORTLC1__WIDTH			32U
#define XHC_PORTLC1_ALL_L			31U
#define XHC_PORTLC1_ALL_R			0U
#define XHC_PORTLC1__ALL_L			31U
#define XHC_PORTLC1__ALL_R			0U
#define XHC_PORTLC1_DATAMASK			0xffffffffU
#define XHC_PORTLC1_RDWRMASK			0x00000000U
#define XHC_PORTLC1_RESETVALUE			0x00000000U

#define XHC_PORTSC2_OFFSET			0x430U
#define XHC_PORTSC2_BASE			0x430U
#define XHC_PORTSC2__WPR			31U
#define XHC_PORTSC2__WPR_L			31U
#define XHC_PORTSC2__WPR_R			31U
#define XHC_PORTSC2__WPR_WIDTH			1U
#define XHC_PORTSC2__WPR_RESETVALUE		0x0U
#define XHC_PORTSC2__DNR			30U
#define XHC_PORTSC2__DNR_L			30U
#define XHC_PORTSC2__DNR_R			30U
#define XHC_PORTSC2__DNR_WIDTH			1U
#define XHC_PORTSC2__DNR_RESETVALUE		0x0U
#define XHC_PORTSC2__WOE			27U
#define XHC_PORTSC2__WOE_L			27U
#define XHC_PORTSC2__WOE_R			27U
#define XHC_PORTSC2__WOE_WIDTH			1U
#define XHC_PORTSC2__WOE_RESETVALUE		0x0U
#define XHC_PORTSC2__WDE			26U
#define XHC_PORTSC2__WDE_L			26U
#define XHC_PORTSC2__WDE_R			26U
#define XHC_PORTSC2__WDE_WIDTH			1U
#define XHC_PORTSC2__WDE_RESETVALUE		0x0U
#define XHC_PORTSC2__WCE			25U
#define XHC_PORTSC2__WCE_L			25U
#define XHC_PORTSC2__WCE_R			25U
#define XHC_PORTSC2__WCE_WIDTH			1U
#define XHC_PORTSC2__WCE_RESETVALUE		0x0U
#define XHC_PORTSC2__CAS			24U
#define XHC_PORTSC2__CAS_L			24U
#define XHC_PORTSC2__CAS_R			24U
#define XHC_PORTSC2__CAS_WIDTH			1U
#define XHC_PORTSC2__CAS_RESETVALUE		0x0U
#define XHC_PORTSC2__CEC			23U
#define XHC_PORTSC2__CEC_L			23U
#define XHC_PORTSC2__CEC_R			23U
#define XHC_PORTSC2__CEC_WIDTH			1U
#define XHC_PORTSC2__CEC_RESETVALUE		0x0U
#define XHC_PORTSC2__PLC			22U
#define XHC_PORTSC2__PLC_L			22U
#define XHC_PORTSC2__PLC_R			22U
#define XHC_PORTSC2__PLC_WIDTH			1U
#define XHC_PORTSC2__PLC_RESETVALUE		0x0U
#define XHC_PORTSC2__PRC			21U
#define XHC_PORTSC2__PRC_L			21U
#define XHC_PORTSC2__PRC_R			21U
#define XHC_PORTSC2__PRC_WIDTH			1U
#define XHC_PORTSC2__PRC_RESETVALUE		0x0U
#define XHC_PORTSC2__OCC			20U
#define XHC_PORTSC2__OCC_L			20U
#define XHC_PORTSC2__OCC_R			20U
#define XHC_PORTSC2__OCC_WIDTH			1U
#define XHC_PORTSC2__OCC_RESETVALUE		0x0U
#define XHC_PORTSC2__WRC			19U
#define XHC_PORTSC2__WRC_L			19U
#define XHC_PORTSC2__WRC_R			19U
#define XHC_PORTSC2__WRC_WIDTH			1U
#define XHC_PORTSC2__WRC_RESETVALUE		0x0U
#define XHC_PORTSC2__PEC			18U
#define XHC_PORTSC2__PEC_L			18U
#define XHC_PORTSC2__PEC_R			18U
#define XHC_PORTSC2__PEC_WIDTH			1U
#define XHC_PORTSC2__PEC_RESETVALUE		0x0U
#define XHC_PORTSC2__CSC			17U
#define XHC_PORTSC2__CSC_L			17U
#define XHC_PORTSC2__CSC_R			17U
#define XHC_PORTSC2__CSC_WIDTH			1U
#define XHC_PORTSC2__CSC_RESETVALUE		0x0U
#define XHC_PORTSC2__LWS			16U
#define XHC_PORTSC2__LWS_L			16U
#define XHC_PORTSC2__LWS_R			16U
#define XHC_PORTSC2__LWS_WIDTH			1U
#define XHC_PORTSC2__LWS_RESETVALUE		0x0U
#define XHC_PORTSC2__PIC_L			15U
#define XHC_PORTSC2__PIC_R			14U
#define XHC_PORTSC2__PIC_WIDTH			2U
#define XHC_PORTSC2__PIC_RESETVALUE		0x0U
#define XHC_PORTSC2__PS_L			13U
#define XHC_PORTSC2__PS_R			10U
#define XHC_PORTSC2__PS_WIDTH			4U
#define XHC_PORTSC2__PS_RESETVALUE		0x0U
#define XHC_PORTSC2__PP				9U
#define XHC_PORTSC2__PP_L			9U
#define XHC_PORTSC2__PP_R			9U
#define XHC_PORTSC2__PP_WIDTH			1U
#define XHC_PORTSC2__PP_RESETVALUE		0x0U
#define XHC_PORTSC2__PLS_L			8U
#define XHC_PORTSC2__PLS_R			5U
#define XHC_PORTSC2__PLS_WIDTH			4U
#define XHC_PORTSC2__PLS_RESETVALUE		0x5U

#define XHC_PORTSC2__PRST_L			4U
#define XHC_PORTSC2__PRST_R			4U
#define XHC_PORTSC2__PRST_WIDTH			1U
#define XHC_PORTSC2__PRST_RESETVALUE		0x0U
#define XHC_PORTSC2__OCA			3U
#define XHC_PORTSC2__OCA_L			3U
#define XHC_PORTSC2__OCA_R			3U
#define XHC_PORTSC2__OCA_WIDTH			1U
#define XHC_PORTSC2__OCA_RESETVALUE		0x0U
#define XHC_PORTSC2__reserved			2U
#define XHC_PORTSC2__reserved_L			2U
#define XHC_PORTSC2__reserved_R			2U
#define XHC_PORTSC2__reserved_WIDTH		1U
#define XHC_PORTSC2__reserved_RESETVALUE	0x0U
#define XHC_PORTSC2__PED			1U
#define XHC_PORTSC2__PED_L			1U
#define XHC_PORTSC2__PED_R			1U
#define XHC_PORTSC2__PED_WIDTH			1U
#define XHC_PORTSC2__PED_RESETVALUE		0x0U
#define XHC_PORTSC2__CCS			0U
#define XHC_PORTSC2__CCS_L			0U
#define XHC_PORTSC2__CCS_R			0U
#define XHC_PORTSC2__CCS_WIDTH			1U
#define XHC_PORTSC2__CCS_RESETVALUE		0x0U
#define XHC_PORTSC2__RESERVED_L			29U
#define XHC_PORTSC2__RESERVED_R			28U
#define XHC_PORTSC2_WIDTH			32U
#define XHC_PORTSC2__WIDTH			32U
#define XHC_PORTSC2_ALL_L			31U
#define XHC_PORTSC2_ALL_R			0U
#define XHC_PORTSC2__ALL_L			31U
#define XHC_PORTSC2__ALL_R			0U
#define XHC_PORTSC2_DATAMASK			0xcfffffffU
#define XHC_PORTSC2_RDWRMASK			0x30000000U
#define XHC_PORTSC2_RESETVALUE			0x000000a0U

#define XHC_PORTPM2_OFFSET			0x434U
#define XHC_PORTPM2_BASE			0x434U
#define XHC_PORTPM2__PTC_L			31U
#define XHC_PORTPM2__PTC_R			28U
#define XHC_PORTPM2__PTC_WIDTH			4U
#define XHC_PORTPM2__PTC_RESETVALUE		0x0U
#define XHC_PORTPM2__reserved_L			27U
#define XHC_PORTPM2__reserved_R			17U
#define XHC_PORTPM2__reserved_WIDTH		11U
#define XHC_PORTPM2__reserved_RESETVALUE	0x0U
#define XHC_PORTPM2__HLE			16U
#define XHC_PORTPM2__HLE_L			16U
#define XHC_PORTPM2__HLE_R			16U
#define XHC_PORTPM2__HLE_WIDTH			1U
#define XHC_PORTPM2__HLE_RESETVALUE		0x0U
#define XHC_PORTPM2__L1DS_L			15U
#define XHC_PORTPM2__L1DS_R			8U
#define XHC_PORTPM2__L1DS_WIDTH			8U
#define XHC_PORTPM2__L1DS_RESETVALUE		0x00U
#define XHC_PORTPM2__BESL_L			7U
#define XHC_PORTPM2__BESL_R			4U
#define XHC_PORTPM2__BESL_WIDTH			4U
#define XHC_PORTPM2__BESL_RESETVALUE		0x0U
#define XHC_PORTPM2__RWE			3U
#define XHC_PORTPM2__RWE_L			3U
#define XHC_PORTPM2__RWE_R			3U
#define XHC_PORTPM2__RWE_WIDTH			1U
#define XHC_PORTPM2__RWE_RESETVALUE		0x0U
#define XHC_PORTPM2__L1S_L			2U
#define XHC_PORTPM2__L1S_R			0U
#define XHC_PORTPM2__L1S_WIDTH			3U
#define XHC_PORTPM2__L1S_RESETVALUE		0x0U
#define XHC_PORTPM2_WIDTH			32U
#define XHC_PORTPM2__WIDTH			32U
#define XHC_PORTPM2_ALL_L			31U
#define XHC_PORTPM2_ALL_R			0U
#define XHC_PORTPM2__ALL_L			31U
#define XHC_PORTPM2__ALL_R			0U
#define XHC_PORTPM2_DATAMASK			0xffffffffU
#define XHC_PORTPM2_RDWRMASK			0x00000000U
#define XHC_PORTPM2_RESETVALUE			0x00000000U

#define XHC_PORTLC2_OFFSET			0x43cU
#define XHC_PORTLC2_BASE			0x43cU
#define XHC_PORTLC2__reserved_L			31U
#define XHC_PORTLC2__reserved_R			14U
#define XHC_PORTLC2__reserved_WIDTH		18U
#define XHC_PORTLC2__reserved_RESETVALUE	0x0U
#define XHC_PORTLC2__BESLD_L			13U
#define XHC_PORTLC2__BESLD_R			10U
#define XHC_PORTLC2__BESLD_WIDTH		4U
#define XHC_PORTLC2__BESLD_RESETVALUE		0x0U
#define XHC_PORTLC2__L1T_L			9U
#define XHC_PORTLC2__L1T_R			2U
#define XHC_PORTLC2__L1T_WIDTH			8U
#define XHC_PORTLC2__L1T_RESETVALUE		0x00U
#define XHC_PORTLC2__HIRDM_L			1U
#define XHC_PORTLC2__HIRDM_R			0U
#define XHC_PORTLC2__HIRDM_WIDTH		2U
#define XHC_PORTLC2__HIRDM_RESETVALUE		0x0U
#define XHC_PORTLC2_WIDTH			32U
#define XHC_PORTLC2__WIDTH			32U
#define XHC_PORTLC2_ALL_L			31U
#define XHC_PORTLC2_ALL_R			0U
#define XHC_PORTLC2__ALL_L			31U
#define XHC_PORTLC2__ALL_R			0U
#define XHC_PORTLC2_DATAMASK			0xffffffffU
#define XHC_PORTLC2_RDWRMASK			0x00000000U
#define XHC_PORTLC2_RESETVALUE			0x00000000U

#define XHC_PORTSC3_OFFSET			0x440U
#define XHC_PORTSC3_BASE			0x440U
#define XHC_PORTSC3__WPR			31U
#define XHC_PORTSC3__WPR_L			31U
#define XHC_PORTSC3__WPR_R			31U
#define XHC_PORTSC3__WPR_WIDTH			1U
#define XHC_PORTSC3__WPR_RESETVALUE		0x0U
#define XHC_PORTSC3__DNR			30U
#define XHC_PORTSC3__DNR_L			30U
#define XHC_PORTSC3__DNR_R			30U
#define XHC_PORTSC3__DNR_WIDTH			1U
#define XHC_PORTSC3__DNR_RESETVALUE		0x0U
#define XHC_PORTSC3__WOE			27U
#define XHC_PORTSC3__WOE_L			27U
#define XHC_PORTSC3__WOE_R			27U
#define XHC_PORTSC3__WOE_WIDTH			1U
#define XHC_PORTSC3__WOE_RESETVALUE		0x0U
#define XHC_PORTSC3__WDE			26U
#define XHC_PORTSC3__WDE_L			26U
#define XHC_PORTSC3__WDE_R			26U
#define XHC_PORTSC3__WDE_WIDTH			1U
#define XHC_PORTSC3__WDE_RESETVALUE		0x0U
#define XHC_PORTSC3__WCE			25U
#define XHC_PORTSC3__WCE_L			25U
#define XHC_PORTSC3__WCE_R			25U
#define XHC_PORTSC3__WCE_WIDTH			1U
#define XHC_PORTSC3__WCE_RESETVALUE		0x0U
#define XHC_PORTSC3__CAS			24U
#define XHC_PORTSC3__CAS_L			24U
#define XHC_PORTSC3__CAS_R			24U
#define XHC_PORTSC3__CAS_WIDTH			1U
#define XHC_PORTSC3__CAS_RESETVALUE		0x0U
#define XHC_PORTSC3__CEC			23U
#define XHC_PORTSC3__CEC_L			23U
#define XHC_PORTSC3__CEC_R			23U
#define XHC_PORTSC3__CEC_WIDTH			1U
#define XHC_PORTSC3__CEC_RESETVALUE		0x0U
#define XHC_PORTSC3__PLC			22U
#define XHC_PORTSC3__PLC_L			22U
#define XHC_PORTSC3__PLC_R			22U
#define XHC_PORTSC3__PLC_WIDTH			1U
#define XHC_PORTSC3__PLC_RESETVALUE		0x0U
#define XHC_PORTSC3__PRC			21U
#define XHC_PORTSC3__PRC_L			21U
#define XHC_PORTSC3__PRC_R			21U
#define XHC_PORTSC3__PRC_WIDTH			1U
#define XHC_PORTSC3__PRC_RESETVALUE		0x0U
#define XHC_PORTSC3__OCC			20U
#define XHC_PORTSC3__OCC_L			20U
#define XHC_PORTSC3__OCC_R			20U
#define XHC_PORTSC3__OCC_WIDTH			1U
#define XHC_PORTSC3__OCC_RESETVALUE		0x0U
#define XHC_PORTSC3__WRC			19U
#define XHC_PORTSC3__WRC_L			19U
#define XHC_PORTSC3__WRC_R			19U
#define XHC_PORTSC3__WRC_WIDTH			1U
#define XHC_PORTSC3__WRC_RESETVALUE		0x0U
#define XHC_PORTSC3__PEC			18U
#define XHC_PORTSC3__PEC_L			18U
#define XHC_PORTSC3__PEC_R			18U
#define XHC_PORTSC3__PEC_WIDTH			1U
#define XHC_PORTSC3__PEC_RESETVALUE		0x0U
#define XHC_PORTSC3__CSC			17U
#define XHC_PORTSC3__CSC_L			17U
#define XHC_PORTSC3__CSC_R			17U
#define XHC_PORTSC3__CSC_WIDTH			1U
#define XHC_PORTSC3__CSC_RESETVALUE		0x0U
#define XHC_PORTSC3__LWS			16U
#define XHC_PORTSC3__LWS_L			16U
#define XHC_PORTSC3__LWS_R			16U
#define XHC_PORTSC3__LWS_WIDTH			1U
#define XHC_PORTSC3__LWS_RESETVALUE		0x0U
#define XHC_PORTSC3__PIC_L			15U
#define XHC_PORTSC3__PIC_R			14U
#define XHC_PORTSC3__PIC_WIDTH			2U
#define XHC_PORTSC3__PIC_RESETVALUE		0x0U
#define XHC_PORTSC3__PS_L			13U
#define XHC_PORTSC3__PS_R			10U
#define XHC_PORTSC3__PS_WIDTH			4U
#define XHC_PORTSC3__PS_RESETVALUE		0x0U
#define XHC_PORTSC3__PP				9U
#define XHC_PORTSC3__PP_L			9U
#define XHC_PORTSC3__PP_R			9U
#define XHC_PORTSC3__PP_WIDTH			1U
#define XHC_PORTSC3__PP_RESETVALUE		0x0U
#define XHC_PORTSC3__PLS_L			8U
#define XHC_PORTSC3__PLS_R			5U
#define XHC_PORTSC3__PLS_WIDTH			4U
#define XHC_PORTSC3__PLS_RESETVALUE		0x5U
#define XHC_PORTSC3__PR				4U
#define XHC_PORTSC3__PR_L			4U
#define XHC_PORTSC3__PR_R			4U
#define XHC_PORTSC3__PR_WIDTH			1U
#define XHC_PORTSC3__PR_RESETVALUE		0x0U
#define XHC_PORTSC3__OCA			3U
#define XHC_PORTSC3__OCA_L			3U
#define XHC_PORTSC3__OCA_R			3U
#define XHC_PORTSC3__OCA_WIDTH			1U
#define XHC_PORTSC3__OCA_RESETVALUE		0x0U
#define XHC_PORTSC3__reserved			2U
#define XHC_PORTSC3__reserved_L			2U
#define XHC_PORTSC3__reserved_R			2U
#define XHC_PORTSC3__reserved_WIDTH		1U
#define XHC_PORTSC3__reserved_RESETVALUE	0x0U
#define XHC_PORTSC3__PED			1U
#define XHC_PORTSC3__PED_L			1U
#define XHC_PORTSC3__PED_R			1U
#define XHC_PORTSC3__PED_WIDTH			1U
#define XHC_PORTSC3__PED_RESETVALUE		0x0U
#define XHC_PORTSC3__CCS			0U
#define XHC_PORTSC3__CCS_L			0U
#define XHC_PORTSC3__CCS_R			0U
#define XHC_PORTSC3__CCS_WIDTH			1U
#define XHC_PORTSC3__CCS_RESETVALUE		0x0U
#define XHC_PORTSC3__RESERVED_L			29U
#define XHC_PORTSC3__RESERVED_R			28U
#define XHC_PORTSC3_WIDTH			32U
#define XHC_PORTSC3__WIDTH			32U
#define XHC_PORTSC3_ALL_L			31U
#define XHC_PORTSC3_ALL_R			0U
#define XHC_PORTSC3__ALL_L			31U
#define XHC_PORTSC3__ALL_R			0U
#define XHC_PORTSC3_DATAMASK			0xcfffffffU
#define XHC_PORTSC3_RDWRMASK			0x30000000U
#define XHC_PORTSC3_RESETVALUE			0x000000a0U

#define XHC_PORTPM3_OFFSET			0x444U
#define XHC_PORTPM3_BASE			0x444U
#define XHC_PORTPM3__PTC_L			31U
#define XHC_PORTPM3__PTC_R			28U
#define XHC_PORTPM3__PTC_WIDTH			4U
#define XHC_PORTPM3__PTC_RESETVALUE		0x0U
#define XHC_PORTPM3__reserved_L			27U
#define XHC_PORTPM3__reserved_R			17U
#define XHC_PORTPM3__reserved_WIDTH		11U
#define XHC_PORTPM3__reserved_RESETVALUE	0x0U
#define XHC_PORTPM3__HLE			16U
#define XHC_PORTPM3__HLE_L			16U
#define XHC_PORTPM3__HLE_R			16U
#define XHC_PORTPM3__HLE_WIDTH			1U
#define XHC_PORTPM3__HLE_RESETVALUE		0x0U
#define XHC_PORTPM3__L1DS_L			15U
#define XHC_PORTPM3__L1DS_R			8U
#define XHC_PORTPM3__L1DS_WIDTH			8U
#define XHC_PORTPM3__L1DS_RESETVALUE		0x00U
#define XHC_PORTPM3__BESL_L			7U
#define XHC_PORTPM3__BESL_R			4U
#define XHC_PORTPM3__BESL_WIDTH			4U
#define XHC_PORTPM3__BESL_RESETVALUE		0x0U
#define XHC_PORTPM3__RWE			3U
#define XHC_PORTPM3__RWE_L			3U
#define XHC_PORTPM3__RWE_R			3U
#define XHC_PORTPM3__RWE_WIDTH			1U
#define XHC_PORTPM3__RWE_RESETVALUE		0x0U
#define XHC_PORTPM3__L1S_L			2U
#define XHC_PORTPM3__L1S_R			0U
#define XHC_PORTPM3__L1S_WIDTH			3U
#define XHC_PORTPM3__L1S_RESETVALUE		0x0U
#define XHC_PORTPM3_WIDTH			32U
#define XHC_PORTPM3__WIDTH			32U
#define XHC_PORTPM3_ALL_L			31U
#define XHC_PORTPM3_ALL_R			0U
#define XHC_PORTPM3__ALL_L			31U
#define XHC_PORTPM3__ALL_R			0U
#define XHC_PORTPM3_DATAMASK			0xffffffffU
#define XHC_PORTPM3_RDWRMASK			0x00000000U
#define XHC_PORTPM3_RESETVALUE			0x00000000U

#define XHC_PORTLI3_OFFSET			0x44cU
#define XHC_PORTLI3_BASE			0x44cU
#define XHC_PORTLI3__reserved_L			31U
#define XHC_PORTLI3__reserved_R			0U
#define XHC_PORTLI3__reserved_WIDTH		32U
#define XHC_PORTLI3__reserved_RESETVALUE	0x00000000U
#define XHC_PORTLI3_WIDTH			32U
#define XHC_PORTLI3__WIDTH			32U
#define XHC_PORTLI3_ALL_L			31U
#define XHC_PORTLI3_ALL_R			0U
#define XHC_PORTLI3__ALL_L			31U
#define XHC_PORTLI3__ALL_R			0U
#define XHC_PORTLI3_DATAMASK			0xffffffffU
#define XHC_PORTLI3_RDWRMASK			0x00000000U
#define XHC_PORTLI3_RESETVALUE			0x00000000U

#define XHC_MFINDEX_OFFSET			0x4a0U
#define XHC_MFINDEX_BASE			0x4a0U
#define XHC_MFINDEX__reserved_L			31U
#define XHC_MFINDEX__reserved_R			14U
#define XHC_MFINDEX__reserved_WIDTH		18U
#define XHC_MFINDEX__reserved_RESETVALUE	0x0U
#define XHC_MFINDEX__MFI_L			13U
#define XHC_MFINDEX__MFI_R			0U
#define XHC_MFINDEX__MFI_WIDTH			14U
#define XHC_MFINDEX__MFI_RESETVALUE		0x0U
#define XHC_MFINDEX_WIDTH			32U
#define XHC_MFINDEX__WIDTH			32U
#define XHC_MFINDEX_ALL_L			31U
#define XHC_MFINDEX_ALL_R			0U
#define XHC_MFINDEX__ALL_L			31U
#define XHC_MFINDEX__ALL_R			0U
#define XHC_MFINDEX_DATAMASK			0xffffffffU
#define XHC_MFINDEX_RDWRMASK			0x00000000U
#define XHC_MFINDEX_RESETVALUE			0x00000000U

#define XHC_IMAN0_OFFSET			0x4c0U
#define XHC_IMAN0_BASE				0x4c0U
#define XHC_IMAN0__reserved_L			31U
#define XHC_IMAN0__reserved_R			2U
#define XHC_IMAN0__reserved_WIDTH		30U
#define XHC_IMAN0__reserved_RESETVALUE		0x0U
#define XHC_IMAN0__IE				1U
#define XHC_IMAN0__IE_L				1U
#define XHC_IMAN0__IE_R				1U
#define XHC_IMAN0__IE_WIDTH			1U
#define XHC_IMAN0__IE_RESETVALUE		0x0U
#define XHC_IMAN0__IP				0U
#define XHC_IMAN0__IP_L				0U
#define XHC_IMAN0__IP_R				0U
#define XHC_IMAN0__IP_WIDTH			1U
#define XHC_IMAN0__IP_RESETVALUE		0x0U
#define XHC_IMAN0_WIDTH				32U
#define XHC_IMAN0__WIDTH			32U
#define XHC_IMAN0_ALL_L				31U
#define XHC_IMAN0_ALL_R				0U
#define XHC_IMAN0__ALL_L			31U
#define XHC_IMAN0__ALL_R			0U
#define XHC_IMAN0_DATAMASK			0xffffffffU
#define XHC_IMAN0_RDWRMASK			0x00000000U
#define XHC_IMAN0_RESETVALUE			0x00000000U

#define XHC_IMOD0_OFFSET			0x4c4U
#define XHC_IMOD0_BASE				0x4c4U
#define XHC_IMOD0__IMODC_L			31U
#define XHC_IMOD0__IMODC_R			16U
#define XHC_IMOD0__IMODC_WIDTH			16U
#define XHC_IMOD0__IMODC_RESETVALUE		0x0000U
#define XHC_IMOD0__IMODI_L			15U
#define XHC_IMOD0__IMODI_R			0U
#define XHC_IMOD0__IMODI_WIDTH			16U
#define XHC_IMOD0__IMODI_RESETVALUE		0x4000U
#define XHC_IMOD0_WIDTH				32U
#define XHC_IMOD0__WIDTH			32U
#define XHC_IMOD0_ALL_L				31U
#define XHC_IMOD0_ALL_R				0U
#define XHC_IMOD0__ALL_L			31U
#define XHC_IMOD0__ALL_R			0U
#define XHC_IMOD0_DATAMASK			0xffffffffU
#define XHC_IMOD0_RDWRMASK			0x00000000U
#define XHC_IMOD0_RESETVALUE			0x00004000U

#define XHC_ERSTSZ0_OFFSET			0x4c8U
#define XHC_ERSTSZ0_BASE			0x4c8U
#define XHC_ERSTSZ0__reserved_L			31U
#define XHC_ERSTSZ0__reserved_R			16U
#define XHC_ERSTSZ0__reserved_WIDTH		16U
#define XHC_ERSTSZ0__reserved_RESETVALUE	0x0000U
#define XHC_ERSTSZ0__TSZ_L			15U
#define XHC_ERSTSZ0__TSZ_R			0U
#define XHC_ERSTSZ0__TSZ_WIDTH			16U
#define XHC_ERSTSZ0__TSZ_RESETVALUE		0x0000U
#define XHC_ERSTSZ0_WIDTH			32U
#define XHC_ERSTSZ0__WIDTH			32U
#define XHC_ERSTSZ0_ALL_L			31U
#define XHC_ERSTSZ0_ALL_R			0U
#define XHC_ERSTSZ0__ALL_L			31U
#define XHC_ERSTSZ0__ALL_R			0U
#define XHC_ERSTSZ0_DATAMASK			0xffffffffU
#define XHC_ERSTSZ0_RDWRMASK			0x00000000U
#define XHC_ERSTSZ0_RESETVALUE			0x00000000U

#define XHC_ERSTBAL0_OFFSET			0x4d0U
#define XHC_ERSTBAL0_BASE			0x4d0U
#define XHC_ERSTBAL0__BAL_L			31U
#define XHC_ERSTBAL0__BAL_R			4U
#define XHC_ERSTBAL0__BAL_WIDTH			28U
#define XHC_ERSTBAL0__BAL_RESETVALUE		0x0000000U
#define XHC_ERSTBAL0__reserved_L		3U
#define XHC_ERSTBAL0__reserved_R		0U
#define XHC_ERSTBAL0__reserved_WIDTH		4U
#define XHC_ERSTBAL0__reserved_RESETVALUE	0x0U
#define XHC_ERSTBAL0_WIDTH			32U
#define XHC_ERSTBAL0__WIDTH			32U
#define XHC_ERSTBAL0_ALL_L			31U
#define XHC_ERSTBAL0_ALL_R			0U
#define XHC_ERSTBAL0__ALL_L			31U
#define XHC_ERSTBAL0__ALL_R			0U
#define XHC_ERSTBAL0_DATAMASK			0xffffffffU
#define XHC_ERSTBAL0_RDWRMASK			0x00000000U
#define XHC_ERSTBAL0_RESETVALUE			0x00000000U

#define XHC_ERSTBAH0_OFFSET			0x4d4U
#define XHC_ERSTBAH0_BASE			0x4d4U
#define XHC_ERSTBAH0__BAH_L			31U
#define XHC_ERSTBAH0__BAH_R			0U
#define XHC_ERSTBAH0__BAH_WIDTH			32U
#define XHC_ERSTBAH0__BAH_RESETVALUE		0x00000000U
#define XHC_ERSTBAH0_WIDTH			32U
#define XHC_ERSTBAH0__WIDTH			32U
#define XHC_ERSTBAH0_ALL_L			31U
#define XHC_ERSTBAH0_ALL_R			0U
#define XHC_ERSTBAH0__ALL_L			31U
#define XHC_ERSTBAH0__ALL_R			0U
#define XHC_ERSTBAH0_DATAMASK			0xffffffffU
#define XHC_ERSTBAH0_RDWRMASK			0x00000000U
#define XHC_ERSTBAH0_RESETVALUE			0x00000000U

#define XHC_ERDPL0_OFFSET			0x4d8U
#define XHC_ERDPL0_BASE				0x4d8U
#define XHC_ERDPL0__DPL_L			31U
#define XHC_ERDPL0__DPL_R			4U
#define XHC_ERDPL0__DPL_WIDTH			28U
#define XHC_ERDPL0__DPL_RESETVALUE		0x0000000U
#define XHC_ERDPL0__EHB				3U
#define XHC_ERDPL0__EHB_L			3U
#define XHC_ERDPL0__EHB_R			3U
#define XHC_ERDPL0__EHB_WIDTH			1U
#define XHC_ERDPL0__EHB_RESETVALUE		0x0U
#define XHC_ERDPL0__DESI_L			2U
#define XHC_ERDPL0__DESI_R			0U
#define XHC_ERDPL0__DESI_WIDTH			3U
#define XHC_ERDPL0__DESI_RESETVALUE		0x0U
#define XHC_ERDPL0_WIDTH			32U
#define XHC_ERDPL0__WIDTH			32U
#define XHC_ERDPL0_ALL_L			31U
#define XHC_ERDPL0_ALL_R			0U
#define XHC_ERDPL0__ALL_L			31U
#define XHC_ERDPL0__ALL_R			0U
#define XHC_ERDPL0_DATAMASK			0xffffffffU
#define XHC_ERDPL0_RDWRMASK			0x00000000U
#define XHC_ERDPL0_RESETVALUE			0x00000000U

#define XHC_ERDPH0_OFFSET			0x4dcU
#define XHC_ERDPH0_BASE				0x4dcU
#define XHC_ERDPH0__DPH_L			31U
#define XHC_ERDPH0__DPH_R			0U
#define XHC_ERDPH0__DPH_WIDTH			32U
#define XHC_ERDPH0__DPH_RESETVALUE		0x00000000U
#define XHC_ERDPH0_WIDTH			32U
#define XHC_ERDPH0__WIDTH			32U
#define XHC_ERDPH0_ALL_L			31U
#define XHC_ERDPH0_ALL_R			0U
#define XHC_ERDPH0__ALL_L			31U
#define XHC_ERDPH0__ALL_R			0U
#define XHC_ERDPH0_DATAMASK			0xffffffffU
#define XHC_ERDPH0_RDWRMASK			0x00000000U
#define XHC_ERDPH0_RESETVALUE			0x00000000U

#define XHC_IMAN1_OFFSET			0x4e0U
#define XHC_IMAN1_BASE				0x4e0U
#define XHC_IMAN1__reserved_L			31U
#define XHC_IMAN1__reserved_R			2U
#define XHC_IMAN1__reserved_WIDTH		30U
#define XHC_IMAN1__reserved_RESETVALUE		0x0U
#define XHC_IMAN1__IE				1U
#define XHC_IMAN1__IE_L				1U
#define XHC_IMAN1__IE_R				1U
#define XHC_IMAN1__IE_WIDTH			1U
#define XHC_IMAN1__IE_RESETVALUE		0x0U
#define XHC_IMAN1__IP				0U
#define XHC_IMAN1__IP_L				0U
#define XHC_IMAN1__IP_R				0U
#define XHC_IMAN1__IP_WIDTH			1U
#define XHC_IMAN1__IP_RESETVALUE		0x0U
#define XHC_IMAN1_WIDTH				32U
#define XHC_IMAN1__WIDTH			32U
#define XHC_IMAN1_ALL_L				31U
#define XHC_IMAN1_ALL_R				0U
#define XHC_IMAN1__ALL_L			31U
#define XHC_IMAN1__ALL_R			0U
#define XHC_IMAN1_DATAMASK			0xffffffffU
#define XHC_IMAN1_RDWRMASK			0x00000000U
#define XHC_IMAN1_RESETVALUE			0x00000000U

#define XHC_IMOD1_OFFSET			0x4e4U
#define XHC_IMOD1_BASE				0x4e4U
#define XHC_IMOD1__IMODC_L			31U
#define XHC_IMOD1__IMODC_R			16U
#define XHC_IMOD1__IMODC_WIDTH			16U
#define XHC_IMOD1__IMODC_RESETVALUE		0x0000U
#define XHC_IMOD1__IMODI_L			15U
#define XHC_IMOD1__IMODI_R			0U
#define XHC_IMOD1__IMODI_WIDTH			16U
#define XHC_IMOD1__IMODI_RESETVALUE		0x4000U
#define XHC_IMOD1_WIDTH				32U
#define XHC_IMOD1__WIDTH			32U
#define XHC_IMOD1_ALL_L				31U
#define XHC_IMOD1_ALL_R				0U
#define XHC_IMOD1__ALL_L			31U
#define XHC_IMOD1__ALL_R			0U
#define XHC_IMOD1_DATAMASK			0xffffffffU
#define XHC_IMOD1_RDWRMASK			0x00000000U
#define XHC_IMOD1_RESETVALUE			0x00004000U

#define XHC_ERSTSZ1_OFFSET			0x4e8U
#define XHC_ERSTSZ1_BASE			0x4e8U
#define XHC_ERSTSZ1__reserved_L			31U
#define XHC_ERSTSZ1__reserved_R			16U
#define XHC_ERSTSZ1__reserved_WIDTH		16U
#define XHC_ERSTSZ1__reserved_RESETVALUE	0x0000U
#define XHC_ERSTSZ1__TSZ_L			15U
#define XHC_ERSTSZ1__TSZ_R			0U
#define XHC_ERSTSZ1__TSZ_WIDTH			16U
#define XHC_ERSTSZ1__TSZ_RESETVALUE		0x0000U
#define XHC_ERSTSZ1_WIDTH			32U
#define XHC_ERSTSZ1__WIDTH			32U
#define XHC_ERSTSZ1_ALL_L			31U
#define XHC_ERSTSZ1_ALL_R			0U
#define XHC_ERSTSZ1__ALL_L			31U
#define XHC_ERSTSZ1__ALL_R			0U
#define XHC_ERSTSZ1_DATAMASK			0xffffffffU
#define XHC_ERSTSZ1_RDWRMASK			0x00000000U
#define XHC_ERSTSZ1_RESETVALUE			0x00000000U

#define XHC_ERSTBAL1_OFFSET			0x4f0U
#define XHC_ERSTBAL1_BASE			0x4f0U
#define XHC_ERSTBAL1__BAL_L			31U
#define XHC_ERSTBAL1__BAL_R			4U
#define XHC_ERSTBAL1__BAL_WIDTH			28U
#define XHC_ERSTBAL1__BAL_RESETVALUE		0x0000000U
#define XHC_ERSTBAL1__reserved_L		3U
#define XHC_ERSTBAL1__reserved_R		0U
#define XHC_ERSTBAL1__reserved_WIDTH		4U
#define XHC_ERSTBAL1__reserved_RESETVALUE	0x0U
#define XHC_ERSTBAL1_WIDTH			32U
#define XHC_ERSTBAL1__WIDTH			32U
#define XHC_ERSTBAL1_ALL_L			31U
#define XHC_ERSTBAL1_ALL_R			0U
#define XHC_ERSTBAL1__ALL_L			31U
#define XHC_ERSTBAL1__ALL_R			0U
#define XHC_ERSTBAL1_DATAMASK			0xffffffffU
#define XHC_ERSTBAL1_RDWRMASK			0x00000000U
#define XHC_ERSTBAL1_RESETVALUE			0x00000000U

#define XHC_ERSTBAH1_OFFSET			0x4f4U
#define XHC_ERSTBAH1_BASE			0x4f4U
#define XHC_ERSTBAH1__BAH_L			31U
#define XHC_ERSTBAH1__BAH_R			0U
#define XHC_ERSTBAH1__BAH_WIDTH			32U
#define XHC_ERSTBAH1__BAH_RESETVALUE		0x00000000U
#define XHC_ERSTBAH1_WIDTH			32U
#define XHC_ERSTBAH1__WIDTH			32U
#define XHC_ERSTBAH1_ALL_L			31U
#define XHC_ERSTBAH1_ALL_R			0U
#define XHC_ERSTBAH1__ALL_L			31U
#define XHC_ERSTBAH1__ALL_R			0U
#define XHC_ERSTBAH1_DATAMASK			0xffffffffU
#define XHC_ERSTBAH1_RDWRMASK			0x00000000U
#define XHC_ERSTBAH1_RESETVALUE			0x00000000U

#define XHC_ERDPL1_OFFSET			0x4f8U
#define XHC_ERDPL1_BASE				0x4f8U
#define XHC_ERDPL1__DPL_L			31U
#define XHC_ERDPL1__DPL_R			4U
#define XHC_ERDPL1__DPL_WIDTH			28U
#define XHC_ERDPL1__DPL_RESETVALUE		0x0000000U
#define XHC_ERDPL1__EHB				3U
#define XHC_ERDPL1__EHB_L			3U
#define XHC_ERDPL1__EHB_R			3U
#define XHC_ERDPL1__EHB_WIDTH			1U
#define XHC_ERDPL1__EHB_RESETVALUE		0x0U
#define XHC_ERDPL1__DESI_L			2U
#define XHC_ERDPL1__DESI_R			0U
#define XHC_ERDPL1__DESI_WIDTH			3U
#define XHC_ERDPL1__DESI_RESETVALUE		0x0U
#define XHC_ERDPL1_WIDTH			32U
#define XHC_ERDPL1__WIDTH			32U
#define XHC_ERDPL1_ALL_L			31U
#define XHC_ERDPL1_ALL_R			0U
#define XHC_ERDPL1__ALL_L			31U
#define XHC_ERDPL1__ALL_R			0U
#define XHC_ERDPL1_DATAMASK			0xffffffffU
#define XHC_ERDPL1_RDWRMASK			0x00000000U
#define XHC_ERDPL1_RESETVALUE			0x00000000U

#define XHC_ERDPH1_OFFSET			0x4fcU
#define XHC_ERDPH1_BASE				0x4fcU
#define XHC_ERDPH1__DPH_L			31U
#define XHC_ERDPH1__DPH_R			0U
#define XHC_ERDPH1__DPH_WIDTH			32U
#define XHC_ERDPH1__DPH_RESETVALUE		0x00000000U
#define XHC_ERDPH1_WIDTH			32U
#define XHC_ERDPH1__WIDTH			32U
#define XHC_ERDPH1_ALL_L			31U
#define XHC_ERDPH1_ALL_R			0U
#define XHC_ERDPH1__ALL_L			31U
#define XHC_ERDPH1__ALL_R			0U
#define XHC_ERDPH1_DATAMASK			0xffffffffU
#define XHC_ERDPH1_RDWRMASK			0x00000000U
#define XHC_ERDPH1_RESETVALUE			0x00000000U

#define XHC_DBLCMD_OFFSET			0x8c0U
#define XHC_DBLCMD_BASE				0x8c0U
#define XHC_DBLCMD__SID_L			31U
#define XHC_DBLCMD__SID_R			16U
#define XHC_DBLCMD__SID_WIDTH			16U
#define XHC_DBLCMD__SID_RESETVALUE		0x0000U
#define XHC_DBLCMD__reserved_L			15U
#define XHC_DBLCMD__reserved_R			8U
#define XHC_DBLCMD__reserved_WIDTH		8U
#define XHC_DBLCMD__reserved_RESETVALUE		0x00U
#define XHC_DBLCMD__TGT_L			7U
#define XHC_DBLCMD__TGT_R			0U
#define XHC_DBLCMD__TGT_WIDTH			8U
#define XHC_DBLCMD__TGT_RESETVALUE		0x00U
#define XHC_DBLCMD_WIDTH			32U
#define XHC_DBLCMD__WIDTH			32U
#define XHC_DBLCMD_ALL_L			31U
#define XHC_DBLCMD_ALL_R			0U
#define XHC_DBLCMD__ALL_L			31U
#define XHC_DBLCMD__ALL_R			0U
#define XHC_DBLCMD_DATAMASK			0xffffffffU
#define XHC_DBLCMD_RDWRMASK			0x00000000U
#define XHC_DBLCMD_RESETVALUE			0x00000000U

#define XHC_DBLDVX1_OFFSET			0x8c4U
#define XHC_DBLDVX1_BASE			0x8c4U
#define XHC_DBLDVX1__SID_L			31U
#define XHC_DBLDVX1__SID_R			16U
#define XHC_DBLDVX1__SID_WIDTH			16U
#define XHC_DBLDVX1__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX1__reserved_L			15U
#define XHC_DBLDVX1__reserved_R			8U
#define XHC_DBLDVX1__reserved_WIDTH		8U
#define XHC_DBLDVX1__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX1__TGT_L			7U
#define XHC_DBLDVX1__TGT_R			0U
#define XHC_DBLDVX1__TGT_WIDTH			8U
#define XHC_DBLDVX1__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX1_WIDTH			32U
#define XHC_DBLDVX1__WIDTH			32U
#define XHC_DBLDVX1_ALL_L			31U
#define XHC_DBLDVX1_ALL_R			0U
#define XHC_DBLDVX1__ALL_L			31U
#define XHC_DBLDVX1__ALL_R			0U
#define XHC_DBLDVX1_DATAMASK			0xffffffffU
#define XHC_DBLDVX1_RDWRMASK			0x00000000U
#define XHC_DBLDVX1_RESETVALUE			0x00000000U

#define XHC_DBLDVX2_OFFSET			0x8c8U
#define XHC_DBLDVX2_BASE			0x8c8U
#define XHC_DBLDVX2__SID_L			31U
#define XHC_DBLDVX2__SID_R			16U
#define XHC_DBLDVX2__SID_WIDTH			16U
#define XHC_DBLDVX2__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX2__reserved_L			15U
#define XHC_DBLDVX2__reserved_R			8U
#define XHC_DBLDVX2__reserved_WIDTH		8U
#define XHC_DBLDVX2__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX2__TGT_L			7U
#define XHC_DBLDVX2__TGT_R			0U
#define XHC_DBLDVX2__TGT_WIDTH			8U
#define XHC_DBLDVX2__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX2_WIDTH			32U
#define XHC_DBLDVX2__WIDTH			32U
#define XHC_DBLDVX2_ALL_L			31U
#define XHC_DBLDVX2_ALL_R			0U
#define XHC_DBLDVX2__ALL_L			31U
#define XHC_DBLDVX2__ALL_R			0U
#define XHC_DBLDVX2_DATAMASK			0xffffffffU
#define XHC_DBLDVX2_RDWRMASK			0x00000000U
#define XHC_DBLDVX2_RESETVALUE			0x00000000U

#define XHC_DBLDVX3_OFFSET			0x8ccU
#define XHC_DBLDVX3_BASE			0x8ccU
#define XHC_DBLDVX3__SID_L			31U
#define XHC_DBLDVX3__SID_R			16U
#define XHC_DBLDVX3__SID_WIDTH			16U
#define XHC_DBLDVX3__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX3__reserved_L			15U
#define XHC_DBLDVX3__reserved_R			8U
#define XHC_DBLDVX3__reserved_WIDTH		8U
#define XHC_DBLDVX3__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX3__TGT_L			7U
#define XHC_DBLDVX3__TGT_R			0U
#define XHC_DBLDVX3__TGT_WIDTH			8U
#define XHC_DBLDVX3__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX3_WIDTH			32U
#define XHC_DBLDVX3__WIDTH			32U
#define XHC_DBLDVX3_ALL_L			31U
#define XHC_DBLDVX3_ALL_R			0U
#define XHC_DBLDVX3__ALL_L			31U
#define XHC_DBLDVX3__ALL_R			0U
#define XHC_DBLDVX3_DATAMASK			0xffffffffU
#define XHC_DBLDVX3_RDWRMASK			0x00000000U
#define XHC_DBLDVX3_RESETVALUE			0x00000000U

#define XHC_DBLDVX4_OFFSET			0x8d0U
#define XHC_DBLDVX4_BASE			0x8d0U
#define XHC_DBLDVX4__SID_L			31U
#define XHC_DBLDVX4__SID_R			16U
#define XHC_DBLDVX4__SID_WIDTH			16U
#define XHC_DBLDVX4__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX4__reserved_L			15U
#define XHC_DBLDVX4__reserved_R			8U
#define XHC_DBLDVX4__reserved_WIDTH		8U
#define XHC_DBLDVX4__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX4__TGT_L			7U
#define XHC_DBLDVX4__TGT_R			0U
#define XHC_DBLDVX4__TGT_WIDTH			8U
#define XHC_DBLDVX4__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX4_WIDTH			32U
#define XHC_DBLDVX4__WIDTH			32U
#define XHC_DBLDVX4_ALL_L			31U
#define XHC_DBLDVX4_ALL_R			0U
#define XHC_DBLDVX4__ALL_L			31U
#define XHC_DBLDVX4__ALL_R			0U
#define XHC_DBLDVX4_DATAMASK			0xffffffffU
#define XHC_DBLDVX4_RDWRMASK			0x00000000U
#define XHC_DBLDVX4_RESETVALUE			0x00000000U

#define XHC_DBLDVX5_OFFSET			0x8d4U
#define XHC_DBLDVX5_BASE			0x8d4U
#define XHC_DBLDVX5__SID_L			31U
#define XHC_DBLDVX5__SID_R			16U
#define XHC_DBLDVX5__SID_WIDTH			16U
#define XHC_DBLDVX5__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX5__reserved_L			15U
#define XHC_DBLDVX5__reserved_R			8U
#define XHC_DBLDVX5__reserved_WIDTH		8U
#define XHC_DBLDVX5__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX5__TGT_L			7U
#define XHC_DBLDVX5__TGT_R			0U
#define XHC_DBLDVX5__TGT_WIDTH			8U
#define XHC_DBLDVX5__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX5_WIDTH			32U
#define XHC_DBLDVX5__WIDTH			32U
#define XHC_DBLDVX5_ALL_L			31U
#define XHC_DBLDVX5_ALL_R			0U
#define XHC_DBLDVX5__ALL_L			31U
#define XHC_DBLDVX5__ALL_R			0U
#define XHC_DBLDVX5_DATAMASK			0xffffffffU
#define XHC_DBLDVX5_RDWRMASK			0x00000000U
#define XHC_DBLDVX5_RESETVALUE			0x00000000U

#define XHC_DBLDVX6_OFFSET			0x8d8U
#define XHC_DBLDVX6_BASE			0x8d8U
#define XHC_DBLDVX6__SID_L			31U
#define XHC_DBLDVX6__SID_R			16U
#define XHC_DBLDVX6__SID_WIDTH			16U
#define XHC_DBLDVX6__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX6__reserved_L			15U
#define XHC_DBLDVX6__reserved_R			8U
#define XHC_DBLDVX6__reserved_WIDTH		8U
#define XHC_DBLDVX6__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX6__TGT_L			7U
#define XHC_DBLDVX6__TGT_R			0U
#define XHC_DBLDVX6__TGT_WIDTH			8U
#define XHC_DBLDVX6__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX6_WIDTH			32U
#define XHC_DBLDVX6__WIDTH			32U
#define XHC_DBLDVX6_ALL_L			31U
#define XHC_DBLDVX6_ALL_R			0U
#define XHC_DBLDVX6__ALL_L			31U
#define XHC_DBLDVX6__ALL_R			0U
#define XHC_DBLDVX6_DATAMASK			0xffffffffU
#define XHC_DBLDVX6_RDWRMASK			0x00000000U
#define XHC_DBLDVX6_RESETVALUE			0x00000000U

#define XHC_DBLDVX7_OFFSET			0x8dcU
#define XHC_DBLDVX7_BASE			0x8dcU
#define XHC_DBLDVX7__SID_L			31U
#define XHC_DBLDVX7__SID_R			16U
#define XHC_DBLDVX7__SID_WIDTH			16U
#define XHC_DBLDVX7__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX7__reserved_L			15U
#define XHC_DBLDVX7__reserved_R			8U
#define XHC_DBLDVX7__reserved_WIDTH		8U
#define XHC_DBLDVX7__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX7__TGT_L			7U
#define XHC_DBLDVX7__TGT_R			0U
#define XHC_DBLDVX7__TGT_WIDTH			8U
#define XHC_DBLDVX7__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX7_WIDTH			32U
#define XHC_DBLDVX7__WIDTH			32U
#define XHC_DBLDVX7_ALL_L			31U
#define XHC_DBLDVX7_ALL_R			0U
#define XHC_DBLDVX7__ALL_L			31U
#define XHC_DBLDVX7__ALL_R			0U
#define XHC_DBLDVX7_DATAMASK			0xffffffffU
#define XHC_DBLDVX7_RDWRMASK			0x00000000U
#define XHC_DBLDVX7_RESETVALUE			0x00000000U

#define XHC_DBLDVX8_OFFSET			0x8e0U
#define XHC_DBLDVX8_BASE			0x8e0U
#define XHC_DBLDVX8__SID_L			31U
#define XHC_DBLDVX8__SID_R			16U
#define XHC_DBLDVX8__SID_WIDTH			16U
#define XHC_DBLDVX8__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX8__reserved_L			15U
#define XHC_DBLDVX8__reserved_R			8U
#define XHC_DBLDVX8__reserved_WIDTH		8U
#define XHC_DBLDVX8__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX8__TGT_L			7U
#define XHC_DBLDVX8__TGT_R			0U
#define XHC_DBLDVX8__TGT_WIDTH			8U
#define XHC_DBLDVX8__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX8_WIDTH			32U
#define XHC_DBLDVX8__WIDTH			32U
#define XHC_DBLDVX8_ALL_L			31U
#define XHC_DBLDVX8_ALL_R			0U
#define XHC_DBLDVX8__ALL_L			31U
#define XHC_DBLDVX8__ALL_R			0U
#define XHC_DBLDVX8_DATAMASK			0xffffffffU
#define XHC_DBLDVX8_RDWRMASK			0x00000000U
#define XHC_DBLDVX8_RESETVALUE			0x00000000U

#define XHC_DBLDVX9_OFFSET			0x8e4U
#define XHC_DBLDVX9_BASE			0x8e4U
#define XHC_DBLDVX9__SID_L			31U
#define XHC_DBLDVX9__SID_R			16U
#define XHC_DBLDVX9__SID_WIDTH			16U
#define XHC_DBLDVX9__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX9__reserved_L			15U
#define XHC_DBLDVX9__reserved_R			8U
#define XHC_DBLDVX9__reserved_WIDTH		8U
#define XHC_DBLDVX9__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX9__TGT_L			7U
#define XHC_DBLDVX9__TGT_R			0U
#define XHC_DBLDVX9__TGT_WIDTH			8U
#define XHC_DBLDVX9__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX9_WIDTH			32U
#define XHC_DBLDVX9__WIDTH			32U
#define XHC_DBLDVX9_ALL_L			31U
#define XHC_DBLDVX9_ALL_R			0U
#define XHC_DBLDVX9__ALL_L			31U
#define XHC_DBLDVX9__ALL_R			0U
#define XHC_DBLDVX9_DATAMASK			0xffffffffU
#define XHC_DBLDVX9_RDWRMASK			0x00000000U
#define XHC_DBLDVX9_RESETVALUE			0x00000000U

#define XHC_DBLDVX10_OFFSET			0x8e8U
#define XHC_DBLDVX10_BASE			0x8e8U
#define XHC_DBLDVX10__SID_L			31U
#define XHC_DBLDVX10__SID_R			16U
#define XHC_DBLDVX10__SID_WIDTH			16U
#define XHC_DBLDVX10__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX10__reserved_L		15U
#define XHC_DBLDVX10__reserved_R		8U
#define XHC_DBLDVX10__reserved_WIDTH		8U
#define XHC_DBLDVX10__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX10__TGT_L			7U
#define XHC_DBLDVX10__TGT_R			0U
#define XHC_DBLDVX10__TGT_WIDTH			8U
#define XHC_DBLDVX10__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX10_WIDTH			32U
#define XHC_DBLDVX10__WIDTH			32U
#define XHC_DBLDVX10_ALL_L			31U
#define XHC_DBLDVX10_ALL_R			0U
#define XHC_DBLDVX10__ALL_L			31U
#define XHC_DBLDVX10__ALL_R			0U
#define XHC_DBLDVX10_DATAMASK			0xffffffffU
#define XHC_DBLDVX10_RDWRMASK			0x00000000U
#define XHC_DBLDVX10_RESETVALUE			0x00000000U

#define XHC_DBLDVX11_OFFSET			0x8ecU
#define XHC_DBLDVX11_BASE			0x8ecU
#define XHC_DBLDVX11__SID_L			31U
#define XHC_DBLDVX11__SID_R			16U
#define XHC_DBLDVX11__SID_WIDTH			16U
#define XHC_DBLDVX11__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX11__reserved_L		15U
#define XHC_DBLDVX11__reserved_R		8U
#define XHC_DBLDVX11__reserved_WIDTH		8U
#define XHC_DBLDVX11__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX11__TGT_L			7U
#define XHC_DBLDVX11__TGT_R			0U
#define XHC_DBLDVX11__TGT_WIDTH			8U
#define XHC_DBLDVX11__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX11_WIDTH			32U
#define XHC_DBLDVX11__WIDTH			32U
#define XHC_DBLDVX11_ALL_L			31U
#define XHC_DBLDVX11_ALL_R			0U
#define XHC_DBLDVX11__ALL_L			31U
#define XHC_DBLDVX11__ALL_R			0U
#define XHC_DBLDVX11_DATAMASK			0xffffffffU
#define XHC_DBLDVX11_RDWRMASK			0x00000000U
#define XHC_DBLDVX11_RESETVALUE			0x00000000U

#define XHC_DBLDVX12_OFFSET			0x8f0U
#define XHC_DBLDVX12_BASE			0x8f0U
#define XHC_DBLDVX12__SID_L			31U
#define XHC_DBLDVX12__SID_R			16U
#define XHC_DBLDVX12__SID_WIDTH			16U
#define XHC_DBLDVX12__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX12__reserved_L		15U
#define XHC_DBLDVX12__reserved_R		8U
#define XHC_DBLDVX12__reserved_WIDTH		8U
#define XHC_DBLDVX12__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX12__TGT_L			7U
#define XHC_DBLDVX12__TGT_R			0U
#define XHC_DBLDVX12__TGT_WIDTH			8U
#define XHC_DBLDVX12__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX12_WIDTH			32U
#define XHC_DBLDVX12__WIDTH			32U
#define XHC_DBLDVX12_ALL_L			31U
#define XHC_DBLDVX12_ALL_R			0U
#define XHC_DBLDVX12__ALL_L			31U
#define XHC_DBLDVX12__ALL_R			0U
#define XHC_DBLDVX12_DATAMASK			0xffffffffU
#define XHC_DBLDVX12_RDWRMASK			0x00000000U
#define XHC_DBLDVX12_RESETVALUE			0x00000000U

#define XHC_DBLDVX13_OFFSET			0x8f4U
#define XHC_DBLDVX13_BASE			0x8f4U
#define XHC_DBLDVX13__SID_L			31U
#define XHC_DBLDVX13__SID_R			16U
#define XHC_DBLDVX13__SID_WIDTH			16U
#define XHC_DBLDVX13__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX13__reserved_L		15U
#define XHC_DBLDVX13__reserved_R		8U
#define XHC_DBLDVX13__reserved_WIDTH		8U
#define XHC_DBLDVX13__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX13__TGT_L			7U
#define XHC_DBLDVX13__TGT_R			0U
#define XHC_DBLDVX13__TGT_WIDTH			8U
#define XHC_DBLDVX13__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX13_WIDTH			32U
#define XHC_DBLDVX13__WIDTH			32U
#define XHC_DBLDVX13_ALL_L			31U
#define XHC_DBLDVX13_ALL_R			0U
#define XHC_DBLDVX13__ALL_L			31U
#define XHC_DBLDVX13__ALL_R			0U
#define XHC_DBLDVX13_DATAMASK			0xffffffffU
#define XHC_DBLDVX13_RDWRMASK			0x00000000U
#define XHC_DBLDVX13_RESETVALUE			0x00000000U

#define XHC_DBLDVX14_OFFSET			0x8f8U
#define XHC_DBLDVX14_BASE			0x8f8U
#define XHC_DBLDVX14__SID_L			31U
#define XHC_DBLDVX14__SID_R			16U
#define XHC_DBLDVX14__SID_WIDTH			16U
#define XHC_DBLDVX14__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX14__reserved_L		15U
#define XHC_DBLDVX14__reserved_R		8U
#define XHC_DBLDVX14__reserved_WIDTH		8U
#define XHC_DBLDVX14__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX14__TGT_L			7U
#define XHC_DBLDVX14__TGT_R			0U
#define XHC_DBLDVX14__TGT_WIDTH			8U
#define XHC_DBLDVX14__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX14_WIDTH			32U
#define XHC_DBLDVX14__WIDTH			32U
#define XHC_DBLDVX14_ALL_L			31U
#define XHC_DBLDVX14_ALL_R			0U
#define XHC_DBLDVX14__ALL_L			31U
#define XHC_DBLDVX14__ALL_R			0U
#define XHC_DBLDVX14_DATAMASK			0xffffffffU
#define XHC_DBLDVX14_RDWRMASK			0x00000000U
#define XHC_DBLDVX14_RESETVALUE			0x00000000U

#define XHC_DBLDVX15_OFFSET			0x8fcU
#define XHC_DBLDVX15_BASE			0x8fcU
#define XHC_DBLDVX15__SID_L			31U
#define XHC_DBLDVX15__SID_R			16U
#define XHC_DBLDVX15__SID_WIDTH			16U
#define XHC_DBLDVX15__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX15__reserved_L		15U
#define XHC_DBLDVX15__reserved_R		8U
#define XHC_DBLDVX15__reserved_WIDTH		8U
#define XHC_DBLDVX15__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX15__TGT_L			7U
#define XHC_DBLDVX15__TGT_R			0U
#define XHC_DBLDVX15__TGT_WIDTH			8U
#define XHC_DBLDVX15__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX15_WIDTH			32U
#define XHC_DBLDVX15__WIDTH			32U
#define XHC_DBLDVX15_ALL_L			31U
#define XHC_DBLDVX15_ALL_R			0U
#define XHC_DBLDVX15__ALL_L			31U
#define XHC_DBLDVX15__ALL_R			0U
#define XHC_DBLDVX15_DATAMASK			0xffffffffU
#define XHC_DBLDVX15_RDWRMASK			0x00000000U
#define XHC_DBLDVX15_RESETVALUE			0x00000000U

#define XHC_DBLDVX16_OFFSET			0x900U
#define XHC_DBLDVX16_BASE			0x900U
#define XHC_DBLDVX16__SID_L			31U
#define XHC_DBLDVX16__SID_R			16U
#define XHC_DBLDVX16__SID_WIDTH			16U
#define XHC_DBLDVX16__SID_RESETVALUE		0x0000U
#define XHC_DBLDVX16__reserved_L		15U
#define XHC_DBLDVX16__reserved_R		8U
#define XHC_DBLDVX16__reserved_WIDTH		8U
#define XHC_DBLDVX16__reserved_RESETVALUE	0x00U
#define XHC_DBLDVX16__TGT_L			7U
#define XHC_DBLDVX16__TGT_R			0U
#define XHC_DBLDVX16__TGT_WIDTH			8U
#define XHC_DBLDVX16__TGT_RESETVALUE		0x00U
#define XHC_DBLDVX16_WIDTH			32U
#define XHC_DBLDVX16__WIDTH			32U
#define XHC_DBLDVX16_ALL_L			31U
#define XHC_DBLDVX16_ALL_R			0U
#define XHC_DBLDVX16__ALL_L			31U
#define XHC_DBLDVX16__ALL_R			0U
#define XHC_DBLDVX16_DATAMASK			0xffffffffU
#define XHC_DBLDVX16_RDWRMASK			0x00000000U
#define XHC_DBLDVX16_RESETVALUE			0x00000000U

#define XHC_ECHSPT3_OFFSET			0x940U
#define XHC_ECHSPT3_BASE			0x940U
#define XHC_ECHSPT3__RMAJ_L			31U
#define XHC_ECHSPT3__RMAJ_R			24U
#define XHC_ECHSPT3__RMAJ_WIDTH			8U
#define XHC_ECHSPT3__RMAJ_RESETVALUE		0x00U
#define XHC_ECHSPT3__RMIN_L			23U
#define XHC_ECHSPT3__RMIN_R			16U
#define XHC_ECHSPT3__RMIN_WIDTH			8U
#define XHC_ECHSPT3__RMIN_RESETVALUE		0x00U
#define XHC_ECHSPT3__NCP_L			15U
#define XHC_ECHSPT3__NCP_R			8U
#define XHC_ECHSPT3__NCP_WIDTH			8U
#define XHC_ECHSPT3__NCP_RESETVALUE		0x00U
#define XHC_ECHSPT3__CID_L			7U
#define XHC_ECHSPT3__CID_R			0U
#define XHC_ECHSPT3__CID_WIDTH			8U
#define XHC_ECHSPT3__CID_RESETVALUE		0x02U
#define XHC_ECHSPT3_WIDTH			32U
#define XHC_ECHSPT3__WIDTH			32U
#define XHC_ECHSPT3_ALL_L			31U
#define XHC_ECHSPT3_ALL_R			0U
#define XHC_ECHSPT3__ALL_L			31U
#define XHC_ECHSPT3__ALL_R			0U
#define XHC_ECHSPT3_DATAMASK			0xffffffffU
#define XHC_ECHSPT3_RDWRMASK			0x00000000U
#define XHC_ECHSPT3_RESETVALUE			0x00000002U

#define XHC_PNSTR3_OFFSET			0x944U
#define XHC_PNSTR3_BASE				0x944U
#define XHC_PNSTR3__STR_L			31U
#define XHC_PNSTR3__STR_R			0U
#define XHC_PNSTR3__STR_WIDTH			32U
#define XHC_PNSTR3__STR_RESETVALUE		0x20425355U
#define XHC_PNSTR3_WIDTH			32U
#define XHC_PNSTR3__WIDTH			32U
#define XHC_PNSTR3_ALL_L			31U
#define XHC_PNSTR3_ALL_R			0U
#define XHC_PNSTR3__ALL_L			31U
#define XHC_PNSTR3__ALL_R			0U
#define XHC_PNSTR3_DATAMASK			0xffffffffU
#define XHC_PNSTR3_RDWRMASK			0x00000000U
#define XHC_PNSTR3_RESETVALUE			0x20425355U

#define XHC_PSUM3_OFFSET			0x948U
#define XHC_PSUM3_BASE				0x948U
#define XHC_PSUM3__PSIC_L			31U
#define XHC_PSUM3__PSIC_R			28U
#define XHC_PSUM3__PSIC_WIDTH			4U
#define XHC_PSUM3__PSIC_RESETVALUE		0x0U
#define XHC_PSUM3__MHD_L			27U
#define XHC_PSUM3__MHD_R			25U
#define XHC_PSUM3__MHD_WIDTH			3U
#define XHC_PSUM3__MHD_RESETVALUE		0x0U
#define XHC_PSUM3__BLC				20U
#define XHC_PSUM3__BLC_L			20U
#define XHC_PSUM3__BLC_R			20U
#define XHC_PSUM3__BLC_WIDTH			1U
#define XHC_PSUM3__BLC_RESETVALUE		0x0U
#define XHC_PSUM3__HLC				19U
#define XHC_PSUM3__HLC_L			19U
#define XHC_PSUM3__HLC_R			19U
#define XHC_PSUM3__HLC_WIDTH			1U
#define XHC_PSUM3__HLC_RESETVALUE		0x1U
#define XHC_PSUM3__IHI				18U
#define XHC_PSUM3__IHI_L			18U
#define XHC_PSUM3__IHI_R			18U
#define XHC_PSUM3__IHI_WIDTH			1U
#define XHC_PSUM3__IHI_RESETVALUE		0x0U
#define XHC_PSUM3__HSO				17U
#define XHC_PSUM3__HSO_L			17U
#define XHC_PSUM3__HSO_R			17U
#define XHC_PSUM3__HSO_WIDTH			1U
#define XHC_PSUM3__HSO_RESETVALUE		0x0U
#define XHC_PSUM3__reserved			16U
#define XHC_PSUM3__reserved_L			16U
#define XHC_PSUM3__reserved_R			16U
#define XHC_PSUM3__reserved_WIDTH		1U
#define XHC_PSUM3__reserved_RESETVALUE		0x0U
#define XHC_PSUM3__CPC_L			15U
#define XHC_PSUM3__CPC_R			8U
#define XHC_PSUM3__CPC_WIDTH			8U
#define XHC_PSUM3__CPC_RESETVALUE		0x00U
#define XHC_PSUM3__CPO_L			7U
#define XHC_PSUM3__CPO_R			0U
#define XHC_PSUM3__CPO_WIDTH			8U
#define XHC_PSUM3__CPO_RESETVALUE		0x00U
#define XHC_PSUM3__RESERVED_L			24U
#define XHC_PSUM3__RESERVED_R			21U
#define XHC_PSUM3_WIDTH				32U
#define XHC_PSUM3__WIDTH			32U
#define XHC_PSUM3_ALL_L				31U
#define XHC_PSUM3_ALL_R				0U
#define XHC_PSUM3__ALL_L			31U
#define XHC_PSUM3__ALL_R			0U
#define XHC_PSUM3_DATAMASK			0xfe1fffffU
#define XHC_PSUM3_RDWRMASK			0x01e00000U
#define XHC_PSUM3_RESETVALUE			0x00080000U

#define XHC_PTSLTYP3_OFFSET			0x94cU
#define XHC_PTSLTYP3_BASE			0x94cU
#define XHC_PTSLTYP3__reserved_L		31U
#define XHC_PTSLTYP3__reserved_R		5U
#define XHC_PTSLTYP3__reserved_WIDTH		27U
#define XHC_PTSLTYP3__reserved_RESETVALUE	0x0U
#define XHC_PTSLTYP3__PST_L			4U
#define XHC_PTSLTYP3__PST_R			0U
#define XHC_PTSLTYP3__PST_WIDTH			5U
#define XHC_PTSLTYP3__PST_RESETVALUE		0x0U
#define XHC_PTSLTYP3_WIDTH			32U
#define XHC_PTSLTYP3__WIDTH			32U
#define XHC_PTSLTYP3_ALL_L			31U
#define XHC_PTSLTYP3_ALL_R			0U
#define XHC_PTSLTYP3__ALL_L			31U
#define XHC_PTSLTYP3__ALL_R			0U
#define XHC_PTSLTYP3_DATAMASK			0xffffffffU
#define XHC_PTSLTYP3_RDWRMASK			0x00000000U
#define XHC_PTSLTYP3_RESETVALUE			0x00000000U

#define XHC_ECHSPT2_OFFSET			0x950U
#define XHC_ECHSPT2_BASE			0x950U
#define XHC_ECHSPT2__RMAJ_L			31U
#define XHC_ECHSPT2__RMAJ_R			24U
#define XHC_ECHSPT2__RMAJ_WIDTH			8U
#define XHC_ECHSPT2__RMAJ_RESETVALUE		0x00U
#define XHC_ECHSPT2__RMIN_L			23U
#define XHC_ECHSPT2__RMIN_R			16U
#define XHC_ECHSPT2__RMIN_WIDTH			8U
#define XHC_ECHSPT2__RMIN_RESETVALUE		0x00U
#define XHC_ECHSPT2__NCP_L			15U
#define XHC_ECHSPT2__NCP_R			8U
#define XHC_ECHSPT2__NCP_WIDTH			8U
#define XHC_ECHSPT2__NCP_RESETVALUE		0x00U
#define XHC_ECHSPT2__CID_L			7U
#define XHC_ECHSPT2__CID_R			0U
#define XHC_ECHSPT2__CID_WIDTH			8U
#define XHC_ECHSPT2__CID_RESETVALUE		0x02U
#define XHC_ECHSPT2_WIDTH			32U
#define XHC_ECHSPT2__WIDTH			32U
#define XHC_ECHSPT2_ALL_L			31U
#define XHC_ECHSPT2_ALL_R			0U
#define XHC_ECHSPT2__ALL_L			31U
#define XHC_ECHSPT2__ALL_R			0U
#define XHC_ECHSPT2_DATAMASK			0xffffffffU
#define XHC_ECHSPT2_RDWRMASK			0x00000000U
#define XHC_ECHSPT2_RESETVALUE			0x00000002U

#define XHC_PNSTR2_OFFSET			0x954U
#define XHC_PNSTR2_BASE				0x954U
#define XHC_PNSTR2__STR_L			31U
#define XHC_PNSTR2__STR_R			0U
#define XHC_PNSTR2__STR_WIDTH			32U
#define XHC_PNSTR2__STR_RESETVALUE		0x20425355U
#define XHC_PNSTR2_WIDTH			32U
#define XHC_PNSTR2__WIDTH			32U
#define XHC_PNSTR2_ALL_L			31U
#define XHC_PNSTR2_ALL_R			0U
#define XHC_PNSTR2__ALL_L			31U
#define XHC_PNSTR2__ALL_R			0U
#define XHC_PNSTR2_DATAMASK			0xffffffffU
#define XHC_PNSTR2_RDWRMASK			0x00000000U
#define XHC_PNSTR2_RESETVALUE			0x20425355U

#define XHC_PSUM2_OFFSET			0x958U
#define XHC_PSUM2_BASE				0x958U
#define XHC_PSUM2__PSIC_L			31U
#define XHC_PSUM2__PSIC_R			28U
#define XHC_PSUM2__PSIC_WIDTH			4U
#define XHC_PSUM2__PSIC_RESETVALUE		0x0U
#define XHC_PSUM2__MHD_L			27U
#define XHC_PSUM2__MHD_R			25U
#define XHC_PSUM2__MHD_WIDTH			3U
#define XHC_PSUM2__MHD_RESETVALUE		0x0U
#define XHC_PSUM2__BLC				20U
#define XHC_PSUM2__BLC_L			20U
#define XHC_PSUM2__BLC_R			20U
#define XHC_PSUM2__BLC_WIDTH			1U
#define XHC_PSUM2__BLC_RESETVALUE		0x0U
#define XHC_PSUM2__HLC				19U
#define XHC_PSUM2__HLC_L			19U
#define XHC_PSUM2__HLC_R			19U
#define XHC_PSUM2__HLC_WIDTH			1U
#define XHC_PSUM2__HLC_RESETVALUE		0x1U
#define XHC_PSUM2__IHI				18U
#define XHC_PSUM2__IHI_L			18U
#define XHC_PSUM2__IHI_R			18U
#define XHC_PSUM2__IHI_WIDTH			1U
#define XHC_PSUM2__IHI_RESETVALUE		0x0U
#define XHC_PSUM2__HSO				17U
#define XHC_PSUM2__HSO_L			17U
#define XHC_PSUM2__HSO_R			17U
#define XHC_PSUM2__HSO_WIDTH			1U
#define XHC_PSUM2__HSO_RESETVALUE		0x0U
#define XHC_PSUM2__reserved			16U
#define XHC_PSUM2__reserved_L			16U
#define XHC_PSUM2__reserved_R			16U
#define XHC_PSUM2__reserved_WIDTH		1U
#define XHC_PSUM2__reserved_RESETVALUE		0x0U
#define XHC_PSUM2__CPC_L			15U
#define XHC_PSUM2__CPC_R			8U
#define XHC_PSUM2__CPC_WIDTH			8U
#define XHC_PSUM2__CPC_RESETVALUE		0x00U
#define XHC_PSUM2__CPO_L			7U
#define XHC_PSUM2__CPO_R			0U
#define XHC_PSUM2__CPO_WIDTH			8U
#define XHC_PSUM2__CPO_RESETVALUE		0x00U
#define XHC_PSUM2__RESERVED_L			24U
#define XHC_PSUM2__RESERVED_R			21U
#define XHC_PSUM2_WIDTH				32U
#define XHC_PSUM2__WIDTH			32U
#define XHC_PSUM2_ALL_L				31U
#define XHC_PSUM2_ALL_R				0U
#define XHC_PSUM2__ALL_L			31U
#define XHC_PSUM2__ALL_R			0U
#define XHC_PSUM2_DATAMASK			0xfe1fffffU
#define XHC_PSUM2_RDWRMASK			0x01e00000U
#define XHC_PSUM2_RESETVALUE			0x00080000U

#define XHC_PTSLTYP2_OFFSET			0x95cU
#define XHC_PTSLTYP2_BASE			0x95cU
#define XHC_PTSLTYP2__reserved_L		31U
#define XHC_PTSLTYP2__reserved_R		5U
#define XHC_PTSLTYP2__reserved_WIDTH		27U
#define XHC_PTSLTYP2__reserved_RESETVALUE	0x0U
#define XHC_PTSLTYP2__PST_L			4U
#define XHC_PTSLTYP2__PST_R			0U
#define XHC_PTSLTYP2__PST_WIDTH			5U
#define XHC_PTSLTYP2__PST_RESETVALUE		0x0U
#define XHC_PTSLTYP2_WIDTH			32U
#define XHC_PTSLTYP2__WIDTH			32U
#define XHC_PTSLTYP2_ALL_L			31U
#define XHC_PTSLTYP2_ALL_R			0U
#define XHC_PTSLTYP2__ALL_L			31U
#define XHC_PTSLTYP2__ALL_R			0U
#define XHC_PTSLTYP2_DATAMASK			0xffffffffU
#define XHC_PTSLTYP2_RDWRMASK			0x00000000U
#define XHC_PTSLTYP2_RESETVALUE			0x00000000U

#define XHC_ECHRSVP_OFFSET			0x960U
#define XHC_ECHRSVP_BASE			0x960U
#define XHC_ECHRSVP__reserved_L			31U
#define XHC_ECHRSVP__reserved_R			16U
#define XHC_ECHRSVP__reserved_WIDTH		16U
#define XHC_ECHRSVP__reserved_RESETVALUE	0x0000U
#define XHC_ECHRSVP__NCP_L			15U
#define XHC_ECHRSVP__NCP_R			8U
#define XHC_ECHRSVP__NCP_WIDTH			8U
#define XHC_ECHRSVP__NCP_RESETVALUE		0x00U
#define XHC_ECHRSVP__CID_L			7U
#define XHC_ECHRSVP__CID_R			0U
#define XHC_ECHRSVP__CID_WIDTH			8U
#define XHC_ECHRSVP__CID_RESETVALUE		0xffU
#define XHC_ECHRSVP_WIDTH			32U
#define XHC_ECHRSVP__WIDTH			32U
#define XHC_ECHRSVP_ALL_L			31U
#define XHC_ECHRSVP_ALL_R			0U
#define XHC_ECHRSVP__ALL_L			31U
#define XHC_ECHRSVP__ALL_R			0U
#define XHC_ECHRSVP_DATAMASK			0xffffffffU
#define XHC_ECHRSVP_RDWRMASK			0x00000000U
#define XHC_ECHRSVP_RESETVALUE			0x000000ffU

#define XHC_ECHRSVI_OFFSET			0x968U
#define XHC_ECHRSVI_BASE			0x968U
#define XHC_ECHRSVI__reserved_L			31U
#define XHC_ECHRSVI__reserved_R			16U
#define XHC_ECHRSVI__reserved_WIDTH		16U
#define XHC_ECHRSVI__reserved_RESETVALUE	0x0000U
#define XHC_ECHRSVI__NCP_L			15U
#define XHC_ECHRSVI__NCP_R			8U
#define XHC_ECHRSVI__NCP_WIDTH			8U
#define XHC_ECHRSVI__NCP_RESETVALUE		0x00U
#define XHC_ECHRSVI__CID_L			7U
#define XHC_ECHRSVI__CID_R			0U
#define XHC_ECHRSVI__CID_WIDTH			8U
#define XHC_ECHRSVI__CID_RESETVALUE		0xffU
#define XHC_ECHRSVI_WIDTH			32U
#define XHC_ECHRSVI__WIDTH			32U
#define XHC_ECHRSVI_ALL_L			31U
#define XHC_ECHRSVI_ALL_R			0U
#define XHC_ECHRSVI__ALL_L			31U
#define XHC_ECHRSVI__ALL_R			0U
#define XHC_ECHRSVI_DATAMASK			0xffffffffU
#define XHC_ECHRSVI_RDWRMASK			0x00000000U
#define XHC_ECHRSVI_RESETVALUE			0x000000ffU

#define XHC_ECHRSVM_OFFSET			0xae8U
#define XHC_ECHRSVM_BASE			0xae8U
#define XHC_ECHRSVM__reserved_L			31U
#define XHC_ECHRSVM__reserved_R			16U
#define XHC_ECHRSVM__reserved_WIDTH		16U
#define XHC_ECHRSVM__reserved_RESETVALUE	0x0000U
#define XHC_ECHRSVM__NCP_L			15U
#define XHC_ECHRSVM__NCP_R			8U
#define XHC_ECHRSVM__NCP_WIDTH			8U
#define XHC_ECHRSVM__NCP_RESETVALUE		0x00U
#define XHC_ECHRSVM__CID_L			7U
#define XHC_ECHRSVM__CID_R			0U
#define XHC_ECHRSVM__CID_WIDTH			8U
#define XHC_ECHRSVM__CID_RESETVALUE		0xffU
#define XHC_ECHRSVM_WIDTH			32U
#define XHC_ECHRSVM__WIDTH			32U
#define XHC_ECHRSVM_ALL_L			31U
#define XHC_ECHRSVM_ALL_R			0U
#define XHC_ECHRSVM__ALL_L			31U
#define XHC_ECHRSVM__ALL_R			0U
#define XHC_ECHRSVM_DATAMASK			0xffffffffU
#define XHC_ECHRSVM_RDWRMASK			0x00000000U
#define XHC_ECHRSVM_RESETVALUE			0x000000ffU

#define XHC_ECHRSVD_OFFSET			0xaf8U
#define XHC_ECHRSVD_BASE			0xaf8U
#define XHC_ECHRSVD__reserved_L			31U
#define XHC_ECHRSVD__reserved_R			16U
#define XHC_ECHRSVD__reserved_WIDTH		16U
#define XHC_ECHRSVD__reserved_RESETVALUE	0x0000U
#define XHC_ECHRSVD__NCP_L			15U
#define XHC_ECHRSVD__NCP_R			8U
#define XHC_ECHRSVD__NCP_WIDTH			8U
#define XHC_ECHRSVD__NCP_RESETVALUE		0x00U
#define XHC_ECHRSVD__CID_L			7U
#define XHC_ECHRSVD__CID_R			0U
#define XHC_ECHRSVD__CID_WIDTH			8U
#define XHC_ECHRSVD__CID_RESETVALUE		0xffU
#define XHC_ECHRSVD_WIDTH			32U
#define XHC_ECHRSVD__WIDTH			32U
#define XHC_ECHRSVD_ALL_L			31U
#define XHC_ECHRSVD_ALL_R			0U
#define XHC_ECHRSVD__ALL_L			31U
#define XHC_ECHRSVD__ALL_R			0U
#define XHC_ECHRSVD_DATAMASK			0xffffffffU
#define XHC_ECHRSVD_RDWRMASK			0x00000000U
#define XHC_ECHRSVD_RESETVALUE			0x000000ffU

#define XHC_ECHRSVO_OFFSET			0xb38U
#define XHC_ECHRSVO_BASE			0xb38U
#define XHC_ECHRSVO__reserved_L			31U
#define XHC_ECHRSVO__reserved_R			16U
#define XHC_ECHRSVO__reserved_WIDTH		16U
#define XHC_ECHRSVO__reserved_RESETVALUE	0x0000U
#define XHC_ECHRSVO__NCP_L			15U
#define XHC_ECHRSVO__NCP_R			8U
#define XHC_ECHRSVO__NCP_WIDTH			8U
#define XHC_ECHRSVO__NCP_RESETVALUE		0x00U
#define XHC_ECHRSVO__CID_L			7U
#define XHC_ECHRSVO__CID_R			0U
#define XHC_ECHRSVO__CID_WIDTH			8U
#define XHC_ECHRSVO__CID_RESETVALUE		0xffU
#define XHC_ECHRSVO_WIDTH			32U
#define XHC_ECHRSVO__WIDTH			32U
#define XHC_ECHRSVO_ALL_L			31U
#define XHC_ECHRSVO_ALL_R			0U
#define XHC_ECHRSVO__ALL_L			31U
#define XHC_ECHRSVO__ALL_R			0U
#define XHC_ECHRSVO_DATAMASK			0xffffffffU
#define XHC_ECHRSVO_RDWRMASK			0x00000000U
#define XHC_ECHRSVO_RESETVALUE			0x000000ffU

#define XHC_ECHCTT_OFFSET			0xbf0U
#define XHC_ECHCTT_BASE				0xbf0U
#define XHC_ECHCTT__reserved_L			31U
#define XHC_ECHCTT__reserved_R			16U
#define XHC_ECHCTT__reserved_WIDTH		16U
#define XHC_ECHCTT__reserved_RESETVALUE		0x0000U
#define XHC_ECHCTT__NCP_L			15U
#define XHC_ECHCTT__NCP_R			8U
#define XHC_ECHCTT__NCP_WIDTH			8U
#define XHC_ECHCTT__NCP_RESETVALUE		0x04U
#define XHC_ECHCTT__CID_L			7U
#define XHC_ECHCTT__CID_R			0U
#define XHC_ECHCTT__CID_WIDTH			8U
#define XHC_ECHCTT__CID_RESETVALUE		0xe0U
#define XHC_ECHCTT_WIDTH			32U
#define XHC_ECHCTT__WIDTH			32U
#define XHC_ECHCTT_ALL_L			31U
#define XHC_ECHCTT_ALL_R			0U
#define XHC_ECHCTT__ALL_L			31U
#define XHC_ECHCTT__ALL_R			0U
#define XHC_ECHCTT_DATAMASK			0xffffffffU
#define XHC_ECHCTT_RDWRMASK			0x00000000U
#define XHC_ECHCTT_RESETVALUE			0x000004e0U

#define XHC_CTTMTS0_OFFSET			0xbf8U
#define XHC_CTTMTS0_BASE			0xbf8U
#define XHC_CTTMTS0__DCM			31U
#define XHC_CTTMTS0__DCM_L			31U
#define XHC_CTTMTS0__DCM_R			31U
#define XHC_CTTMTS0__DCM_WIDTH			1U
#define XHC_CTTMTS0__DCM_RESETVALUE		0x0U
#define XHC_CTTMTS0__reserved_L			30U
#define XHC_CTTMTS0__reserved_R			10U
#define XHC_CTTMTS0__reserved_WIDTH		21U
#define XHC_CTTMTS0__reserved_RESETVALUE	0x0U
#define XHC_CTTMTS0__SLA_L			9U
#define XHC_CTTMTS0__SLA_R			0U
#define XHC_CTTMTS0__SLA_WIDTH			10U
#define XHC_CTTMTS0__SLA_RESETVALUE		0x0U
#define XHC_CTTMTS0_WIDTH			32U
#define XHC_CTTMTS0__WIDTH			32U
#define XHC_CTTMTS0_ALL_L			31U
#define XHC_CTTMTS0_ALL_R			0U
#define XHC_CTTMTS0__ALL_L			31U
#define XHC_CTTMTS0__ALL_R			0U
#define XHC_CTTMTS0_DATAMASK			0xffffffffU
#define XHC_CTTMTS0_RDWRMASK			0x00000000U
#define XHC_CTTMTS0_RESETVALUE			0x00000000U

#define XHC_CTTMTS1_OFFSET			0xbfcU
#define XHC_CTTMTS1_BASE			0xbfcU
#define XHC_CTTMTS1__TXF_L			25U
#define XHC_CTTMTS1__TXF_R			16U
#define XHC_CTTMTS1__TXF_WIDTH			10U
#define XHC_CTTMTS1__TXF_RESETVALUE		0x0U
#define XHC_CTTMTS1__reserved_L			15U
#define XHC_CTTMTS1__reserved_R			10U
#define XHC_CTTMTS1__reserved_WIDTH		6U
#define XHC_CTTMTS1__reserved_RESETVALUE	0x0U
#define XHC_CTTMTS1__RXF_L			9U
#define XHC_CTTMTS1__RXF_R			0U
#define XHC_CTTMTS1__RXF_WIDTH			10U
#define XHC_CTTMTS1__RXF_RESETVALUE		0x0U
#define XHC_CTTMTS1__RESERVED_L			31U
#define XHC_CTTMTS1__RESERVED_R			26U
#define XHC_CTTMTS1_WIDTH			26U
#define XHC_CTTMTS1__WIDTH			26U
#define XHC_CTTMTS1_ALL_L			25U
#define XHC_CTTMTS1_ALL_R			0U
#define XHC_CTTMTS1__ALL_L			25U
#define XHC_CTTMTS1__ALL_R			0U
#define XHC_CTTMTS1_DATAMASK			0x03ffffffU
#define XHC_CTTMTS1_RDWRMASK			0xfc000000U
#define XHC_CTTMTS1_RESETVALUE			0x0000000U

#define XHC_ECHBIU_OFFSET			0xc00U
#define XHC_ECHBIU_BASE				0xc00U
#define XHC_ECHBIU__CLK_L			31U
#define XHC_ECHBIU__CLK_R			21U
#define XHC_ECHBIU__CLK_WIDTH			11U
#define XHC_ECHBIU__CLK_RESETVALUE		0x0U
#define XHC_ECHBIU__reserved_L			20U
#define XHC_ECHBIU__reserved_R			19U
#define XHC_ECHBIU__reserved_WIDTH		2U
#define XHC_ECHBIU__reserved_RESETVALUE		0x0U
#define XHC_ECHBIU__WID_L			18U
#define XHC_ECHBIU__WID_R			16U
#define XHC_ECHBIU__WID_WIDTH			3U
#define XHC_ECHBIU__WID_RESETVALUE		0x0U
#define XHC_ECHBIU__NCP_L			15U
#define XHC_ECHBIU__NCP_R			8U
#define XHC_ECHBIU__NCP_WIDTH			8U
#define XHC_ECHBIU__NCP_RESETVALUE		0x08U
#define XHC_ECHBIU__CID_L			7U
#define XHC_ECHBIU__CID_R			0U
#define XHC_ECHBIU__CID_WIDTH			8U
#define XHC_ECHBIU__CID_RESETVALUE		0xc0U
#define XHC_ECHBIU_WIDTH			32U
#define XHC_ECHBIU__WIDTH			32U
#define XHC_ECHBIU_ALL_L			31U
#define XHC_ECHBIU_ALL_R			0U
#define XHC_ECHBIU__ALL_L			31U
#define XHC_ECHBIU__ALL_R			0U
#define XHC_ECHBIU_DATAMASK			0xffffffffU
#define XHC_ECHBIU_RDWRMASK			0x00000000U
#define XHC_ECHBIU_RESETVALUE			0x000008c0U

#define XHC_BIUSPC_OFFSET			0xc04U
#define XHC_BIUSPC_BASE				0xc04U
#define XHC_BIUSPC__MAJ_L			31U
#define XHC_BIUSPC__MAJ_R			28U
#define XHC_BIUSPC__MAJ_WIDTH			4U
#define XHC_BIUSPC__MAJ_RESETVALUE		0x0U
#define XHC_BIUSPC__MIN_L			27U
#define XHC_BIUSPC__MIN_R			24U
#define XHC_BIUSPC__MIN_WIDTH			4U
#define XHC_BIUSPC__MIN_RESETVALUE		0x0U
#define XHC_BIUSPC__RLS_L			23U
#define XHC_BIUSPC__RLS_R			20U
#define XHC_BIUSPC__RLS_WIDTH			4U
#define XHC_BIUSPC__RLS_RESETVALUE		0x0U
#define XHC_BIUSPC__reserved_L			19U
#define XHC_BIUSPC__reserved_R			4U
#define XHC_BIUSPC__reserved_WIDTH		16U
#define XHC_BIUSPC__reserved_RESETVALUE		0x0000U
#define XHC_BIUSPC__SPI_L			3U
#define XHC_BIUSPC__SPI_R			2U
#define XHC_BIUSPC__SPI_WIDTH			2U
#define XHC_BIUSPC__SPI_RESETVALUE		0x3U
#define XHC_BIUSPC__TYP_L			1U
#define XHC_BIUSPC__TYP_R			0U
#define XHC_BIUSPC__TYP_WIDTH			2U
#define XHC_BIUSPC__TYP_RESETVALUE		0x0U
#define XHC_BIUSPC_WIDTH			32U
#define XHC_BIUSPC__WIDTH			32U
#define XHC_BIUSPC_ALL_L			31U
#define XHC_BIUSPC_ALL_R			0U
#define XHC_BIUSPC__ALL_L			31U
#define XHC_BIUSPC__ALL_R			0U
#define XHC_BIUSPC_DATAMASK			0xffffffffU
#define XHC_BIUSPC_RDWRMASK			0x00000000U
#define XHC_BIUSPC_RESETVALUE			0x0000000cU

#define XHC_AXIWRA_OFFSET			0xc08U
#define XHC_AXIWRA_BASE				0xc08U
#define XHC_AXIWRA__WTS_L			31U
#define XHC_AXIWRA__WTS_R			28U
#define XHC_AXIWRA__WTS_WIDTH			4U
#define XHC_AXIWRA__WTS_RESETVALUE		0x2U
#define XHC_AXIWRA__WUA_L			24U
#define XHC_AXIWRA__WUA_R			16U
#define XHC_AXIWRA__WUA_WIDTH			9U
#define XHC_AXIWRA__WUA_RESETVALUE		0x0U
#define XHC_AXIWRA__reserved_L			15U
#define XHC_AXIWRA__reserved_R			10U
#define XHC_AXIWRA__reserved_WIDTH		6U
#define XHC_AXIWRA__reserved_RESETVALUE		0x0U
#define XHC_AXIWRA__BYP				9U
#define XHC_AXIWRA__BYP_L			9U
#define XHC_AXIWRA__BYP_R			9U
#define XHC_AXIWRA__BYP_WIDTH			1U
#define XHC_AXIWRA__BYP_RESETVALUE		0x0U
#define XHC_AXIWRA__WSA_L			8U
#define XHC_AXIWRA__WSA_R			0U
#define XHC_AXIWRA__WSA_WIDTH			9U
#define XHC_AXIWRA__WSA_RESETVALUE		0x0U
#define XHC_AXIWRA__RESERVED_L			27U
#define XHC_AXIWRA__RESERVED_R			25U
#define XHC_AXIWRA_WIDTH			32U
#define XHC_AXIWRA__WIDTH			32U
#define XHC_AXIWRA_ALL_L			31U
#define XHC_AXIWRA_ALL_R			0U
#define XHC_AXIWRA__ALL_L			31U
#define XHC_AXIWRA__ALL_R			0U
#define XHC_AXIWRA_DATAMASK			0xf1ffffffU
#define XHC_AXIWRA_RDWRMASK			0x0e000000U
#define XHC_AXIWRA_RESETVALUE			0x20000000U

#define XHC_AXIRDA_OFFSET			0xc0cU
#define XHC_AXIRDA_BASE				0xc0cU
#define XHC_AXIRDA__RTS_L			31U
#define XHC_AXIRDA__RTS_R			28U
#define XHC_AXIRDA__RTS_WIDTH			4U
#define XHC_AXIRDA__RTS_RESETVALUE		0x2U
#define XHC_AXIRDA__RFPC			27U
#define XHC_AXIRDA__RFPC_L			27U
#define XHC_AXIRDA__RFPC_R			27U
#define XHC_AXIRDA__RFPC_WIDTH			1U
#define XHC_AXIRDA__RFPC_RESETVALUE		0x0U
#define XHC_AXIRDA__RUA_L			24U
#define XHC_AXIRDA__RUA_R			16U
#define XHC_AXIRDA__RUA_WIDTH			9U
#define XHC_AXIRDA__RUA_RESETVALUE		0x0U
#define XHC_AXIRDA__reserved_L			15U
#define XHC_AXIRDA__reserved_R			9U
#define XHC_AXIRDA__reserved_WIDTH		7U
#define XHC_AXIRDA__reserved_RESETVALUE		0x0U
#define XHC_AXIRDA__RSA_L			8U
#define XHC_AXIRDA__RSA_R			0U
#define XHC_AXIRDA__RSA_WIDTH			9U
#define XHC_AXIRDA__RSA_RESETVALUE		0x0U
#define XHC_AXIRDA__RESERVED_L			26U
#define XHC_AXIRDA__RESERVED_R			25U
#define XHC_AXIRDA_WIDTH			32U
#define XHC_AXIRDA__WIDTH			32U
#define XHC_AXIRDA_ALL_L			31U
#define XHC_AXIRDA_ALL_R			0U
#define XHC_AXIRDA__ALL_L			31U
#define XHC_AXIRDA__ALL_R			0U
#define XHC_AXIRDA_DATAMASK			0xf9ffffffU
#define XHC_AXIRDA_RDWRMASK			0x06000000U
#define XHC_AXIRDA_RESETVALUE			0x20000000U

#define XHC_AXILPM_OFFSET			0xc10U
#define XHC_AXILPM_BASE				0xc10U
#define XHC_AXILPM__ENB				31U
#define XHC_AXILPM__ENB_L			31U
#define XHC_AXILPM__ENB_R			31U
#define XHC_AXILPM__ENB_WIDTH			1U
#define XHC_AXILPM__ENB_RESETVALUE		0x0U
#define XHC_AXILPM__reserved_L			30U
#define XHC_AXILPM__reserved_R			3U
#define XHC_AXILPM__reserved_WIDTH		28U
#define XHC_AXILPM__reserved_RESETVALUE		0x0000000U
#define XHC_AXILPM__ITT_L			2U
#define XHC_AXILPM__ITT_R			0U
#define XHC_AXILPM__ITT_WIDTH			3U
#define XHC_AXILPM__ITT_RESETVALUE		0x0U
#define XHC_AXILPM_WIDTH			32U
#define XHC_AXILPM__WIDTH			32U
#define XHC_AXILPM_ALL_L			31U
#define XHC_AXILPM_ALL_R			0U
#define XHC_AXILPM__ALL_L			31U
#define XHC_AXILPM__ALL_R			0U
#define XHC_AXILPM_DATAMASK			0xffffffffU
#define XHC_AXILPM_RDWRMASK			0x00000000U
#define XHC_AXILPM_RESETVALUE			0x00000000U

#define XHC_AXIQOS_OFFSET			0xc14U
#define XHC_AXIQOS_BASE				0xc14U
#define XHC_AXIQOS__WQOS3_L			31U
#define XHC_AXIQOS__WQOS3_R			28U
#define XHC_AXIQOS__WQOS3_WIDTH			4U
#define XHC_AXIQOS__WQOS3_RESETVALUE		0x0U
#define XHC_AXIQOS__WQOS2_L			27U
#define XHC_AXIQOS__WQOS2_R			24U
#define XHC_AXIQOS__WQOS2_WIDTH			4U
#define XHC_AXIQOS__WQOS2_RESETVALUE		0x0U
#define XHC_AXIQOS__WQOS1_L			23U
#define XHC_AXIQOS__WQOS1_R			20U
#define XHC_AXIQOS__WQOS1_WIDTH			4U
#define XHC_AXIQOS__WQOS1_RESETVALUE		0x0U
#define XHC_AXIQOS__WQOS0_L			19U
#define XHC_AXIQOS__WQOS0_R			16U
#define XHC_AXIQOS__WQOS0_WIDTH			4U
#define XHC_AXIQOS__WQOS0_RESETVALUE		0x0U
#define XHC_AXIQOS__RQOS3_L			15U
#define XHC_AXIQOS__RQOS3_R			12U
#define XHC_AXIQOS__RQOS3_WIDTH			4U
#define XHC_AXIQOS__RQOS3_RESETVALUE		0x0U
#define XHC_AXIQOS__RQOS2_L			11U
#define XHC_AXIQOS__RQOS2_R			8U
#define XHC_AXIQOS__RQOS2_WIDTH			4U
#define XHC_AXIQOS__RQOS2_RESETVALUE		0x0U
#define XHC_AXIQOS__RQOS1_L			7U
#define XHC_AXIQOS__RQOS1_R			4U
#define XHC_AXIQOS__RQOS1_WIDTH			4U
#define XHC_AXIQOS__RQOS1_RESETVALUE		0x0U
#define XHC_AXIQOS__RQOS0_L			3U
#define XHC_AXIQOS__RQOS0_R			0U
#define XHC_AXIQOS__RQOS0_WIDTH			4U
#define XHC_AXIQOS__RQOS0_RESETVALUE		0x0U
#define XHC_AXIQOS_WIDTH			32U
#define XHC_AXIQOS__WIDTH			32U
#define XHC_AXIQOS_ALL_L			31U
#define XHC_AXIQOS_ALL_R			0U
#define XHC_AXIQOS__ALL_L			31U
#define XHC_AXIQOS__ALL_R			0U
#define XHC_AXIQOS_DATAMASK			0xffffffffU
#define XHC_AXIQOS_RDWRMASK			0x00000000U
#define XHC_AXIQOS_RESETVALUE			0x00000000U

#define XHC_ECHCSR_OFFSET			0xc20U
#define XHC_ECHCSR_BASE				0xc20U
#define XHC_ECHCSR__CLK_L			31U
#define XHC_ECHCSR__CLK_R			21U
#define XHC_ECHCSR__CLK_WIDTH			11U
#define XHC_ECHCSR__CLK_RESETVALUE		0x0U
#define XHC_ECHCSR__reserved_L			20U
#define XHC_ECHCSR__reserved_R			19U
#define XHC_ECHCSR__reserved_WIDTH		2U
#define XHC_ECHCSR__reserved_RESETVALUE		0x0U
#define XHC_ECHCSR__WID_L			18U
#define XHC_ECHCSR__WID_R			16U
#define XHC_ECHCSR__WID_WIDTH			3U
#define XHC_ECHCSR__WID_RESETVALUE		0x0U
#define XHC_ECHCSR__NCP_L			15U
#define XHC_ECHCSR__NCP_R			8U
#define XHC_ECHCSR__NCP_WIDTH			8U
#define XHC_ECHCSR__NCP_RESETVALUE		0x04U
#define XHC_ECHCSR__CID_L			7U
#define XHC_ECHCSR__CID_R			0U
#define XHC_ECHCSR__CID_WIDTH			8U
#define XHC_ECHCSR__CID_RESETVALUE		0xc1U
#define XHC_ECHCSR_WIDTH			32U
#define XHC_ECHCSR__WIDTH			32U
#define XHC_ECHCSR_ALL_L			31U
#define XHC_ECHCSR_ALL_R			0U
#define XHC_ECHCSR__ALL_L			31U
#define XHC_ECHCSR__ALL_R			0U
#define XHC_ECHCSR_DATAMASK			0xffffffffU
#define XHC_ECHCSR_RDWRMASK			0x00000000U
#define XHC_ECHCSR_RESETVALUE			0x000004c1U

#define XHC_CSRSPC_OFFSET			0xc24U
#define XHC_CSRSPC_BASE				0xc24U
#define XHC_CSRSPC__MAJ_L			31U
#define XHC_CSRSPC__MAJ_R			28U
#define XHC_CSRSPC__MAJ_WIDTH			4U
#define XHC_CSRSPC__MAJ_RESETVALUE		0x0U
#define XHC_CSRSPC__MIN_L			27U
#define XHC_CSRSPC__MIN_R			24U
#define XHC_CSRSPC__MIN_WIDTH			4U
#define XHC_CSRSPC__MIN_RESETVALUE		0x0U
#define XHC_CSRSPC__RLS_L			23U
#define XHC_CSRSPC__RLS_R			20U
#define XHC_CSRSPC__RLS_WIDTH			4U
#define XHC_CSRSPC__RLS_RESETVALUE		0x0U
#define XHC_CSRSPC__reserved_L			19U
#define XHC_CSRSPC__reserved_R			3U
#define XHC_CSRSPC__reserved_WIDTH		17U
#define XHC_CSRSPC__reserved_RESETVALUE		0x0U
#define XHC_CSRSPC__ASP				2U
#define XHC_CSRSPC__ASP_L			2U
#define XHC_CSRSPC__ASP_R			2U
#define XHC_CSRSPC__ASP_WIDTH			1U
#define XHC_CSRSPC__ASP_RESETVALUE		0x0U
#define XHC_CSRSPC__TYP_L			1U
#define XHC_CSRSPC__TYP_R			0U
#define XHC_CSRSPC__TYP_WIDTH			2U
#define XHC_CSRSPC__TYP_RESETVALUE		0x0U
#define XHC_CSRSPC_WIDTH			32U
#define XHC_CSRSPC__WIDTH			32U
#define XHC_CSRSPC_ALL_L			31U
#define XHC_CSRSPC_ALL_R			0U
#define XHC_CSRSPC__ALL_L			31U
#define XHC_CSRSPC__ALL_R			0U
#define XHC_CSRSPC_DATAMASK			0xffffffffU
#define XHC_CSRSPC_RDWRMASK			0x00000000U
#define XHC_CSRSPC_RESETVALUE			0x00000000U

#define XHC_ECHAIU_OFFSET			0xc30U
#define XHC_ECHAIU_BASE				0xc30U
#define XHC_ECHAIU__DMA_L			31U
#define XHC_ECHAIU__DMA_R			30U
#define XHC_ECHAIU__DMA_WIDTH			2U
#define XHC_ECHAIU__DMA_RESETVALUE		0x1U
#define XHC_ECHAIU__PBRS_L			29U
#define XHC_ECHAIU__PBRS_R			28U
#define XHC_ECHAIU__PBRS_WIDTH			2U
#define XHC_ECHAIU__PBRS_RESETVALUE		0x0U
#define XHC_ECHAIU__PBR2_L			27U
#define XHC_ECHAIU__PBR2_R			26U
#define XHC_ECHAIU__PBR2_WIDTH			2U
#define XHC_ECHAIU__PBR2_RESETVALUE		0x0U
#define XHC_ECHAIU__SCHS_L			25U
#define XHC_ECHAIU__SCHS_R			24U
#define XHC_ECHAIU__SCHS_WIDTH			2U
#define XHC_ECHAIU__SCHS_RESETVALUE		0x0U
#define XHC_ECHAIU__SCH2_L			23U
#define XHC_ECHAIU__SCH2_R			22U
#define XHC_ECHAIU__SCH2_WIDTH			2U
#define XHC_ECHAIU__SCH2_RESETVALUE		0x0U
#define XHC_ECHAIU__CHMS_L			21U
#define XHC_ECHAIU__CHMS_R			20U
#define XHC_ECHAIU__CHMS_WIDTH			2U
#define XHC_ECHAIU__CHMS_RESETVALUE		0x3U
#define XHC_ECHAIU__CHM2_L			19U
#define XHC_ECHAIU__CHM2_R			18U
#define XHC_ECHAIU__CHM2_WIDTH			2U
#define XHC_ECHAIU__CHM2_RESETVALUE		0x0U
#define XHC_ECHAIU__reserved_L			17U
#define XHC_ECHAIU__reserved_R			16U
#define XHC_ECHAIU__reserved_WIDTH		2U
#define XHC_ECHAIU__reserved_RESETVALUE		0x0U
#define XHC_ECHAIU__NCP_L			15U
#define XHC_ECHAIU__NCP_R			8U
#define XHC_ECHAIU__NCP_WIDTH			8U
#define XHC_ECHAIU__NCP_RESETVALUE		0x04U
#define XHC_ECHAIU__CID_L			7U
#define XHC_ECHAIU__CID_R			0U
#define XHC_ECHAIU__CID_WIDTH			8U
#define XHC_ECHAIU__CID_RESETVALUE		0xc2U
#define XHC_ECHAIU_WIDTH			32U
#define XHC_ECHAIU__WIDTH			32U
#define XHC_ECHAIU_ALL_L			31U
#define XHC_ECHAIU_ALL_R			0U
#define XHC_ECHAIU__ALL_L			31U
#define XHC_ECHAIU__ALL_R			0U
#define XHC_ECHAIU_DATAMASK			0xffffffffU
#define XHC_ECHAIU_RDWRMASK			0x00000000U
#define XHC_ECHAIU_RESETVALUE			0x403004c2U

#define XHC_AIUDMA_OFFSET			0xc34U
#define XHC_AIUDMA_BASE				0xc34U
#define XHC_AIUDMA__WRMB_L			31U
#define XHC_AIUDMA__WRMB_R			28U
#define XHC_AIUDMA__WRMB_WIDTH			4U
#define XHC_AIUDMA__WRMB_RESETVALUE		0x0U
#define XHC_AIUDMA__WRD_L			27U
#define XHC_AIUDMA__WRD_R			26U
#define XHC_AIUDMA__WRD_WIDTH			2U
#define XHC_AIUDMA__WRD_RESETVALUE		0x0U
#define XHC_AIUDMA__WED_L			25U
#define XHC_AIUDMA__WED_R			24U
#define XHC_AIUDMA__WED_WIDTH			2U
#define XHC_AIUDMA__WED_RESETVALUE		0x0U
#define XHC_AIUDMA__WMS_L			23U
#define XHC_AIUDMA__WMS_R			22U
#define XHC_AIUDMA__WMS_WIDTH			2U
#define XHC_AIUDMA__WMS_RESETVALUE		0x0U
#define XHC_AIUDMA__WMI_L			21U
#define XHC_AIUDMA__WMI_R			20U
#define XHC_AIUDMA__WMI_WIDTH			2U
#define XHC_AIUDMA__WMI_RESETVALUE		0x0U
#define XHC_AIUDMA__WPF_L			19U
#define XHC_AIUDMA__WPF_R			16U
#define XHC_AIUDMA__WPF_WIDTH			4U
#define XHC_AIUDMA__WPF_RESETVALUE		0x6U
#define XHC_AIUDMA__RRMB_L			15U
#define XHC_AIUDMA__RRMB_R			12U
#define XHC_AIUDMA__RRMB_WIDTH			4U
#define XHC_AIUDMA__RRMB_RESETVALUE		0x0U
#define XHC_AIUDMA__RTD_L			11U
#define XHC_AIUDMA__RTD_R			10U
#define XHC_AIUDMA__RTD_WIDTH			2U
#define XHC_AIUDMA__RTD_RESETVALUE		0x0U
#define XHC_AIUDMA__RTF_L			9U
#define XHC_AIUDMA__RTF_R			8U
#define XHC_AIUDMA__RTF_WIDTH			2U
#define XHC_AIUDMA__RTF_RESETVALUE		0x0U
#define XHC_AIUDMA__RM_S_L			7U
#define XHC_AIUDMA__RM_S_R			6U
#define XHC_AIUDMA__RM_S_WIDTH			2U
#define XHC_AIUDMA__RM_S_RESETVALUE		0x0U
#define XHC_AIUDMA__TFBS_L			5U
#define XHC_AIUDMA__TFBS_R			3U
#define XHC_AIUDMA__TFBS_WIDTH			3U
#define XHC_AIUDMA__TFBS_RESETVALUE		0x0U
#define XHC_AIUDMA__reserved_L			2U
#define XHC_AIUDMA__reserved_R			0U
#define XHC_AIUDMA__reserved_WIDTH		3U
#define XHC_AIUDMA__reserved_RESETVALUE		0x0U
#define XHC_AIUDMA_WIDTH			32U
#define XHC_AIUDMA__WIDTH			32U
#define XHC_AIUDMA_ALL_L			31U
#define XHC_AIUDMA_ALL_R			0U
#define XHC_AIUDMA__ALL_L			31U
#define XHC_AIUDMA__ALL_R			0U
#define XHC_AIUDMA_DATAMASK			0xffffffffU
#define XHC_AIUDMA_RDWRMASK			0x00000000U
#define XHC_AIUDMA_RESETVALUE			0x00060000U

#define XHC_AIUFLA_OFFSET			0xc38U
#define XHC_AIUFLA_BASE				0xc38U
#define XHC_AIUFLA__ACLK_L			31U
#define XHC_AIUFLA__ACLK_R			23U
#define XHC_AIUFLA__ACLK_WIDTH			9U
#define XHC_AIUFLA__ACLK_RESETVALUE		0x0U
#define XHC_AIUFLA__MFLV_L			22U
#define XHC_AIUFLA__MFLV_R			7U
#define XHC_AIUFLA__MFLV_WIDTH			16U
#define XHC_AIUFLA__MFLV_RESETVALUE		0x0000U
#define XHC_AIUFLA__NFC				6U
#define XHC_AIUFLA__NFC_L			6U
#define XHC_AIUFLA__NFC_R			6U
#define XHC_AIUFLA__NFC_WIDTH			1U
#define XHC_AIUFLA__NFC_RESETVALUE		0x1U
#define XHC_AIUFLA__FLADJ_L			5U
#define XHC_AIUFLA__FLADJ_R			0U
#define XHC_AIUFLA__FLADJ_WIDTH			6U
#define XHC_AIUFLA__FLADJ_RESETVALUE		0x20U
#define XHC_AIUFLA_WIDTH			32U
#define XHC_AIUFLA__WIDTH			32U
#define XHC_AIUFLA_ALL_L			31U
#define XHC_AIUFLA_ALL_R			0U
#define XHC_AIUFLA__ALL_L			31U
#define XHC_AIUFLA__ALL_R			0U
#define XHC_AIUFLA_DATAMASK			0xffffffffU
#define XHC_AIUFLA_RDWRMASK			0x00000000U
#define XHC_AIUFLA_RESETVALUE			0x00000060U

#define XHC_AIUCFG_OFFSET			0xc3cU
#define XHC_AIUCFG_BASE				0xc3cU
#define XHC_AIUCFG__ISO_L			30U
#define XHC_AIUCFG__ISO_R			28U
#define XHC_AIUCFG__ISO_WIDTH			3U
#define XHC_AIUCFG__ISO_RESETVALUE		0x0U
#define XHC_AIUCFG__EPC_L			26U
#define XHC_AIUCFG__EPC_R			24U
#define XHC_AIUCFG__EPC_WIDTH			3U
#define XHC_AIUCFG__EPC_RESETVALUE		0x5U
#define XHC_AIUCFG__PTQ_L			22U
#define XHC_AIUCFG__PTQ_R			20U
#define XHC_AIUCFG__PTQ_WIDTH			3U
#define XHC_AIUCFG__PTQ_RESETVALUE		0x3U
#define XHC_AIUCFG__NTQ_L			18U
#define XHC_AIUCFG__NTQ_R			16U
#define XHC_AIUCFG__NTQ_WIDTH			3U
#define XHC_AIUCFG__NTQ_RESETVALUE		0x3U
#define XHC_AIUCFG__HID				15U
#define XHC_AIUCFG__HID_L			15U
#define XHC_AIUCFG__HID_R			15U
#define XHC_AIUCFG__HID_WIDTH			1U
#define XHC_AIUCFG__HID_RESETVALUE		0x0U
#define XHC_AIUCFG__EPS_L			14U
#define XHC_AIUCFG__EPS_R			12U
#define XHC_AIUCFG__EPS_WIDTH			3U
#define XHC_AIUCFG__EPS_RESETVALUE		0x0U
#define XHC_AIUCFG__reserved_L			11U
#define XHC_AIUCFG__reserved_R			9U
#define XHC_AIUCFG__reserved_WIDTH		3U
#define XHC_AIUCFG__reserved_RESETVALUE		0x0U
#define XHC_AIUCFG__PEP2_L			8U
#define XHC_AIUCFG__PEP2_R			6U
#define XHC_AIUCFG__PEP2_WIDTH			3U
#define XHC_AIUCFG__PEP2_RESETVALUE		0x4U
#define XHC_AIUCFG__MELADJ_L			5U
#define XHC_AIUCFG__MELADJ_R			0U
#define XHC_AIUCFG__MELADJ_WIDTH		6U
#define XHC_AIUCFG__MELADJ_RESETVALUE		0x0U
#define XHC_AIUCFG__RESERVED_0			31U
#define XHC_AIUCFG__RESERVED_0_L		31U
#define XHC_AIUCFG__RESERVED_0_R		31U
#define XHC_AIUCFG__RESERVED_1			27U
#define XHC_AIUCFG__RESERVED_1_L		27U
#define XHC_AIUCFG__RESERVED_1_R		27U
#define XHC_AIUCFG__RESERVED_2			23U
#define XHC_AIUCFG__RESERVED_2_L		23U
#define XHC_AIUCFG__RESERVED_2_R		23U
#define XHC_AIUCFG__RESERVED_3			19U
#define XHC_AIUCFG__RESERVED_3_L		19U
#define XHC_AIUCFG__RESERVED_3_R		19U
#define XHC_AIUCFG_WIDTH			31U
#define XHC_AIUCFG__WIDTH			31U
#define XHC_AIUCFG_ALL_L			30U
#define XHC_AIUCFG_ALL_R			0U
#define XHC_AIUCFG__ALL_L			30U
#define XHC_AIUCFG__ALL_R			0U
#define XHC_AIUCFG_DATAMASK			0x7777ffffU
#define XHC_AIUCFG_RDWRMASK			0x88880000U
#define XHC_AIUCFG_RESETVALUE			0x05330100U

#define XHC_ECHFSC_OFFSET			0xc40U
#define XHC_ECHFSC_BASE				0xc40U
#define XHC_ECHFSC__reserved_L			31U
#define XHC_ECHFSC__reserved_R			24U
#define XHC_ECHFSC__reserved_WIDTH		8U
#define XHC_ECHFSC__reserved_RESETVALUE		0x00U
#define XHC_ECHFSC__WRMB_L			23U
#define XHC_ECHFSC__WRMB_R			20U
#define XHC_ECHFSC__WRMB_WIDTH			4U
#define XHC_ECHFSC__WRMB_RESETVALUE		0x0U
#define XHC_ECHFSC__RRMB_L			19U
#define XHC_ECHFSC__RRMB_R			16U
#define XHC_ECHFSC__RRMB_WIDTH			4U
#define XHC_ECHFSC__RRMB_RESETVALUE		0x0U
#define XHC_ECHFSC__NCP_L			15U
#define XHC_ECHFSC__NCP_R			8U
#define XHC_ECHFSC__NCP_WIDTH			8U
#define XHC_ECHFSC__NCP_RESETVALUE		0x50U
#define XHC_ECHFSC__CID_L			7U
#define XHC_ECHFSC__CID_R			0U
#define XHC_ECHFSC__CID_WIDTH			8U
#define XHC_ECHFSC__CID_RESETVALUE		0xc3U
#define XHC_ECHFSC_WIDTH			32U
#define XHC_ECHFSC__WIDTH			32U
#define XHC_ECHFSC_ALL_L			31U
#define XHC_ECHFSC_ALL_R			0U
#define XHC_ECHFSC__ALL_L			31U
#define XHC_ECHFSC__ALL_R			0U
#define XHC_ECHFSC_DATAMASK			0xffffffffU
#define XHC_ECHFSC_RDWRMASK			0x00000000U
#define XHC_ECHFSC_RESETVALUE			0x000050c3U

#define XHC_FSCPOC_OFFSET			0xc54U
#define XHC_FSCPOC_BASE				0xc54U
#define XHC_FSCPOC__NCS_L			31U
#define XHC_FSCPOC__NCS_R			28U
#define XHC_FSCPOC__NCS_WIDTH			4U
#define XHC_FSCPOC__NCS_RESETVALUE		0x0U
#define XHC_FSCPOC__FSIZ_L			22U
#define XHC_FSCPOC__FSIZ_R			18U
#define XHC_FSCPOC__FSIZ_WIDTH			5U
#define XHC_FSCPOC__FSIZ_RESETVALUE		0x0U
#define XHC_FSCPOC__PSIZ_L			16U
#define XHC_FSCPOC__PSIZ_R			12U
#define XHC_FSCPOC__PSIZ_WIDTH			5U
#define XHC_FSCPOC__PSIZ_RESETVALUE		0x0U
#define XHC_FSCPOC__reserved_L			11U
#define XHC_FSCPOC__reserved_R			5U
#define XHC_FSCPOC__reserved_WIDTH		7U
#define XHC_FSCPOC__reserved_RESETVALUE		0x0U
#define XHC_FSCPOC__TSIZ_L			4U
#define XHC_FSCPOC__TSIZ_R			0U
#define XHC_FSCPOC__TSIZ_WIDTH			5U
#define XHC_FSCPOC__TSIZ_RESETVALUE		0x0U
#define XHC_FSCPOC__RESERVED_L			27U
#define XHC_FSCPOC__RESERVED_R			23U
#define XHC_FSCPOC_WIDTH			32U
#define XHC_FSCPOC__WIDTH			32U
#define XHC_FSCPOC_ALL_L			31U
#define XHC_FSCPOC_ALL_R			0U
#define XHC_FSCPOC__ALL_L			31U
#define XHC_FSCPOC__ALL_R			0U
#define XHC_FSCPOC_DATAMASK			0xf07dffffU
#define XHC_FSCPOC_RDWRMASK			0x0f820000U
#define XHC_FSCPOC_RESETVALUE			0x00000000U

#define XHC_FSCGOC_OFFSET			0xc58U
#define XHC_FSCGOC_BASE				0xc58U
#define XHC_FSCGOC__NCS_L			31U
#define XHC_FSCGOC__NCS_R			28U
#define XHC_FSCGOC__NCS_WIDTH			4U
#define XHC_FSCGOC__NCS_RESETVALUE		0x0U
#define XHC_FSCGOC__FSIZ_L			22U
#define XHC_FSCGOC__FSIZ_R			18U
#define XHC_FSCGOC__FSIZ_WIDTH			5U
#define XHC_FSCGOC__FSIZ_RESETVALUE		0x0U
#define XHC_FSCGOC__PSIZ_L			16U
#define XHC_FSCGOC__PSIZ_R			12U
#define XHC_FSCGOC__PSIZ_WIDTH			5U
#define XHC_FSCGOC__PSIZ_RESETVALUE		0x0U
#define XHC_FSCGOC__reserved_L			11U
#define XHC_FSCGOC__reserved_R			5U
#define XHC_FSCGOC__reserved_WIDTH		7U
#define XHC_FSCGOC__reserved_RESETVALUE		0x0U
#define XHC_FSCGOC__TSIZ_L			4U
#define XHC_FSCGOC__TSIZ_R			0U
#define XHC_FSCGOC__TSIZ_WIDTH			5U
#define XHC_FSCGOC__TSIZ_RESETVALUE		0x0U
#define XHC_FSCGOC__RESERVED_L			27U
#define XHC_FSCGOC__RESERVED_R			23U
#define XHC_FSCGOC_WIDTH			32U
#define XHC_FSCGOC__WIDTH			32U
#define XHC_FSCGOC_ALL_L			31U
#define XHC_FSCGOC_ALL_R			0U
#define XHC_FSCGOC__ALL_L			31U
#define XHC_FSCGOC__ALL_R			0U
#define XHC_FSCGOC_DATAMASK			0xf07dffffU
#define XHC_FSCGOC_RDWRMASK			0x0f820000U
#define XHC_FSCGOC_RESETVALUE			0x00000000U

#define XHC_FSCNOC_OFFSET			0xc5cU
#define XHC_FSCNOC_BASE				0xc5cU
#define XHC_FSCNOC__NCS_L			31U
#define XHC_FSCNOC__NCS_R			28U
#define XHC_FSCNOC__NCS_WIDTH			4U
#define XHC_FSCNOC__NCS_RESETVALUE		0x0U
#define XHC_FSCNOC__FSIZ_L			22U
#define XHC_FSCNOC__FSIZ_R			18U
#define XHC_FSCNOC__FSIZ_WIDTH			5U
#define XHC_FSCNOC__FSIZ_RESETVALUE		0x0U
#define XHC_FSCNOC__PSIZ_L			16U
#define XHC_FSCNOC__PSIZ_R			12U
#define XHC_FSCNOC__PSIZ_WIDTH			5U
#define XHC_FSCNOC__PSIZ_RESETVALUE		0x0U
#define XHC_FSCNOC__reserved_L			11U
#define XHC_FSCNOC__reserved_R			5U
#define XHC_FSCNOC__reserved_WIDTH		7U
#define XHC_FSCNOC__reserved_RESETVALUE		0x0U
#define XHC_FSCNOC__TSIZ_L			4U
#define XHC_FSCNOC__TSIZ_R			0U
#define XHC_FSCNOC__TSIZ_WIDTH			5U
#define XHC_FSCNOC__TSIZ_RESETVALUE		0x0U
#define XHC_FSCNOC__RESERVED_L			27U
#define XHC_FSCNOC__RESERVED_R			23U
#define XHC_FSCNOC_WIDTH			32U
#define XHC_FSCNOC__WIDTH			32U
#define XHC_FSCNOC_ALL_L			31U
#define XHC_FSCNOC_ALL_R			0U
#define XHC_FSCNOC__ALL_L			31U
#define XHC_FSCNOC__ALL_R			0U
#define XHC_FSCNOC_DATAMASK			0xf07dffffU
#define XHC_FSCNOC_RDWRMASK			0x0f820000U
#define XHC_FSCNOC_RESETVALUE			0x00000000U

#define XHC_FSCAIC_OFFSET			0xc60U
#define XHC_FSCAIC_BASE				0xc60U
#define XHC_FSCAIC__FSIZ_L			22U
#define XHC_FSCAIC__FSIZ_R			18U
#define XHC_FSCAIC__FSIZ_WIDTH			5U
#define XHC_FSCAIC__FSIZ_RESETVALUE		0x0U
#define XHC_FSCAIC__PSIZ_L			16U
#define XHC_FSCAIC__PSIZ_R			12U
#define XHC_FSCAIC__PSIZ_WIDTH			5U
#define XHC_FSCAIC__PSIZ_RESETVALUE		0x0U
#define XHC_FSCAIC__reserved_L			11U
#define XHC_FSCAIC__reserved_R			0U
#define XHC_FSCAIC__reserved_WIDTH		12U
#define XHC_FSCAIC__reserved_RESETVALUE		0x000U
#define XHC_FSCAIC__RESERVED_L			31U
#define XHC_FSCAIC__RESERVED_R			23U
#define XHC_FSCAIC_WIDTH			23U
#define XHC_FSCAIC__WIDTH			23U
#define XHC_FSCAIC_ALL_L			22U
#define XHC_FSCAIC_ALL_R			0U
#define XHC_FSCAIC__ALL_L			22U
#define XHC_FSCAIC__ALL_R			0U
#define XHC_FSCAIC_DATAMASK			0x007dffffU
#define XHC_FSCAIC_RDWRMASK			0xff820000U
#define XHC_FSCAIC_RESETVALUE			0x000000U

#define XHC_FSCPIC_OFFSET			0xc64U
#define XHC_FSCPIC_BASE				0xc64U
#define XHC_FSCPIC__NCS_L			31U
#define XHC_FSCPIC__NCS_R			28U
#define XHC_FSCPIC__NCS_WIDTH			4U
#define XHC_FSCPIC__NCS_RESETVALUE		0x0U
#define XHC_FSCPIC__reserved_L			27U
#define XHC_FSCPIC__reserved_R			5U
#define XHC_FSCPIC__reserved_WIDTH		23U
#define XHC_FSCPIC__reserved_RESETVALUE		0x0U
#define XHC_FSCPIC__TSIZ_L			4U
#define XHC_FSCPIC__TSIZ_R			0U
#define XHC_FSCPIC__TSIZ_WIDTH			5U
#define XHC_FSCPIC__TSIZ_RESETVALUE		0x0U
#define XHC_FSCPIC_WIDTH			32U
#define XHC_FSCPIC__WIDTH			32U
#define XHC_FSCPIC_ALL_L			31U
#define XHC_FSCPIC_ALL_R			0U
#define XHC_FSCPIC__ALL_L			31U
#define XHC_FSCPIC__ALL_R			0U
#define XHC_FSCPIC_DATAMASK			0xffffffffU
#define XHC_FSCPIC_RDWRMASK			0x00000000U
#define XHC_FSCPIC_RESETVALUE			0x00000000U

#define XHC_FSCGIC_OFFSET			0xc68U
#define XHC_FSCGIC_BASE				0xc68U
#define XHC_FSCGIC__NCS_L			31U
#define XHC_FSCGIC__NCS_R			28U
#define XHC_FSCGIC__NCS_WIDTH			4U
#define XHC_FSCGIC__NCS_RESETVALUE		0x0U
#define XHC_FSCGIC__reserved_L			27U
#define XHC_FSCGIC__reserved_R			5U
#define XHC_FSCGIC__reserved_WIDTH		23U
#define XHC_FSCGIC__reserved_RESETVALUE		0x0U
#define XHC_FSCGIC__TSIZ_L			4U
#define XHC_FSCGIC__TSIZ_R			0U
#define XHC_FSCGIC__TSIZ_WIDTH			5U
#define XHC_FSCGIC__TSIZ_RESETVALUE		0x0U
#define XHC_FSCGIC_WIDTH			32U
#define XHC_FSCGIC__WIDTH			32U
#define XHC_FSCGIC_ALL_L			31U
#define XHC_FSCGIC_ALL_R			0U
#define XHC_FSCGIC__ALL_L			31U
#define XHC_FSCGIC__ALL_R			0U
#define XHC_FSCGIC_DATAMASK			0xffffffffU
#define XHC_FSCGIC_RDWRMASK			0x00000000U
#define XHC_FSCGIC_RESETVALUE			0x00000000U

#define XHC_FSCNIC_OFFSET			0xc6cU
#define XHC_FSCNIC_BASE				0xc6cU
#define XHC_FSCNIC__NCS_L			31U
#define XHC_FSCNIC__NCS_R			28U
#define XHC_FSCNIC__NCS_WIDTH			4U
#define XHC_FSCNIC__NCS_RESETVALUE		0x0U
#define XHC_FSCNIC__reserved_L			27U
#define XHC_FSCNIC__reserved_R			5U
#define XHC_FSCNIC__reserved_WIDTH		23U
#define XHC_FSCNIC__reserved_RESETVALUE		0x0U
#define XHC_FSCNIC__TSIZ_L			4U
#define XHC_FSCNIC__TSIZ_R			0U
#define XHC_FSCNIC__TSIZ_WIDTH			5U
#define XHC_FSCNIC__TSIZ_RESETVALUE		0x0U
#define XHC_FSCNIC_WIDTH			32U
#define XHC_FSCNIC__WIDTH			32U
#define XHC_FSCNIC_ALL_L			31U
#define XHC_FSCNIC_ALL_R			0U
#define XHC_FSCNIC__ALL_L			31U
#define XHC_FSCNIC__ALL_R			0U
#define XHC_FSCNIC_DATAMASK			0xffffffffU
#define XHC_FSCNIC_RDWRMASK			0x00000000U
#define XHC_FSCNIC_RESETVALUE			0x00000000U

#define XHC_ECHPRT_OFFSET			0xc70U
#define XHC_ECHPRT_BASE				0xc70U
#define XHC_ECHPRT__TDP				31U
#define XHC_ECHPRT__TDP_L			31U
#define XHC_ECHPRT__TDP_R			31U
#define XHC_ECHPRT__TDP_WIDTH			1U
#define XHC_ECHPRT__TDP_RESETVALUE		0x0U
#define XHC_ECHPRT__RDP				30U
#define XHC_ECHPRT__RDP_L			30U
#define XHC_ECHPRT__RDP_R			30U
#define XHC_ECHPRT__RDP_WIDTH			1U
#define XHC_ECHPRT__RDP_RESETVALUE		0x0U
#define XHC_ECHPRT__reserved_L			29U
#define XHC_ECHPRT__reserved_R			25U
#define XHC_ECHPRT__reserved_WIDTH		5U
#define XHC_ECHPRT__reserved_RESETVALUE		0x0U
#define XHC_ECHPRT__MFT_L			24U
#define XHC_ECHPRT__MFT_R			17U
#define XHC_ECHPRT__MFT_WIDTH			8U
#define XHC_ECHPRT__MFT_RESETVALUE		0x7dU
#define XHC_ECHPRT__HST				16U
#define XHC_ECHPRT__HST_L			16U
#define XHC_ECHPRT__HST_R			16U
#define XHC_ECHPRT__HST_WIDTH			1U
#define XHC_ECHPRT__HST_RESETVALUE		0x0U
#define XHC_ECHPRT__NCP_L			15U
#define XHC_ECHPRT__NCP_R			8U
#define XHC_ECHPRT__NCP_WIDTH			8U
#define XHC_ECHPRT__NCP_RESETVALUE		0x04U
#define XHC_ECHPRT__CID_L			7U
#define XHC_ECHPRT__CID_R			0U
#define XHC_ECHPRT__CID_WIDTH			8U
#define XHC_ECHPRT__CID_RESETVALUE		0xc4U
#define XHC_ECHPRT_WIDTH			32U
#define XHC_ECHPRT__WIDTH			32U
#define XHC_ECHPRT_ALL_L			31U
#define XHC_ECHPRT_ALL_R			0U
#define XHC_ECHPRT__ALL_L			31U
#define XHC_ECHPRT__ALL_R			0U
#define XHC_ECHPRT_DATAMASK			0xffffffffU
#define XHC_ECHPRT_RDWRMASK			0x00000000U
#define XHC_ECHPRT_RESETVALUE			0x00fa04c4U

#define XHC_PRTHSC_OFFSET			0xc78U
#define XHC_PRTHSC_BASE				0xc78U
#define XHC_PRTHSC__TMR_L			31U
#define XHC_PRTHSC__TMR_R			16U
#define XHC_PRTHSC__TMR_WIDTH			16U
#define XHC_PRTHSC__TMR_RESETVALUE		0x0000U
#define XHC_PRTHSC__RSL_L			7U
#define XHC_PRTHSC__RSL_R			6U
#define XHC_PRTHSC__RSL_WIDTH			2U
#define XHC_PRTHSC__RSL_RESETVALUE		0x0U
#define XHC_PRTHSC__AS_M_L			5U
#define XHC_PRTHSC__AS_M_R			4U
#define XHC_PRTHSC__AS_M_WIDTH			2U
#define XHC_PRTHSC__AS_M_RESETVALUE		0x0U
#define XHC_PRTHSC__CMD_L			3U
#define XHC_PRTHSC__CMD_R			2U
#define XHC_PRTHSC__CMD_WIDTH			2U
#define XHC_PRTHSC__CMD_RESETVALUE		0x0U
#define XHC_PRTHSC__reserved			1U
#define XHC_PRTHSC__reserved_L			1U
#define XHC_PRTHSC__reserved_R			1U
#define XHC_PRTHSC__reserved_WIDTH		1U
#define XHC_PRTHSC__reserved_RESETVALUE		0x0U
#define XHC_PRTHSC__STB				0U
#define XHC_PRTHSC__STB_L			0U
#define XHC_PRTHSC__STB_R			0U
#define XHC_PRTHSC__STB_WIDTH			1U
#define XHC_PRTHSC__STB_RESETVALUE		0x0U
#define XHC_PRTHSC__RESERVED_L			15U
#define XHC_PRTHSC__RESERVED_R			8U
#define XHC_PRTHSC_WIDTH			32U
#define XHC_PRTHSC__WIDTH			32U
#define XHC_PRTHSC_ALL_L			31U
#define XHC_PRTHSC_ALL_R			0U
#define XHC_PRTHSC__ALL_L			31U
#define XHC_PRTHSC__ALL_R			0U
#define XHC_PRTHSC_DATAMASK			0xffff00ffU
#define XHC_PRTHSC_RDWRMASK			0x0000ff00U
#define XHC_PRTHSC_RESETVALUE			0x00000000U

#define XHC_PRTHSR_OFFSET			0xc7cU
#define XHC_PRTHSR_BASE				0xc7cU
#define XHC_PRTHSR__RDLY_L			31U
#define XHC_PRTHSR__RDLY_R			24U
#define XHC_PRTHSR__RDLY_WIDTH			8U
#define XHC_PRTHSR__RDLY_RESETVALUE		0x00U
#define XHC_PRTHSR__TDPP_L			23U
#define XHC_PRTHSR__TDPP_R			16U
#define XHC_PRTHSR__TDPP_WIDTH			8U
#define XHC_PRTHSR__TDPP_RESETVALUE		0x00U
#define XHC_PRTHSR__RDPP_L			15U
#define XHC_PRTHSR__RDPP_R			8U
#define XHC_PRTHSR__RDPP_WIDTH			8U
#define XHC_PRTHSR__RDPP_RESETVALUE		0x00U
#define XHC_PRTHSR__TRTY_L			7U
#define XHC_PRTHSR__TRTY_R			0U
#define XHC_PRTHSR__TRTY_WIDTH			8U
#define XHC_PRTHSR__TRTY_RESETVALUE		0x00U
#define XHC_PRTHSR_WIDTH			32U
#define XHC_PRTHSR__WIDTH			32U
#define XHC_PRTHSR_ALL_L			31U
#define XHC_PRTHSR_ALL_R			0U
#define XHC_PRTHSR__ALL_L			31U
#define XHC_PRTHSR__ALL_R			0U
#define XHC_PRTHSR_DATAMASK			0xffffffffU
#define XHC_PRTHSR_RDWRMASK			0x00000000U
#define XHC_PRTHSR_RESETVALUE			0x00000000U

#define XHC_ECHRHS_OFFSET			0xc80U
#define XHC_ECHRHS_BASE				0xc80U
#define XHC_ECHRHS__RPO_L			30U
#define XHC_ECHRHS__RPO_R			24U
#define XHC_ECHRHS__RPO_WIDTH			7U
#define XHC_ECHRHS__RPO_RESETVALUE		0x0U
#define XHC_ECHRHS__reserved_L			23U
#define XHC_ECHRHS__reserved_R			22U
#define XHC_ECHRHS__reserved_WIDTH		2U
#define XHC_ECHRHS__reserved_RESETVALUE		0x0U
#define XHC_ECHRHS__RPN_L			21U
#define XHC_ECHRHS__RPN_R			20U
#define XHC_ECHRHS__RPN_WIDTH			2U
#define XHC_ECHRHS__RPN_RESETVALUE		0x0U
#define XHC_ECHRHS__DNR_L			19U
#define XHC_ECHRHS__DNR_R			16U
#define XHC_ECHRHS__DNR_WIDTH			4U
#define XHC_ECHRHS__DNR_RESETVALUE		0x0U
#define XHC_ECHRHS__NCP_L			15U
#define XHC_ECHRHS__NCP_R			8U
#define XHC_ECHRHS__NCP_WIDTH			8U
#define XHC_ECHRHS__NCP_RESETVALUE		0x0cU
#define XHC_ECHRHS__CID_L			7U
#define XHC_ECHRHS__CID_R			0U
#define XHC_ECHRHS__CID_WIDTH			8U
#define XHC_ECHRHS__CID_RESETVALUE		0xc8U
#define XHC_ECHRHS__RESERVED			31U
#define XHC_ECHRHS__RESERVED_L			31U
#define XHC_ECHRHS__RESERVED_R			31U
#define XHC_ECHRHS_WIDTH			31U
#define XHC_ECHRHS__WIDTH			31U
#define XHC_ECHRHS_ALL_L			30U
#define XHC_ECHRHS_ALL_R			0U
#define XHC_ECHRHS__ALL_L			30U
#define XHC_ECHRHS__ALL_R			0U
#define XHC_ECHRHS_DATAMASK			0x7fffffffU
#define XHC_ECHRHS_RDWRMASK			0x80000000U
#define XHC_ECHRHS_RESETVALUE			0x00000cc8U

#define XHC_RHSDES_OFFSET			0xc84U
#define XHC_RHSDES_BASE				0xc84U
#define XHC_RHSDES__PIS3_L			31U
#define XHC_RHSDES__PIS3_R			30U
#define XHC_RHSDES__PIS3_WIDTH			2U
#define XHC_RHSDES__PIS3_RESETVALUE		0x0U
#define XHC_RHSDES__HIST3			24U
#define XHC_RHSDES__HIST3_L			24U
#define XHC_RHSDES__HIST3_R			24U
#define XHC_RHSDES__HIST3_WIDTH			1U
#define XHC_RHSDES__HIST3_RESETVALUE		0x0U
#define XHC_RHSDES__PIS2_L			23U
#define XHC_RHSDES__PIS2_R			22U
#define XHC_RHSDES__PIS2_WIDTH			2U
#define XHC_RHSDES__PIS2_RESETVALUE		0x0U
#define XHC_RHSDES__HIST2			16U
#define XHC_RHSDES__HIST2_L			16U
#define XHC_RHSDES__HIST2_R			16U
#define XHC_RHSDES__HIST2_WIDTH			1U
#define XHC_RHSDES__HIST2_RESETVALUE		0x0U
#define XHC_RHSDES__PIS1_L			15U
#define XHC_RHSDES__PIS1_R			14U
#define XHC_RHSDES__PIS1_WIDTH			2U
#define XHC_RHSDES__PIS1_RESETVALUE		0x0U
#define XHC_RHSDES__HIST1			8U
#define XHC_RHSDES__HIST1_L			8U
#define XHC_RHSDES__HIST1_R			8U
#define XHC_RHSDES__HIST1_WIDTH			1U
#define XHC_RHSDES__HIST1_RESETVALUE		0x0U
#define XHC_RHSDES__PIS0_L			7U
#define XHC_RHSDES__PIS0_R			6U
#define XHC_RHSDES__PIS0_WIDTH			2U
#define XHC_RHSDES__PIS0_RESETVALUE		0x0U
#define XHC_RHSDES__reserved_L			5U
#define XHC_RHSDES__reserved_R			1U
#define XHC_RHSDES__reserved_WIDTH		5U
#define XHC_RHSDES__reserved_RESETVALUE		0x0U
#define XHC_RHSDES__HIST0			0U
#define XHC_RHSDES__HIST0_L			0U
#define XHC_RHSDES__HIST0_R			0U
#define XHC_RHSDES__HIST0_WIDTH			1U
#define XHC_RHSDES__HIST0_RESETVALUE		0x0U
#define XHC_RHSDES__RESERVED_0_L		29U
#define XHC_RHSDES__RESERVED_0_R		25U
#define XHC_RHSDES__RESERVED_1_L		21U
#define XHC_RHSDES__RESERVED_1_R		17U
#define XHC_RHSDES__RESERVED_2_L		13U
#define XHC_RHSDES__RESERVED_2_R		9U
#define XHC_RHSDES__RESERVED_L			29U
#define XHC_RHSDES__RESERVED_R			25U
#define XHC_RHSDES_WIDTH			32U
#define XHC_RHSDES__WIDTH			32U
#define XHC_RHSDES_ALL_L			31U
#define XHC_RHSDES_ALL_R			0U
#define XHC_RHSDES__ALL_L			31U
#define XHC_RHSDES__ALL_R			0U
#define XHC_RHSDES_DATAMASK			0xc1c1c1ffU
#define XHC_RHSDES_RDWRMASK			0x3e3e3e00U
#define XHC_RHSDES_RESETVALUE			0x00000000U

#define XHC_RHSHSC0_OFFSET			0xc90U
#define XHC_RHSHSC0_BASE			0xc90U
#define XHC_RHSHSC0__TMR_L			31U
#define XHC_RHSHSC0__TMR_R			16U
#define XHC_RHSHSC0__TMR_WIDTH			16U
#define XHC_RHSHSC0__TMR_RESETVALUE		0x0000U
#define XHC_RHSHSC0__RSL_L			7U
#define XHC_RHSHSC0__RSL_R			6U
#define XHC_RHSHSC0__RSL_WIDTH			2U
#define XHC_RHSHSC0__RSL_RESETVALUE		0x0U
#define XHC_RHSHSC0__AS_M_L			5U
#define XHC_RHSHSC0__AS_M_R			4U
#define XHC_RHSHSC0__AS_M_WIDTH			2U
#define XHC_RHSHSC0__AS_M_RESETVALUE		0x0U
#define XHC_RHSHSC0__CMD_L			3U
#define XHC_RHSHSC0__CMD_R			2U
#define XHC_RHSHSC0__CMD_WIDTH			2U
#define XHC_RHSHSC0__CMD_RESETVALUE		0x0U
#define XHC_RHSHSC0__reserved			1U
#define XHC_RHSHSC0__reserved_L			1U
#define XHC_RHSHSC0__reserved_R			1U
#define XHC_RHSHSC0__reserved_WIDTH		1U
#define XHC_RHSHSC0__reserved_RESETVALUE	0x0U
#define XHC_RHSHSC0__STB			0U
#define XHC_RHSHSC0__STB_L			0U
#define XHC_RHSHSC0__STB_R			0U
#define XHC_RHSHSC0__STB_WIDTH			1U
#define XHC_RHSHSC0__STB_RESETVALUE		0x0U
#define XHC_RHSHSC0__RESERVED_L			15U
#define XHC_RHSHSC0__RESERVED_R			8U
#define XHC_RHSHSC0_WIDTH			32U
#define XHC_RHSHSC0__WIDTH			32U
#define XHC_RHSHSC0_ALL_L			31U
#define XHC_RHSHSC0_ALL_R			0U
#define XHC_RHSHSC0__ALL_L			31U
#define XHC_RHSHSC0__ALL_R			0U
#define XHC_RHSHSC0_DATAMASK			0xffff00ffU
#define XHC_RHSHSC0_RDWRMASK			0x0000ff00U
#define XHC_RHSHSC0_RESETVALUE			0x00000000U

#define XHC_RHSHSR0_OFFSET			0xc94U
#define XHC_RHSHSR0_BASE			0xc94U
#define XHC_RHSHSR0__C2U_L			31U
#define XHC_RHSHSR0__C2U_R			24U
#define XHC_RHSHSR0__C2U_WIDTH			8U
#define XHC_RHSHSR0__C2U_RESETVALUE		0x00U
#define XHC_RHSHSR0__C1U_L			23U
#define XHC_RHSHSR0__C1U_R			16U
#define XHC_RHSHSR0__C1U_WIDTH			8U
#define XHC_RHSHSR0__C1U_RESETVALUE		0x00U
#define XHC_RHSHSR0__RCV_L			15U
#define XHC_RHSHSR0__RCV_R			8U
#define XHC_RHSHSR0__RCV_WIDTH			8U
#define XHC_RHSHSR0__RCV_RESETVALUE		0x00U
#define XHC_RHSHSR0__RTY_L			7U
#define XHC_RHSHSR0__RTY_R			0U
#define XHC_RHSHSR0__RTY_WIDTH			8U
#define XHC_RHSHSR0__RTY_RESETVALUE		0x00U
#define XHC_RHSHSR0_WIDTH			32U
#define XHC_RHSHSR0__WIDTH			32U
#define XHC_RHSHSR0_ALL_L			31U
#define XHC_RHSHSR0_ALL_R			0U
#define XHC_RHSHSR0__ALL_L			31U
#define XHC_RHSHSR0__ALL_R			0U
#define XHC_RHSHSR0_DATAMASK			0xffffffffU
#define XHC_RHSHSR0_RDWRMASK			0x00000000U
#define XHC_RHSHSR0_RESETVALUE			0x00000000U

#define XHC_RHSHSC1_OFFSET			0xc98U
#define XHC_RHSHSC1_BASE			0xc98U
#define XHC_RHSHSC1__TMR_L			31U
#define XHC_RHSHSC1__TMR_R			16U
#define XHC_RHSHSC1__TMR_WIDTH			16U
#define XHC_RHSHSC1__TMR_RESETVALUE		0x0000U
#define XHC_RHSHSC1__RSL_L			7U
#define XHC_RHSHSC1__RSL_R			6U
#define XHC_RHSHSC1__RSL_WIDTH			2U
#define XHC_RHSHSC1__RSL_RESETVALUE		0x0U
#define XHC_RHSHSC1__AS_M_L			5U
#define XHC_RHSHSC1__AS_M_R			4U
#define XHC_RHSHSC1__AS_M_WIDTH			2U
#define XHC_RHSHSC1__AS_M_RESETVALUE		0x0U
#define XHC_RHSHSC1__CMD_L			3U
#define XHC_RHSHSC1__CMD_R			2U
#define XHC_RHSHSC1__CMD_WIDTH			2U
#define XHC_RHSHSC1__CMD_RESETVALUE		0x0U
#define XHC_RHSHSC1__reserved			1U
#define XHC_RHSHSC1__reserved_L			1U
#define XHC_RHSHSC1__reserved_R			1U
#define XHC_RHSHSC1__reserved_WIDTH		1U
#define XHC_RHSHSC1__reserved_RESETVALUE	0x0U
#define XHC_RHSHSC1__STB			0U
#define XHC_RHSHSC1__STB_L			0U
#define XHC_RHSHSC1__STB_R			0U
#define XHC_RHSHSC1__STB_WIDTH			1U
#define XHC_RHSHSC1__STB_RESETVALUE		0x0U
#define XHC_RHSHSC1__RESERVED_L			15U
#define XHC_RHSHSC1__RESERVED_R			8U
#define XHC_RHSHSC1_WIDTH			32U
#define XHC_RHSHSC1__WIDTH			32U
#define XHC_RHSHSC1_ALL_L			31U
#define XHC_RHSHSC1_ALL_R			0U
#define XHC_RHSHSC1__ALL_L			31U
#define XHC_RHSHSC1__ALL_R			0U
#define XHC_RHSHSC1_DATAMASK			0xffff00ffU
#define XHC_RHSHSC1_RDWRMASK			0x0000ff00U
#define XHC_RHSHSC1_RESETVALUE			0x00000000U

#define XHC_RHSHSR1_OFFSET			0xc9cU
#define XHC_RHSHSR1_BASE			0xc9cU
#define XHC_RHSHSR1__C2U_L			31U
#define XHC_RHSHSR1__C2U_R			24U
#define XHC_RHSHSR1__C2U_WIDTH			8U
#define XHC_RHSHSR1__C2U_RESETVALUE		0x00U
#define XHC_RHSHSR1__C1U_L			23U
#define XHC_RHSHSR1__C1U_R			16U
#define XHC_RHSHSR1__C1U_WIDTH			8U
#define XHC_RHSHSR1__C1U_RESETVALUE		0x00U
#define XHC_RHSHSR1__RCV_L			15U
#define XHC_RHSHSR1__RCV_R			8U
#define XHC_RHSHSR1__RCV_WIDTH			8U
#define XHC_RHSHSR1__RCV_RESETVALUE		0x00U
#define XHC_RHSHSR1__RTY_L			7U
#define XHC_RHSHSR1__RTY_R			0U
#define XHC_RHSHSR1__RTY_WIDTH			8U
#define XHC_RHSHSR1__RTY_RESETVALUE		0x00U
#define XHC_RHSHSR1_WIDTH			32U
#define XHC_RHSHSR1__WIDTH			32U
#define XHC_RHSHSR1_ALL_L			31U
#define XHC_RHSHSR1_ALL_R			0U
#define XHC_RHSHSR1__ALL_L			31U
#define XHC_RHSHSR1__ALL_R			0U
#define XHC_RHSHSR1_DATAMASK			0xffffffffU
#define XHC_RHSHSR1_RDWRMASK			0x00000000U
#define XHC_RHSHSR1_RESETVALUE			0x00000000U

#define XHC_RHSHSC2_OFFSET			0xca0U
#define XHC_RHSHSC2_BASE			0xca0U
#define XHC_RHSHSC2__TMR_L			31U
#define XHC_RHSHSC2__TMR_R			16U
#define XHC_RHSHSC2__TMR_WIDTH			16U
#define XHC_RHSHSC2__TMR_RESETVALUE		0x0000U
#define XHC_RHSHSC2__RSL_L			7U
#define XHC_RHSHSC2__RSL_R			6U
#define XHC_RHSHSC2__RSL_WIDTH			2U
#define XHC_RHSHSC2__RSL_RESETVALUE		0x0U
#define XHC_RHSHSC2__AS_M_L			5U
#define XHC_RHSHSC2__AS_M_R			4U
#define XHC_RHSHSC2__AS_M_WIDTH			2U
#define XHC_RHSHSC2__AS_M_RESETVALUE		0x0U
#define XHC_RHSHSC2__CMD_L			3U
#define XHC_RHSHSC2__CMD_R			2U
#define XHC_RHSHSC2__CMD_WIDTH			2U
#define XHC_RHSHSC2__CMD_RESETVALUE		0x0U
#define XHC_RHSHSC2__reserved			1U
#define XHC_RHSHSC2__reserved_L			1U
#define XHC_RHSHSC2__reserved_R			1U
#define XHC_RHSHSC2__reserved_WIDTH		1U
#define XHC_RHSHSC2__reserved_RESETVALUE	0x0U
#define XHC_RHSHSC2__STB			0U
#define XHC_RHSHSC2__STB_L			0U
#define XHC_RHSHSC2__STB_R			0U
#define XHC_RHSHSC2__STB_WIDTH			1U
#define XHC_RHSHSC2__STB_RESETVALUE		0x0U
#define XHC_RHSHSC2__RESERVED_L			15U
#define XHC_RHSHSC2__RESERVED_R			8U
#define XHC_RHSHSC2_WIDTH			32U
#define XHC_RHSHSC2__WIDTH			32U
#define XHC_RHSHSC2_ALL_L			31U
#define XHC_RHSHSC2_ALL_R			0U
#define XHC_RHSHSC2__ALL_L			31U
#define XHC_RHSHSC2__ALL_R			0U
#define XHC_RHSHSC2_DATAMASK			0xffff00ffU
#define XHC_RHSHSC2_RDWRMASK			0x0000ff00U
#define XHC_RHSHSC2_RESETVALUE			0x00000000U

#define XHC_RHSHSR2_OFFSET			0xca4U
#define XHC_RHSHSR2_BASE			0xca4U
#define XHC_RHSHSR2__C2U_L			31U
#define XHC_RHSHSR2__C2U_R			24U
#define XHC_RHSHSR2__C2U_WIDTH			8U
#define XHC_RHSHSR2__C2U_RESETVALUE		0x00U
#define XHC_RHSHSR2__C1U_L			23U
#define XHC_RHSHSR2__C1U_R			16U
#define XHC_RHSHSR2__C1U_WIDTH			8U
#define XHC_RHSHSR2__C1U_RESETVALUE		0x00U
#define XHC_RHSHSR2__RCV_L			15U
#define XHC_RHSHSR2__RCV_R			8U
#define XHC_RHSHSR2__RCV_WIDTH			8U
#define XHC_RHSHSR2__RCV_RESETVALUE		0x00U
#define XHC_RHSHSR2__RTY_L			7U
#define XHC_RHSHSR2__RTY_R			0U
#define XHC_RHSHSR2__RTY_WIDTH			8U
#define XHC_RHSHSR2__RTY_RESETVALUE		0x00U
#define XHC_RHSHSR2_WIDTH			32U
#define XHC_RHSHSR2__WIDTH			32U
#define XHC_RHSHSR2_ALL_L			31U
#define XHC_RHSHSR2_ALL_R			0U
#define XHC_RHSHSR2__ALL_L			31U
#define XHC_RHSHSR2__ALL_R			0U
#define XHC_RHSHSR2_DATAMASK			0xffffffffU
#define XHC_RHSHSR2_RDWRMASK			0x00000000U
#define XHC_RHSHSR2_RESETVALUE			0x00000000U

#define XHC_RHSHSC3_OFFSET			0xca8U
#define XHC_RHSHSC3_BASE			0xca8U
#define XHC_RHSHSC3__TMR_L			31U
#define XHC_RHSHSC3__TMR_R			16U
#define XHC_RHSHSC3__TMR_WIDTH			16U
#define XHC_RHSHSC3__TMR_RESETVALUE		0x0000U
#define XHC_RHSHSC3__RSL_L			7U
#define XHC_RHSHSC3__RSL_R			6U
#define XHC_RHSHSC3__RSL_WIDTH			2U
#define XHC_RHSHSC3__RSL_RESETVALUE		0x0U
#define XHC_RHSHSC3__AS_M_L			5U
#define XHC_RHSHSC3__AS_M_R			4U
#define XHC_RHSHSC3__AS_M_WIDTH			2U
#define XHC_RHSHSC3__AS_M_RESETVALUE		0x0U
#define XHC_RHSHSC3__CMD_L			3U
#define XHC_RHSHSC3__CMD_R			2U
#define XHC_RHSHSC3__CMD_WIDTH			2U
#define XHC_RHSHSC3__CMD_RESETVALUE		0x0U
#define XHC_RHSHSC3__reserved			1U
#define XHC_RHSHSC3__reserved_L			1U
#define XHC_RHSHSC3__reserved_R			1U
#define XHC_RHSHSC3__reserved_WIDTH		1U
#define XHC_RHSHSC3__reserved_RESETVALUE	0x0U
#define XHC_RHSHSC3__STB			0U
#define XHC_RHSHSC3__STB_L			0U
#define XHC_RHSHSC3__STB_R			0U
#define XHC_RHSHSC3__STB_WIDTH			1U
#define XHC_RHSHSC3__STB_RESETVALUE		0x0U
#define XHC_RHSHSC3__RESERVED_L			15U
#define XHC_RHSHSC3__RESERVED_R			8U
#define XHC_RHSHSC3_WIDTH			32U
#define XHC_RHSHSC3__WIDTH			32U
#define XHC_RHSHSC3_ALL_L			31U
#define XHC_RHSHSC3_ALL_R			0U
#define XHC_RHSHSC3__ALL_L			31U
#define XHC_RHSHSC3__ALL_R			0U
#define XHC_RHSHSC3_DATAMASK			0xffff00ffU
#define XHC_RHSHSC3_RDWRMASK			0x0000ff00U
#define XHC_RHSHSC3_RESETVALUE			0x00000000U

#define XHC_RHSHSR3_OFFSET			0xcacU
#define XHC_RHSHSR3_BASE			0xcacU
#define XHC_RHSHSR3__C2U_L			31U
#define XHC_RHSHSR3__C2U_R			24U
#define XHC_RHSHSR3__C2U_WIDTH			8U
#define XHC_RHSHSR3__C2U_RESETVALUE		0x00U
#define XHC_RHSHSR3__C1U_L			23U
#define XHC_RHSHSR3__C1U_R			16U
#define XHC_RHSHSR3__C1U_WIDTH			8U
#define XHC_RHSHSR3__C1U_RESETVALUE		0x00U
#define XHC_RHSHSR3__RCV_L			15U
#define XHC_RHSHSR3__RCV_R			8U
#define XHC_RHSHSR3__RCV_WIDTH			8U
#define XHC_RHSHSR3__RCV_RESETVALUE		0x00U
#define XHC_RHSHSR3__RTY_L			7U
#define XHC_RHSHSR3__RTY_R			0U
#define XHC_RHSHSR3__RTY_WIDTH			8U
#define XHC_RHSHSR3__RTY_RESETVALUE		0x00U
#define XHC_RHSHSR3_WIDTH			32U
#define XHC_RHSHSR3__WIDTH			32U
#define XHC_RHSHSR3_ALL_L			31U
#define XHC_RHSHSR3_ALL_R			0U
#define XHC_RHSHSR3__ALL_L			31U
#define XHC_RHSHSR3__ALL_R			0U
#define XHC_RHSHSR3_DATAMASK			0xffffffffU
#define XHC_RHSHSR3_RDWRMASK			0x00000000U
#define XHC_RHSHSR3_RESETVALUE			0x00000000U

#define XHC_ECHSSP_OFFSET			0xcb0U
#define XHC_ECHSSP_BASE				0xcb0U
#define XHC_ECHSSP__reserved_L			31U
#define XHC_ECHSSP__reserved_R			16U
#define XHC_ECHSSP__reserved_WIDTH		16U
#define XHC_ECHSSP__reserved_RESETVALUE		0x0000U
#define XHC_ECHSSP__NCP_L			15U
#define XHC_ECHSSP__NCP_R			8U
#define XHC_ECHSSP__NCP_WIDTH			8U
#define XHC_ECHSSP__NCP_RESETVALUE		0x04U
#define XHC_ECHSSP__CID_L			7U
#define XHC_ECHSSP__CID_R			0U
#define XHC_ECHSSP__CID_WIDTH			8U
#define XHC_ECHSSP__CID_RESETVALUE		0xc6U
#define XHC_ECHSSP_WIDTH			32U
#define XHC_ECHSSP__WIDTH			32U
#define XHC_ECHSSP_ALL_L			31U
#define XHC_ECHSSP_ALL_R			0U
#define XHC_ECHSSP__ALL_L			31U
#define XHC_ECHSSP__ALL_R			0U
#define XHC_ECHSSP_DATAMASK			0xffffffffU
#define XHC_ECHSSP_RDWRMASK			0x00000000U
#define XHC_ECHSSP_RESETVALUE			0x000004c6U

#define XHC_SSPVER_OFFSET			0xcb4U
#define XHC_SSPVER_BASE				0xcb4U
#define XHC_SSPVER__MAJ_L			31U
#define XHC_SSPVER__MAJ_R			28U
#define XHC_SSPVER__MAJ_WIDTH			4U
#define XHC_SSPVER__MAJ_RESETVALUE		0x0U
#define XHC_SSPVER__MIN_L			27U
#define XHC_SSPVER__MIN_R			24U
#define XHC_SSPVER__MIN_WIDTH			4U
#define XHC_SSPVER__MIN_RESETVALUE		0x0U
#define XHC_SSPVER__RLS_L			23U
#define XHC_SSPVER__RLS_R			20U
#define XHC_SSPVER__RLS_WIDTH			4U
#define XHC_SSPVER__RLS_RESETVALUE		0x0U
#define XHC_SSPVER__reserved_L			19U
#define XHC_SSPVER__reserved_R			0U
#define XHC_SSPVER__reserved_WIDTH		20U
#define XHC_SSPVER__reserved_RESETVALUE		0x00000U
#define XHC_SSPVER_WIDTH			32U
#define XHC_SSPVER__WIDTH			32U
#define XHC_SSPVER_ALL_L			31U
#define XHC_SSPVER_ALL_R			0U
#define XHC_SSPVER__ALL_L			31U
#define XHC_SSPVER__ALL_R			0U
#define XHC_SSPVER_DATAMASK			0xffffffffU
#define XHC_SSPVER_RDWRMASK			0x00000000U
#define XHC_SSPVER_RESETVALUE			0x00000000U

#define XHC_SSPMGN_OFFSET			0xcb8U
#define XHC_SSPMGN_BASE				0xcb8U
#define XHC_SSPMGN__MGN_L			31U
#define XHC_SSPMGN__MGN_R			0U
#define XHC_SSPMGN__MGN_WIDTH			32U
#define XHC_SSPMGN__MGN_RESETVALUE		0x4b535040U
#define XHC_SSPMGN_WIDTH			32U
#define XHC_SSPMGN__WIDTH			32U
#define XHC_SSPMGN_ALL_L			31U
#define XHC_SSPMGN_ALL_R			0U
#define XHC_SSPMGN__ALL_L			31U
#define XHC_SSPMGN__ALL_R			0U
#define XHC_SSPMGN_DATAMASK			0xffffffffU
#define XHC_SSPMGN_RDWRMASK			0x00000000U
#define XHC_SSPMGN_RESETVALUE			0x4b535040U

#define XHC_ECHFSC2_OFFSET			0xcc0U
#define XHC_ECHFSC2_BASE			0xcc0U
#define XHC_ECHFSC2__reserved_L			31U
#define XHC_ECHFSC2__reserved_R			16U
#define XHC_ECHFSC2__reserved_WIDTH		16U
#define XHC_ECHFSC2__reserved_RESETVALUE	0x0000U
#define XHC_ECHFSC2__NCP_L			15U
#define XHC_ECHFSC2__NCP_R			8U
#define XHC_ECHFSC2__NCP_WIDTH			8U
#define XHC_ECHFSC2__NCP_RESETVALUE		0x50U
#define XHC_ECHFSC2__CID_L			7U
#define XHC_ECHFSC2__CID_R			0U
#define XHC_ECHFSC2__CID_WIDTH			8U
#define XHC_ECHFSC2__CID_RESETVALUE		0xc7U
#define XHC_ECHFSC2_WIDTH			32U
#define XHC_ECHFSC2__WIDTH			32U
#define XHC_ECHFSC2_ALL_L			31U
#define XHC_ECHFSC2_ALL_R			0U
#define XHC_ECHFSC2__ALL_L			31U
#define XHC_ECHFSC2__ALL_R			0U
#define XHC_ECHFSC2_DATAMASK			0xffffffffU
#define XHC_ECHFSC2_RDWRMASK			0x00000000U
#define XHC_ECHFSC2_RESETVALUE			0x000050c7U

#define XHC_FSC2POC_OFFSET			0xcd4U
#define XHC_FSC2POC_BASE			0xcd4U
#define XHC_FSC2POC__NCS_L			31U
#define XHC_FSC2POC__NCS_R			28U
#define XHC_FSC2POC__NCS_WIDTH			4U
#define XHC_FSC2POC__NCS_RESETVALUE		0x0U
#define XHC_FSC2POC__FSIZ_L			22U
#define XHC_FSC2POC__FSIZ_R			18U
#define XHC_FSC2POC__FSIZ_WIDTH			5U
#define XHC_FSC2POC__FSIZ_RESETVALUE		0x0U
#define XHC_FSC2POC__PSIZ_L			16U
#define XHC_FSC2POC__PSIZ_R			12U
#define XHC_FSC2POC__PSIZ_WIDTH			5U
#define XHC_FSC2POC__PSIZ_RESETVALUE		0x0U
#define XHC_FSC2POC__reserved_L			11U
#define XHC_FSC2POC__reserved_R			5U
#define XHC_FSC2POC__reserved_WIDTH		7U
#define XHC_FSC2POC__reserved_RESETVALUE	0x0U
#define XHC_FSC2POC__TSIZ_L			4U
#define XHC_FSC2POC__TSIZ_R			0U
#define XHC_FSC2POC__TSIZ_WIDTH			5U
#define XHC_FSC2POC__TSIZ_RESETVALUE		0x0U
#define XHC_FSC2POC__RESERVED_L			27U
#define XHC_FSC2POC__RESERVED_R			23U
#define XHC_FSC2POC_WIDTH			32U
#define XHC_FSC2POC__WIDTH			32U
#define XHC_FSC2POC_ALL_L			31U
#define XHC_FSC2POC_ALL_R			0U
#define XHC_FSC2POC__ALL_L			31U
#define XHC_FSC2POC__ALL_R			0U
#define XHC_FSC2POC_DATAMASK			0xf07dffffU
#define XHC_FSC2POC_RDWRMASK			0x0f820000U
#define XHC_FSC2POC_RESETVALUE			0x00000000U

#define XHC_FSC2GOC_OFFSET			0xcd8U
#define XHC_FSC2GOC_BASE			0xcd8U
#define XHC_FSC2GOC__NCS_L			31U
#define XHC_FSC2GOC__NCS_R			28U
#define XHC_FSC2GOC__NCS_WIDTH			4U
#define XHC_FSC2GOC__NCS_RESETVALUE		0x0U
#define XHC_FSC2GOC__FSIZ_L			22U
#define XHC_FSC2GOC__FSIZ_R			18U
#define XHC_FSC2GOC__FSIZ_WIDTH			5U
#define XHC_FSC2GOC__FSIZ_RESETVALUE		0x0U
#define XHC_FSC2GOC__PSIZ_L			16U
#define XHC_FSC2GOC__PSIZ_R			12U
#define XHC_FSC2GOC__PSIZ_WIDTH			5U
#define XHC_FSC2GOC__PSIZ_RESETVALUE		0x0U
#define XHC_FSC2GOC__reserved_L			11U
#define XHC_FSC2GOC__reserved_R			5U
#define XHC_FSC2GOC__reserved_WIDTH		7U
#define XHC_FSC2GOC__reserved_RESETVALUE	0x0U
#define XHC_FSC2GOC__TSIZ_L			4U
#define XHC_FSC2GOC__TSIZ_R			0U
#define XHC_FSC2GOC__TSIZ_WIDTH			5U
#define XHC_FSC2GOC__TSIZ_RESETVALUE		0x0U
#define XHC_FSC2GOC__RESERVED_L			27U
#define XHC_FSC2GOC__RESERVED_R			23U
#define XHC_FSC2GOC_WIDTH			32U
#define XHC_FSC2GOC__WIDTH			32U
#define XHC_FSC2GOC_ALL_L			31U
#define XHC_FSC2GOC_ALL_R			0U
#define XHC_FSC2GOC__ALL_L			31U
#define XHC_FSC2GOC__ALL_R			0U
#define XHC_FSC2GOC_DATAMASK			0xf07dffffU
#define XHC_FSC2GOC_RDWRMASK			0x0f820000U
#define XHC_FSC2GOC_RESETVALUE			0x00000000U

#define XHC_FSC2NOC_OFFSET			0xcdcU
#define XHC_FSC2NOC_BASE			0xcdcU
#define XHC_FSC2NOC__NCS_L			31U
#define XHC_FSC2NOC__NCS_R			28U
#define XHC_FSC2NOC__NCS_WIDTH			4U
#define XHC_FSC2NOC__NCS_RESETVALUE		0x0U
#define XHC_FSC2NOC__FSIZ_L			22U
#define XHC_FSC2NOC__FSIZ_R			18U
#define XHC_FSC2NOC__FSIZ_WIDTH			5U
#define XHC_FSC2NOC__FSIZ_RESETVALUE		0x0U
#define XHC_FSC2NOC__PSIZ_L			16U
#define XHC_FSC2NOC__PSIZ_R			12U
#define XHC_FSC2NOC__PSIZ_WIDTH			5U
#define XHC_FSC2NOC__PSIZ_RESETVALUE		0x0U
#define XHC_FSC2NOC__reserved_L			11U
#define XHC_FSC2NOC__reserved_R			5U
#define XHC_FSC2NOC__reserved_WIDTH		7U
#define XHC_FSC2NOC__reserved_RESETVALUE	0x0U
#define XHC_FSC2NOC__TSIZ_L			4U
#define XHC_FSC2NOC__TSIZ_R			0U
#define XHC_FSC2NOC__TSIZ_WIDTH			5U
#define XHC_FSC2NOC__TSIZ_RESETVALUE		0x0U
#define XHC_FSC2NOC__RESERVED_L			27U
#define XHC_FSC2NOC__RESERVED_R			23U
#define XHC_FSC2NOC_WIDTH			32U
#define XHC_FSC2NOC__WIDTH			32U
#define XHC_FSC2NOC_ALL_L			31U
#define XHC_FSC2NOC_ALL_R			0U
#define XHC_FSC2NOC__ALL_L			31U
#define XHC_FSC2NOC__ALL_R			0U
#define XHC_FSC2NOC_DATAMASK			0xf07dffffU
#define XHC_FSC2NOC_RDWRMASK			0x0f820000U
#define XHC_FSC2NOC_RESETVALUE			0x00000000U

#define XHC_FSC2AIC_OFFSET			0xce0U
#define XHC_FSC2AIC_BASE			0xce0U
#define XHC_FSC2AIC__FSIZ_L			22U
#define XHC_FSC2AIC__FSIZ_R			18U
#define XHC_FSC2AIC__FSIZ_WIDTH			5U
#define XHC_FSC2AIC__FSIZ_RESETVALUE		0x0U
#define XHC_FSC2AIC__PSIZ_L			16U
#define XHC_FSC2AIC__PSIZ_R			12U
#define XHC_FSC2AIC__PSIZ_WIDTH			5U
#define XHC_FSC2AIC__PSIZ_RESETVALUE		0x0U
#define XHC_FSC2AIC__reserved_L			11U
#define XHC_FSC2AIC__reserved_R			0U
#define XHC_FSC2AIC__reserved_WIDTH		12U
#define XHC_FSC2AIC__reserved_RESETVALUE	0x000U
#define XHC_FSC2AIC__RESERVED_L			31U
#define XHC_FSC2AIC__RESERVED_R			23U
#define XHC_FSC2AIC_WIDTH			23U
#define XHC_FSC2AIC__WIDTH			23U
#define XHC_FSC2AIC_ALL_L			22U
#define XHC_FSC2AIC_ALL_R			0U
#define XHC_FSC2AIC__ALL_L			22U
#define XHC_FSC2AIC__ALL_R			0U
#define XHC_FSC2AIC_DATAMASK			0x007dffffU
#define XHC_FSC2AIC_RDWRMASK			0xff820000U
#define XHC_FSC2AIC_RESETVALUE			0x000000U

#define XHC_FSC2PIC_OFFSET			0xce4U
#define XHC_FSC2PIC_BASE			0xce4U
#define XHC_FSC2PIC__NCS_L			31U
#define XHC_FSC2PIC__NCS_R			28U
#define XHC_FSC2PIC__NCS_WIDTH			4U
#define XHC_FSC2PIC__NCS_RESETVALUE		0x0U
#define XHC_FSC2PIC__reserved_L			27U
#define XHC_FSC2PIC__reserved_R			5U
#define XHC_FSC2PIC__reserved_WIDTH		23U
#define XHC_FSC2PIC__reserved_RESETVALUE	0x0U
#define XHC_FSC2PIC__TSIZ_L			4U
#define XHC_FSC2PIC__TSIZ_R			0U
#define XHC_FSC2PIC__TSIZ_WIDTH			5U
#define XHC_FSC2PIC__TSIZ_RESETVALUE		0x0U
#define XHC_FSC2PIC_WIDTH			32U
#define XHC_FSC2PIC__WIDTH			32U
#define XHC_FSC2PIC_ALL_L			31U
#define XHC_FSC2PIC_ALL_R			0U
#define XHC_FSC2PIC__ALL_L			31U
#define XHC_FSC2PIC__ALL_R			0U
#define XHC_FSC2PIC_DATAMASK			0xffffffffU
#define XHC_FSC2PIC_RDWRMASK			0x00000000U
#define XHC_FSC2PIC_RESETVALUE			0x00000000U

#define XHC_FSC2GIC_OFFSET			0xce8U
#define XHC_FSC2GIC_BASE			0xce8U
#define XHC_FSC2GIC__NCS_L			31U
#define XHC_FSC2GIC__NCS_R			28U
#define XHC_FSC2GIC__NCS_WIDTH			4U
#define XHC_FSC2GIC__NCS_RESETVALUE		0x0U
#define XHC_FSC2GIC__reserved_L			27U
#define XHC_FSC2GIC__reserved_R			5U
#define XHC_FSC2GIC__reserved_WIDTH		23U
#define XHC_FSC2GIC__reserved_RESETVALUE	0x0U
#define XHC_FSC2GIC__TSIZ_L			4U
#define XHC_FSC2GIC__TSIZ_R			0U
#define XHC_FSC2GIC__TSIZ_WIDTH			5U
#define XHC_FSC2GIC__TSIZ_RESETVALUE		0x0U
#define XHC_FSC2GIC_WIDTH			32U
#define XHC_FSC2GIC__WIDTH			32U
#define XHC_FSC2GIC_ALL_L			31U
#define XHC_FSC2GIC_ALL_R			0U
#define XHC_FSC2GIC__ALL_L			31U
#define XHC_FSC2GIC__ALL_R			0U
#define XHC_FSC2GIC_DATAMASK			0xffffffffU
#define XHC_FSC2GIC_RDWRMASK			0x00000000U
#define XHC_FSC2GIC_RESETVALUE			0x00000000U

#define XHC_FSC2NIC_OFFSET			0xcecU
#define XHC_FSC2NIC_BASE			0xcecU
#define XHC_FSC2NIC__NCS_L			31U
#define XHC_FSC2NIC__NCS_R			28U
#define XHC_FSC2NIC__NCS_WIDTH			4U
#define XHC_FSC2NIC__NCS_RESETVALUE		0x0U
#define XHC_FSC2NIC__reserved_L			27U
#define XHC_FSC2NIC__reserved_R			5U
#define XHC_FSC2NIC__reserved_WIDTH		23U
#define XHC_FSC2NIC__reserved_RESETVALUE	0x0U
#define XHC_FSC2NIC__TSIZ_L			4U
#define XHC_FSC2NIC__TSIZ_R			0U
#define XHC_FSC2NIC__TSIZ_WIDTH			5U
#define XHC_FSC2NIC__TSIZ_RESETVALUE		0x0U
#define XHC_FSC2NIC_WIDTH			32U
#define XHC_FSC2NIC__WIDTH			32U
#define XHC_FSC2NIC_ALL_L			31U
#define XHC_FSC2NIC_ALL_R			0U
#define XHC_FSC2NIC__ALL_L			31U
#define XHC_FSC2NIC__ALL_R			0U
#define XHC_FSC2NIC_DATAMASK			0xffffffffU
#define XHC_FSC2NIC_RDWRMASK			0x00000000U
#define XHC_FSC2NIC_RESETVALUE			0x00000000U

#define XHC_ECHPRT2_OFFSET			0xcf0U
#define XHC_ECHPRT2_BASE			0xcf0U
#define XHC_ECHPRT2__HDP			31U
#define XHC_ECHPRT2__HDP_L			31U
#define XHC_ECHPRT2__HDP_R			31U
#define XHC_ECHPRT2__HDP_WIDTH			1U
#define XHC_ECHPRT2__HDP_RESETVALUE		0x0U
#define XHC_ECHPRT2__FDP			30U
#define XHC_ECHPRT2__FDP_L			30U
#define XHC_ECHPRT2__FDP_R			30U
#define XHC_ECHPRT2__FDP_WIDTH			1U
#define XHC_ECHPRT2__FDP_RESETVALUE		0x0U
#define XHC_ECHPRT2__reserved_L			29U
#define XHC_ECHPRT2__reserved_R			17U
#define XHC_ECHPRT2__reserved_WIDTH		13U
#define XHC_ECHPRT2__reserved_RESETVALUE	0x0U
#define XHC_ECHPRT2__HST			16U
#define XHC_ECHPRT2__HST_L			16U
#define XHC_ECHPRT2__HST_R			16U
#define XHC_ECHPRT2__HST_WIDTH			1U
#define XHC_ECHPRT2__HST_RESETVALUE		0x0U
#define XHC_ECHPRT2__NCP_L			15U
#define XHC_ECHPRT2__NCP_R			8U
#define XHC_ECHPRT2__NCP_WIDTH			8U
#define XHC_ECHPRT2__NCP_RESETVALUE		0x04U
#define XHC_ECHPRT2__CID_L			7U
#define XHC_ECHPRT2__CID_R			0U
#define XHC_ECHPRT2__CID_WIDTH			8U
#define XHC_ECHPRT2__CID_RESETVALUE		0xc8U
#define XHC_ECHPRT2_WIDTH			32U
#define XHC_ECHPRT2__WIDTH			32U
#define XHC_ECHPRT2_ALL_L			31U
#define XHC_ECHPRT2_ALL_R			0U
#define XHC_ECHPRT2__ALL_L			31U
#define XHC_ECHPRT2__ALL_R			0U
#define XHC_ECHPRT2_DATAMASK			0xffffffffU
#define XHC_ECHPRT2_RDWRMASK			0x00000000U
#define XHC_ECHPRT2_RESETVALUE			0x000004c8U

#define XHC_PRT2HSC_OFFSET			0xcf8U
#define XHC_PRT2HSC_BASE			0xcf8U
#define XHC_PRT2HSC__TMR_L			31U
#define XHC_PRT2HSC__TMR_R			16U
#define XHC_PRT2HSC__TMR_WIDTH			16U
#define XHC_PRT2HSC__TMR_RESETVALUE		0x0000U
#define XHC_PRT2HSC__RSL_L			7U
#define XHC_PRT2HSC__RSL_R			6U
#define XHC_PRT2HSC__RSL_WIDTH			2U
#define XHC_PRT2HSC__RSL_RESETVALUE		0x0U
#define XHC_PRT2HSC__AS_M_L			5U
#define XHC_PRT2HSC__AS_M_R			4U
#define XHC_PRT2HSC__AS_M_WIDTH			2U
#define XHC_PRT2HSC__AS_M_RESETVALUE		0x0U
#define XHC_PRT2HSC__CMD_L			3U
#define XHC_PRT2HSC__CMD_R			2U
#define XHC_PRT2HSC__CMD_WIDTH			2U
#define XHC_PRT2HSC__CMD_RESETVALUE		0x0U
#define XHC_PRT2HSC__reserved			1U
#define XHC_PRT2HSC__reserved_L			1U
#define XHC_PRT2HSC__reserved_R			1U
#define XHC_PRT2HSC__reserved_WIDTH		1U
#define XHC_PRT2HSC__reserved_RESETVALUE	0x0U
#define XHC_PRT2HSC__STB			0U
#define XHC_PRT2HSC__STB_L			0U
#define XHC_PRT2HSC__STB_R			0U
#define XHC_PRT2HSC__STB_WIDTH			1U
#define XHC_PRT2HSC__STB_RESETVALUE		0x0U
#define XHC_PRT2HSC__RESERVED_L			15U
#define XHC_PRT2HSC__RESERVED_R			8U
#define XHC_PRT2HSC_WIDTH			32U
#define XHC_PRT2HSC__WIDTH			32U
#define XHC_PRT2HSC_ALL_L			31U
#define XHC_PRT2HSC_ALL_R			0U
#define XHC_PRT2HSC__ALL_L			31U
#define XHC_PRT2HSC__ALL_R			0U
#define XHC_PRT2HSC_DATAMASK			0xffff00ffU
#define XHC_PRT2HSC_RDWRMASK			0x0000ff00U
#define XHC_PRT2HSC_RESETVALUE			0x00000000U

#define XHC_PRT2HSR_OFFSET			0xcfcU
#define XHC_PRT2HSR_BASE			0xcfcU
#define XHC_PRT2HSR__RNAK_L			31U
#define XHC_PRT2HSR__RNAK_R			24U
#define XHC_PRT2HSR__RNAK_WIDTH			8U
#define XHC_PRT2HSR__RNAK_RESETVALUE		0x00U
#define XHC_PRT2HSR__HSTX_L			23U
#define XHC_PRT2HSR__HSTX_R			16U
#define XHC_PRT2HSR__HSTX_WIDTH			8U
#define XHC_PRT2HSR__HSTX_RESETVALUE		0x00U
#define XHC_PRT2HSR__HSRX_L			15U
#define XHC_PRT2HSR__HSRX_R			8U
#define XHC_PRT2HSR__HSRX_WIDTH			8U
#define XHC_PRT2HSR__HSRX_RESETVALUE		0x00U
#define XHC_PRT2HSR__SPLT_L			7U
#define XHC_PRT2HSR__SPLT_R			0U
#define XHC_PRT2HSR__SPLT_WIDTH			8U
#define XHC_PRT2HSR__SPLT_RESETVALUE		0x00U
#define XHC_PRT2HSR_WIDTH			32U
#define XHC_PRT2HSR__WIDTH			32U
#define XHC_PRT2HSR_ALL_L			31U
#define XHC_PRT2HSR_ALL_R			0U
#define XHC_PRT2HSR__ALL_L			31U
#define XHC_PRT2HSR__ALL_R			0U
#define XHC_PRT2HSR_DATAMASK			0xffffffffU
#define XHC_PRT2HSR_RDWRMASK			0x00000000U
#define XHC_PRT2HSR_RESETVALUE			0x00000000U

#define XHC_ECHRH2_OFFSET			0xd00U
#define XHC_ECHRH2_BASE				0xd00U
#define XHC_ECHRH2__MTT				31U
#define XHC_ECHRH2__MTT_L			31U
#define XHC_ECHRH2__MTT_R			31U
#define XHC_ECHRH2__MTT_WIDTH			1U
#define XHC_ECHRH2__MTT_RESETVALUE		0x0U
#define XHC_ECHRH2__RPO_L			30U
#define XHC_ECHRH2__RPO_R			24U
#define XHC_ECHRH2__RPO_WIDTH			7U
#define XHC_ECHRH2__RPO_RESETVALUE		0x0U
#define XHC_ECHRH2__reserved_L			23U
#define XHC_ECHRH2__reserved_R			22U
#define XHC_ECHRH2__reserved_WIDTH		2U
#define XHC_ECHRH2__reserved_RESETVALUE		0x0U
#define XHC_ECHRH2__RPN_L			21U
#define XHC_ECHRH2__RPN_R			20U
#define XHC_ECHRH2__RPN_WIDTH			2U
#define XHC_ECHRH2__RPN_RESETVALUE		0x0U
#define XHC_ECHRH2__DNR_L			19U
#define XHC_ECHRH2__DNR_R			16U
#define XHC_ECHRH2__DNR_WIDTH			4U
#define XHC_ECHRH2__DNR_RESETVALUE		0x0U
#define XHC_ECHRH2__NCP_L			15U
#define XHC_ECHRH2__NCP_R			8U
#define XHC_ECHRH2__NCP_WIDTH			8U
#define XHC_ECHRH2__NCP_RESETVALUE		0x0cU
#define XHC_ECHRH2__CID_L			7U
#define XHC_ECHRH2__CID_R			0U
#define XHC_ECHRH2__CID_WIDTH			8U
#define XHC_ECHRH2__CID_RESETVALUE		0xc9U
#define XHC_ECHRH2_WIDTH			32U
#define XHC_ECHRH2__WIDTH			32U
#define XHC_ECHRH2_ALL_L			31U
#define XHC_ECHRH2_ALL_R			0U
#define XHC_ECHRH2__ALL_L			31U
#define XHC_ECHRH2__ALL_R			0U
#define XHC_ECHRH2_DATAMASK			0xffffffffU
#define XHC_ECHRH2_RDWRMASK			0x00000000U
#define XHC_ECHRH2_RESETVALUE			0x00000cc9U

#define XHC_RH2DES_OFFSET			0xd04U
#define XHC_RH2DES_BASE				0xd04U
#define XHC_RH2DES__PIS3_L			31U
#define XHC_RH2DES__PIS3_R			30U
#define XHC_RH2DES__PIS3_WIDTH			2U
#define XHC_RH2DES__PIS3_RESETVALUE		0x0U
#define XHC_RH2DES__HIST3			24U
#define XHC_RH2DES__HIST3_L			24U
#define XHC_RH2DES__HIST3_R			24U
#define XHC_RH2DES__HIST3_WIDTH			1U
#define XHC_RH2DES__HIST3_RESETVALUE		0x0U
#define XHC_RH2DES__PIS2_L			23U
#define XHC_RH2DES__PIS2_R			22U
#define XHC_RH2DES__PIS2_WIDTH			2U
#define XHC_RH2DES__PIS2_RESETVALUE		0x0U
#define XHC_RH2DES__HIST2			16U
#define XHC_RH2DES__HIST2_L			16U
#define XHC_RH2DES__HIST2_R			16U
#define XHC_RH2DES__HIST2_WIDTH			1U
#define XHC_RH2DES__HIST2_RESETVALUE		0x0U
#define XHC_RH2DES__PIS1_L			15U
#define XHC_RH2DES__PIS1_R			14U
#define XHC_RH2DES__PIS1_WIDTH			2U
#define XHC_RH2DES__PIS1_RESETVALUE		0x0U
#define XHC_RH2DES__HIST1			8U
#define XHC_RH2DES__HIST1_L			8U
#define XHC_RH2DES__HIST1_R			8U
#define XHC_RH2DES__HIST1_WIDTH			1U
#define XHC_RH2DES__HIST1_RESETVALUE		0x0U
#define XHC_RH2DES__PIS0_L			7U
#define XHC_RH2DES__PIS0_R			6U
#define XHC_RH2DES__PIS0_WIDTH			2U
#define XHC_RH2DES__PIS0_RESETVALUE		0x0U
#define XHC_RH2DES__reserved_L			5U
#define XHC_RH2DES__reserved_R			1U
#define XHC_RH2DES__reserved_WIDTH		5U
#define XHC_RH2DES__reserved_RESETVALUE		0x0U
#define XHC_RH2DES__HIST0			0U
#define XHC_RH2DES__HIST0_L			0U
#define XHC_RH2DES__HIST0_R			0U
#define XHC_RH2DES__HIST0_WIDTH			1U
#define XHC_RH2DES__HIST0_RESETVALUE		0x0U
#define XHC_RH2DES__RESERVED_0_L		29U
#define XHC_RH2DES__RESERVED_0_R		25U
#define XHC_RH2DES__RESERVED_1_L		21U
#define XHC_RH2DES__RESERVED_1_R		17U
#define XHC_RH2DES__RESERVED_2_L		13U
#define XHC_RH2DES__RESERVED_2_R		9U
#define XHC_RH2DES__RESERVED_L			29U
#define XHC_RH2DES__RESERVED_R			25U
#define XHC_RH2DES_WIDTH			32U
#define XHC_RH2DES__WIDTH			32U
#define XHC_RH2DES_ALL_L			31U
#define XHC_RH2DES_ALL_R			0U
#define XHC_RH2DES__ALL_L			31U
#define XHC_RH2DES__ALL_R			0U
#define XHC_RH2DES_DATAMASK			0xc1c1c1ffU
#define XHC_RH2DES_RDWRMASK			0x3e3e3e00U
#define XHC_RH2DES_RESETVALUE			0x00000000U

#define XHC_RH2HSC0_OFFSET			0xd10U
#define XHC_RH2HSC0_BASE			0xd10U
#define XHC_RH2HSC0__TMR_L			31U
#define XHC_RH2HSC0__TMR_R			16U
#define XHC_RH2HSC0__TMR_WIDTH			16U
#define XHC_RH2HSC0__TMR_RESETVALUE		0x0000U
#define XHC_RH2HSC0__RSL_L			7U
#define XHC_RH2HSC0__RSL_R			6U
#define XHC_RH2HSC0__RSL_WIDTH			2U
#define XHC_RH2HSC0__RSL_RESETVALUE		0x0U
#define XHC_RH2HSC0__AS_M_L			5U
#define XHC_RH2HSC0__AS_M_R			4U
#define XHC_RH2HSC0__AS_M_WIDTH			2U
#define XHC_RH2HSC0__AS_M_RESETVALUE		0x0U
#define XHC_RH2HSC0__CMD_L			3U
#define XHC_RH2HSC0__CMD_R			2U
#define XHC_RH2HSC0__CMD_WIDTH			2U
#define XHC_RH2HSC0__CMD_RESETVALUE		0x0U
#define XHC_RH2HSC0__reserved			1U
#define XHC_RH2HSC0__reserved_L			1U
#define XHC_RH2HSC0__reserved_R			1U
#define XHC_RH2HSC0__reserved_WIDTH		1U
#define XHC_RH2HSC0__reserved_RESETVALUE	0x0U
#define XHC_RH2HSC0__STB			0U
#define XHC_RH2HSC0__STB_L			0U
#define XHC_RH2HSC0__STB_R			0U
#define XHC_RH2HSC0__STB_WIDTH			1U
#define XHC_RH2HSC0__STB_RESETVALUE		0x0U
#define XHC_RH2HSC0__RESERVED_L			15U
#define XHC_RH2HSC0__RESERVED_R			8U
#define XHC_RH2HSC0_WIDTH			32U
#define XHC_RH2HSC0__WIDTH			32U
#define XHC_RH2HSC0_ALL_L			31U
#define XHC_RH2HSC0_ALL_R			0U
#define XHC_RH2HSC0__ALL_L			31U
#define XHC_RH2HSC0__ALL_R			0U
#define XHC_RH2HSC0_DATAMASK			0xffff00ffU
#define XHC_RH2HSC0_RDWRMASK			0x0000ff00U
#define XHC_RH2HSC0_RESETVALUE			0x00000000U

#define XHC_RH2HSR0_OFFSET			0xd14U
#define XHC_RH2HSR0_BASE			0xd14U
#define XHC_RH2HSR0__C2U_L			31U
#define XHC_RH2HSR0__C2U_R			24U
#define XHC_RH2HSR0__C2U_WIDTH			8U
#define XHC_RH2HSR0__C2U_RESETVALUE		0x00U
#define XHC_RH2HSR0__C1U_L			23U
#define XHC_RH2HSR0__C1U_R			16U
#define XHC_RH2HSR0__C1U_WIDTH			8U
#define XHC_RH2HSR0__C1U_RESETVALUE		0x00U
#define XHC_RH2HSR0__reserved_L			15U
#define XHC_RH2HSR0__reserved_R			8U
#define XHC_RH2HSR0__reserved_WIDTH		8U
#define XHC_RH2HSR0__reserved_RESETVALUE	0x00U
#define XHC_RH2HSR0__RTY_L			7U
#define XHC_RH2HSR0__RTY_R			0U
#define XHC_RH2HSR0__RTY_WIDTH			8U
#define XHC_RH2HSR0__RTY_RESETVALUE		0x00U
#define XHC_RH2HSR0_WIDTH			32U
#define XHC_RH2HSR0__WIDTH			32U
#define XHC_RH2HSR0_ALL_L			31U
#define XHC_RH2HSR0_ALL_R			0U
#define XHC_RH2HSR0__ALL_L			31U
#define XHC_RH2HSR0__ALL_R			0U
#define XHC_RH2HSR0_DATAMASK			0xffffffffU
#define XHC_RH2HSR0_RDWRMASK			0x00000000U
#define XHC_RH2HSR0_RESETVALUE			0x00000000U

#define XHC_RH2HSC1_OFFSET			0xd18U
#define XHC_RH2HSC1_BASE			0xd18U
#define XHC_RH2HSC1__TMR_L			31U
#define XHC_RH2HSC1__TMR_R			16U
#define XHC_RH2HSC1__TMR_WIDTH			16U
#define XHC_RH2HSC1__TMR_RESETVALUE		0x0000U
#define XHC_RH2HSC1__RSL_L			7U
#define XHC_RH2HSC1__RSL_R			6U
#define XHC_RH2HSC1__RSL_WIDTH			2U
#define XHC_RH2HSC1__RSL_RESETVALUE		0x0U
#define XHC_RH2HSC1__AS_M_L			5U
#define XHC_RH2HSC1__AS_M_R			4U
#define XHC_RH2HSC1__AS_M_WIDTH			2U
#define XHC_RH2HSC1__AS_M_RESETVALUE		0x0U
#define XHC_RH2HSC1__CMD_L			3U
#define XHC_RH2HSC1__CMD_R			2U
#define XHC_RH2HSC1__CMD_WIDTH			2U
#define XHC_RH2HSC1__CMD_RESETVALUE		0x0U
#define XHC_RH2HSC1__reserved			1U
#define XHC_RH2HSC1__reserved_L			1U
#define XHC_RH2HSC1__reserved_R			1U
#define XHC_RH2HSC1__reserved_WIDTH		1U
#define XHC_RH2HSC1__reserved_RESETVALUE	0x0U
#define XHC_RH2HSC1__STB			0U
#define XHC_RH2HSC1__STB_L			0U
#define XHC_RH2HSC1__STB_R			0U
#define XHC_RH2HSC1__STB_WIDTH			1U
#define XHC_RH2HSC1__STB_RESETVALUE		0x0U
#define XHC_RH2HSC1__RESERVED_L			15U
#define XHC_RH2HSC1__RESERVED_R			8U
#define XHC_RH2HSC1_WIDTH			32U
#define XHC_RH2HSC1__WIDTH			32U
#define XHC_RH2HSC1_ALL_L			31U
#define XHC_RH2HSC1_ALL_R			0U
#define XHC_RH2HSC1__ALL_L			31U
#define XHC_RH2HSC1__ALL_R			0U
#define XHC_RH2HSC1_DATAMASK			0xffff00ffU
#define XHC_RH2HSC1_RDWRMASK			0x0000ff00U
#define XHC_RH2HSC1_RESETVALUE			0x00000000U

#define XHC_RH2HSR1_OFFSET			0xd1cU
#define XHC_RH2HSR1_BASE			0xd1cU
#define XHC_RH2HSR1__C2U_L			31U
#define XHC_RH2HSR1__C2U_R			24U
#define XHC_RH2HSR1__C2U_WIDTH			8U
#define XHC_RH2HSR1__C2U_RESETVALUE		0x00U
#define XHC_RH2HSR1__C1U_L			23U
#define XHC_RH2HSR1__C1U_R			16U
#define XHC_RH2HSR1__C1U_WIDTH			8U
#define XHC_RH2HSR1__C1U_RESETVALUE		0x00U
#define XHC_RH2HSR1__reserved_L			15U
#define XHC_RH2HSR1__reserved_R			8U
#define XHC_RH2HSR1__reserved_WIDTH		8U
#define XHC_RH2HSR1__reserved_RESETVALUE	0x00U
#define XHC_RH2HSR1__RTY_L			7U
#define XHC_RH2HSR1__RTY_R			0U
#define XHC_RH2HSR1__RTY_WIDTH			8U
#define XHC_RH2HSR1__RTY_RESETVALUE		0x00U
#define XHC_RH2HSR1_WIDTH			32U
#define XHC_RH2HSR1__WIDTH			32U
#define XHC_RH2HSR1_ALL_L			31U
#define XHC_RH2HSR1_ALL_R			0U
#define XHC_RH2HSR1__ALL_L			31U
#define XHC_RH2HSR1__ALL_R			0U
#define XHC_RH2HSR1_DATAMASK			0xffffffffU
#define XHC_RH2HSR1_RDWRMASK			0x00000000U
#define XHC_RH2HSR1_RESETVALUE			0x00000000U

#define XHC_RH2HSC2_OFFSET			0xd20U
#define XHC_RH2HSC2_BASE			0xd20U
#define XHC_RH2HSC2__TMR_L			31U
#define XHC_RH2HSC2__TMR_R			16U
#define XHC_RH2HSC2__TMR_WIDTH			16U
#define XHC_RH2HSC2__TMR_RESETVALUE		0x0000U
#define XHC_RH2HSC2__RSL_L			7U
#define XHC_RH2HSC2__RSL_R			6U
#define XHC_RH2HSC2__RSL_WIDTH			2U
#define XHC_RH2HSC2__RSL_RESETVALUE		0x0U
#define XHC_RH2HSC2__AS_M_L			5U
#define XHC_RH2HSC2__AS_M_R			4U
#define XHC_RH2HSC2__AS_M_WIDTH			2U
#define XHC_RH2HSC2__AS_M_RESETVALUE		0x0U
#define XHC_RH2HSC2__CMD_L			3U
#define XHC_RH2HSC2__CMD_R			2U
#define XHC_RH2HSC2__CMD_WIDTH			2U
#define XHC_RH2HSC2__CMD_RESETVALUE		0x0U
#define XHC_RH2HSC2__reserved			1U
#define XHC_RH2HSC2__reserved_L			1U
#define XHC_RH2HSC2__reserved_R			1U
#define XHC_RH2HSC2__reserved_WIDTH		1U
#define XHC_RH2HSC2__reserved_RESETVALUE	0x0U
#define XHC_RH2HSC2__STB			0U
#define XHC_RH2HSC2__STB_L			0U
#define XHC_RH2HSC2__STB_R			0U
#define XHC_RH2HSC2__STB_WIDTH			1U
#define XHC_RH2HSC2__STB_RESETVALUE		0x0U
#define XHC_RH2HSC2__RESERVED_L			15U
#define XHC_RH2HSC2__RESERVED_R			8U
#define XHC_RH2HSC2_WIDTH			32U
#define XHC_RH2HSC2__WIDTH			32U
#define XHC_RH2HSC2_ALL_L			31U
#define XHC_RH2HSC2_ALL_R			0U
#define XHC_RH2HSC2__ALL_L			31U
#define XHC_RH2HSC2__ALL_R			0U
#define XHC_RH2HSC2_DATAMASK			0xffff00ffU
#define XHC_RH2HSC2_RDWRMASK			0x0000ff00U
#define XHC_RH2HSC2_RESETVALUE			0x00000000U

#define XHC_RH2HSR2_OFFSET			0xd24U
#define XHC_RH2HSR2_BASE			0xd24U
#define XHC_RH2HSR2__C2U_L			31U
#define XHC_RH2HSR2__C2U_R			24U
#define XHC_RH2HSR2__C2U_WIDTH			8U
#define XHC_RH2HSR2__C2U_RESETVALUE		0x00U
#define XHC_RH2HSR2__C1U_L			23U
#define XHC_RH2HSR2__C1U_R			16U
#define XHC_RH2HSR2__C1U_WIDTH			8U
#define XHC_RH2HSR2__C1U_RESETVALUE		0x00U
#define XHC_RH2HSR2__reserved_L			15U
#define XHC_RH2HSR2__reserved_R			8U
#define XHC_RH2HSR2__reserved_WIDTH		8U
#define XHC_RH2HSR2__reserved_RESETVALUE	0x00U
#define XHC_RH2HSR2__RTY_L			7U
#define XHC_RH2HSR2__RTY_R			0U
#define XHC_RH2HSR2__RTY_WIDTH			8U
#define XHC_RH2HSR2__RTY_RESETVALUE		0x00U
#define XHC_RH2HSR2_WIDTH			32U
#define XHC_RH2HSR2__WIDTH			32U
#define XHC_RH2HSR2_ALL_L			31U
#define XHC_RH2HSR2_ALL_R			0U
#define XHC_RH2HSR2__ALL_L			31U
#define XHC_RH2HSR2__ALL_R			0U
#define XHC_RH2HSR2_DATAMASK			0xffffffffU
#define XHC_RH2HSR2_RDWRMASK			0x00000000U
#define XHC_RH2HSR2_RESETVALUE			0x00000000U

#define XHC_RH2HSC3_OFFSET			0xd28U
#define XHC_RH2HSC3_BASE			0xd28U
#define XHC_RH2HSC3__TMR_L			31U
#define XHC_RH2HSC3__TMR_R			16U
#define XHC_RH2HSC3__TMR_WIDTH			16U
#define XHC_RH2HSC3__TMR_RESETVALUE		0x0000U
#define XHC_RH2HSC3__RSL_L			7U
#define XHC_RH2HSC3__RSL_R			6U
#define XHC_RH2HSC3__RSL_WIDTH			2U
#define XHC_RH2HSC3__RSL_RESETVALUE		0x0U
#define XHC_RH2HSC3__AS_M_L			5U
#define XHC_RH2HSC3__AS_M_R			4U
#define XHC_RH2HSC3__AS_M_WIDTH			2U
#define XHC_RH2HSC3__AS_M_RESETVALUE		0x0U
#define XHC_RH2HSC3__CMD_L			3U
#define XHC_RH2HSC3__CMD_R			2U
#define XHC_RH2HSC3__CMD_WIDTH			2U
#define XHC_RH2HSC3__CMD_RESETVALUE		0x0U
#define XHC_RH2HSC3__reserved			1U
#define XHC_RH2HSC3__reserved_L			1U
#define XHC_RH2HSC3__reserved_R			1U
#define XHC_RH2HSC3__reserved_WIDTH		1U
#define XHC_RH2HSC3__reserved_RESETVALUE	0x0U
#define XHC_RH2HSC3__STB			0U
#define XHC_RH2HSC3__STB_L			0U
#define XHC_RH2HSC3__STB_R			0U
#define XHC_RH2HSC3__STB_WIDTH			1U
#define XHC_RH2HSC3__STB_RESETVALUE		0x0U
#define XHC_RH2HSC3__RESERVED_L			15U
#define XHC_RH2HSC3__RESERVED_R			8U
#define XHC_RH2HSC3_WIDTH			32U
#define XHC_RH2HSC3__WIDTH			32U
#define XHC_RH2HSC3_ALL_L			31U
#define XHC_RH2HSC3_ALL_R			0U
#define XHC_RH2HSC3__ALL_L			31U
#define XHC_RH2HSC3__ALL_R			0U
#define XHC_RH2HSC3_DATAMASK			0xffff00ffU
#define XHC_RH2HSC3_RDWRMASK			0x0000ff00U
#define XHC_RH2HSC3_RESETVALUE			0x00000000U

#define XHC_RH2HSR3_OFFSET			0xd2cU
#define XHC_RH2HSR3_BASE			0xd2cU
#define XHC_RH2HSR3__C2U_L			31U
#define XHC_RH2HSR3__C2U_R			24U
#define XHC_RH2HSR3__C2U_WIDTH			8U
#define XHC_RH2HSR3__C2U_RESETVALUE		0x00U
#define XHC_RH2HSR3__C1U_L			23U
#define XHC_RH2HSR3__C1U_R			16U
#define XHC_RH2HSR3__C1U_WIDTH			8U
#define XHC_RH2HSR3__C1U_RESETVALUE		0x00U
#define XHC_RH2HSR3__reserved_L			15U
#define XHC_RH2HSR3__reserved_R			8U
#define XHC_RH2HSR3__reserved_WIDTH		8U
#define XHC_RH2HSR3__reserved_RESETVALUE	0x00U
#define XHC_RH2HSR3__RTY_L			7U
#define XHC_RH2HSR3__RTY_R			0U
#define XHC_RH2HSR3__RTY_WIDTH			8U
#define XHC_RH2HSR3__RTY_RESETVALUE		0x00U
#define XHC_RH2HSR3_WIDTH			32U
#define XHC_RH2HSR3__WIDTH			32U
#define XHC_RH2HSR3_ALL_L			31U
#define XHC_RH2HSR3_ALL_R			0U
#define XHC_RH2HSR3__ALL_L			31U
#define XHC_RH2HSR3__ALL_R			0U
#define XHC_RH2HSR3_DATAMASK			0xffffffffU
#define XHC_RH2HSR3_RDWRMASK			0x00000000U
#define XHC_RH2HSR3_RESETVALUE			0x00000000U

#define XHC_ECHU2P_OFFSET			0xd30U
#define XHC_ECHU2P_BASE				0xd30U
#define XHC_ECHU2P__reserved_L			31U
#define XHC_ECHU2P__reserved_R			16U
#define XHC_ECHU2P__reserved_WIDTH		16U
#define XHC_ECHU2P__reserved_RESETVALUE		0x0000U
#define XHC_ECHU2P__NCP_L			15U
#define XHC_ECHU2P__NCP_R			8U
#define XHC_ECHU2P__NCP_WIDTH			8U
#define XHC_ECHU2P__NCP_RESETVALUE		0x04U
#define XHC_ECHU2P__CID_L			7U
#define XHC_ECHU2P__CID_R			0U
#define XHC_ECHU2P__CID_WIDTH			8U
#define XHC_ECHU2P__CID_RESETVALUE		0xcaU
#define XHC_ECHU2P_WIDTH			32U
#define XHC_ECHU2P__WIDTH			32U
#define XHC_ECHU2P_ALL_L			31U
#define XHC_ECHU2P_ALL_R			0U
#define XHC_ECHU2P__ALL_L			31U
#define XHC_ECHU2P__ALL_R			0U
#define XHC_ECHU2P_DATAMASK			0xffffffffU
#define XHC_ECHU2P_RDWRMASK			0x00000000U
#define XHC_ECHU2P_RESETVALUE			0x000004caU

#define XHC_U2PVER_OFFSET			0xd34U
#define XHC_U2PVER_BASE				0xd34U
#define XHC_U2PVER__MAJ_L			31U
#define XHC_U2PVER__MAJ_R			28U
#define XHC_U2PVER__MAJ_WIDTH			4U
#define XHC_U2PVER__MAJ_RESETVALUE		0x0U
#define XHC_U2PVER__MIN_L			27U
#define XHC_U2PVER__MIN_R			24U
#define XHC_U2PVER__MIN_WIDTH			4U
#define XHC_U2PVER__MIN_RESETVALUE		0x0U
#define XHC_U2PVER__RLS_L			23U
#define XHC_U2PVER__RLS_R			20U
#define XHC_U2PVER__RLS_WIDTH			4U
#define XHC_U2PVER__RLS_RESETVALUE		0x0U
#define XHC_U2PVER__reserved_L			19U
#define XHC_U2PVER__reserved_R			0U
#define XHC_U2PVER__reserved_WIDTH		20U
#define XHC_U2PVER__reserved_RESETVALUE		0x00000U
#define XHC_U2PVER_WIDTH			32U
#define XHC_U2PVER__WIDTH			32U
#define XHC_U2PVER_ALL_L			31U
#define XHC_U2PVER_ALL_R			0U
#define XHC_U2PVER__ALL_L			31U
#define XHC_U2PVER__ALL_R			0U
#define XHC_U2PVER_DATAMASK			0xffffffffU
#define XHC_U2PVER_RDWRMASK			0x00000000U
#define XHC_U2PVER_RESETVALUE			0x00000000U

#define XHC_U2PMGN_OFFSET			0xd38U
#define XHC_U2PMGN_BASE				0xd38U
#define XHC_U2PMGN__MGN_L			31U
#define XHC_U2PMGN__MGN_R			0U
#define XHC_U2PMGN__MGN_WIDTH			32U
#define XHC_U2PMGN__MGN_RESETVALUE		0x4b534b4dU
#define XHC_U2PMGN_WIDTH			32U
#define XHC_U2PMGN__WIDTH			32U
#define XHC_U2PMGN_ALL_L			31U
#define XHC_U2PMGN_ALL_R			0U
#define XHC_U2PMGN__ALL_L			31U
#define XHC_U2PMGN__ALL_R			0U
#define XHC_U2PMGN_DATAMASK			0xffffffffU
#define XHC_U2PMGN_RDWRMASK			0x00000000U
#define XHC_U2PMGN_RESETVALUE			0x4b534b4dU

#define XHC_ECHRSV2_OFFSET			0xd40U
#define XHC_ECHRSV2_BASE			0xd40U
#define XHC_ECHRSV2__reserved_L			31U
#define XHC_ECHRSV2__reserved_R			16U
#define XHC_ECHRSV2__reserved_WIDTH		16U
#define XHC_ECHRSV2__reserved_RESETVALUE	0x0000U
#define XHC_ECHRSV2__NCP_L			15U
#define XHC_ECHRSV2__NCP_R			8U
#define XHC_ECHRSV2__NCP_WIDTH			8U
#define XHC_ECHRSV2__NCP_RESETVALUE		0x00U
#define XHC_ECHRSV2__CID_L			7U
#define XHC_ECHRSV2__CID_R			0U
#define XHC_ECHRSV2__CID_WIDTH			8U
#define XHC_ECHRSV2__CID_RESETVALUE		0xffU
#define XHC_ECHRSV2_WIDTH			32U
#define XHC_ECHRSV2__WIDTH			32U
#define XHC_ECHRSV2_ALL_L			31U
#define XHC_ECHRSV2_ALL_R			0U
#define XHC_ECHRSV2__ALL_L			31U
#define XHC_ECHRSV2__ALL_R			0U
#define XHC_ECHRSV2_DATAMASK			0xffffffffU
#define XHC_ECHRSV2_RDWRMASK			0x00000000U
#define XHC_ECHRSV2_RESETVALUE			0x000000ffU

#define XHC_ECHIRA_OFFSET			0xf90U
#define XHC_ECHIRA_BASE				0xf90U
#define XHC_ECHIRA__reserved_L			31U
#define XHC_ECHIRA__reserved_R			16U
#define XHC_ECHIRA__reserved_WIDTH		16U
#define XHC_ECHIRA__reserved_RESETVALUE		0x0000U
#define XHC_ECHIRA__NCP_L			15U
#define XHC_ECHIRA__NCP_R			8U
#define XHC_ECHIRA__NCP_WIDTH			8U
#define XHC_ECHIRA__NCP_RESETVALUE		0x04U
#define XHC_ECHIRA__CID_L			7U
#define XHC_ECHIRA__CID_R			0U
#define XHC_ECHIRA__CID_WIDTH			8U
#define XHC_ECHIRA__CID_RESETVALUE		0xfdU
#define XHC_ECHIRA_WIDTH			32U
#define XHC_ECHIRA__WIDTH			32U
#define XHC_ECHIRA_ALL_L			31U
#define XHC_ECHIRA_ALL_R			0U
#define XHC_ECHIRA__ALL_L			31U
#define XHC_ECHIRA__ALL_R			0U
#define XHC_ECHIRA_DATAMASK			0xffffffffU
#define XHC_ECHIRA_RDWRMASK			0x00000000U
#define XHC_ECHIRA_RESETVALUE			0x000004fdU

#define XHC_IRAADR_OFFSET			0xf98U
#define XHC_IRAADR_BASE				0xf98U
#define XHC_IRAADR__ADR_L			23U
#define XHC_IRAADR__ADR_R			2U
#define XHC_IRAADR__ADR_WIDTH			22U
#define XHC_IRAADR__ADR_RESETVALUE		0x0U
#define XHC_IRAADR__reserved			1U
#define XHC_IRAADR__reserved_L			1U
#define XHC_IRAADR__reserved_R			1U
#define XHC_IRAADR__reserved_WIDTH		1U
#define XHC_IRAADR__reserved_RESETVALUE		0x0U
#define XHC_IRAADR__MOD				0U
#define XHC_IRAADR__MOD_L			0U
#define XHC_IRAADR__MOD_R			0U
#define XHC_IRAADR__MOD_WIDTH			1U
#define XHC_IRAADR__MOD_RESETVALUE		0x0U
#define XHC_IRAADR__RESERVED_L			31U
#define XHC_IRAADR__RESERVED_R			24U
#define XHC_IRAADR_WIDTH			24U
#define XHC_IRAADR__WIDTH			24U
#define XHC_IRAADR_ALL_L			23U
#define XHC_IRAADR_ALL_R			0U
#define XHC_IRAADR__ALL_L			23U
#define XHC_IRAADR__ALL_R			0U
#define XHC_IRAADR_DATAMASK			0x00ffffffU
#define XHC_IRAADR_RDWRMASK			0xff000000U
#define XHC_IRAADR_RESETVALUE			0x000000U

#define XHC_IRADAT_OFFSET			0xf9cU
#define XHC_IRADAT_BASE			0xf9cU
#define XHC_IRADAT__DAT_L			31U
#define XHC_IRADAT__DAT_R			0U
#define XHC_IRADAT__DAT_WIDTH			32U
#define XHC_IRADAT__DAT_RESETVALUE			0x00000000U
#define XHC_IRADAT_WIDTH			32U
#define XHC_IRADAT__WIDTH			32U
#define XHC_IRADAT_ALL_L			31U
#define XHC_IRADAT_ALL_R			0U
#define XHC_IRADAT__ALL_L			31U
#define XHC_IRADAT__ALL_R			0U
#define XHC_IRADAT_DATAMASK			0xffffffffU
#define XHC_IRADAT_RDWRMASK			0x00000000U
#define XHC_IRADAT_RESETVALUE			0x00000000U


#define XHC_ECHHST_OFFSET			0xfa0U
#define XHC_ECHHST_BASE				0xfa0U
#define XHC_ECHHST__CCC				31U
#define XHC_ECHHST__CCC_L			31U
#define XHC_ECHHST__CCC_R			31U
#define XHC_ECHHST__CCC_WIDTH			1U
#define XHC_ECHHST__CCC_RESETVALUE		0x1U
#define XHC_ECHHST__PME				30U
#define XHC_ECHHST__PME_L			30U
#define XHC_ECHHST__PME_R			30U
#define XHC_ECHHST__PME_WIDTH			1U
#define XHC_ECHHST__PME_RESETVALUE		0x0U
#define XHC_ECHHST__AUX_L			29U
#define XHC_ECHHST__AUX_R			24U
#define XHC_ECHHST__AUX_WIDTH			6U
#define XHC_ECHHST__AUX_RESETVALUE		0x0U
#define XHC_ECHHST__IRA				20U
#define XHC_ECHHST__IRA_L			20U
#define XHC_ECHHST__IRA_R			20U
#define XHC_ECHHST__IRA_WIDTH			1U
#define XHC_ECHHST__IRA_RESETVALUE		0x0U
#define XHC_ECHHST__ULS				19U
#define XHC_ECHHST__ULS_L			19U
#define XHC_ECHHST__ULS_R			19U
#define XHC_ECHHST__ULS_WIDTH			1U
#define XHC_ECHHST__ULS_RESETVALUE		0x0U
#define XHC_ECHHST__reserved			18U
#define XHC_ECHHST__reserved_L			18U
#define XHC_ECHHST__reserved_R			18U
#define XHC_ECHHST__reserved_WIDTH		1U
#define XHC_ECHHST__reserved_RESETVALUE		0x0U
#define XHC_ECHHST__TEDA			17U
#define XHC_ECHHST__TEDA_L			17U
#define XHC_ECHHST__TEDA_R			17U
#define XHC_ECHHST__TEDA_WIDTH			1U
#define XHC_ECHHST__TEDA_RESETVALUE		0x0U
#define XHC_ECHHST__FSW				16U
#define XHC_ECHHST__FSW_L			16U
#define XHC_ECHHST__FSW_R			16U
#define XHC_ECHHST__FSW_WIDTH			1U
#define XHC_ECHHST__FSW_RESETVALUE		0x1U
#define XHC_ECHHST__NCP_L			15U
#define XHC_ECHHST__NCP_R			8U
#define XHC_ECHHST__NCP_WIDTH			8U
#define XHC_ECHHST__NCP_RESETVALUE		0x04U
#define XHC_ECHHST__CID_L			7U
#define XHC_ECHHST__CID_R			0U
#define XHC_ECHHST__CID_WIDTH			8U
#define XHC_ECHHST__CID_RESETVALUE		0xfcU
#define XHC_ECHHST__RESERVED_L			23U
#define XHC_ECHHST__RESERVED_R			21U
#define XHC_ECHHST_WIDTH			32U
#define XHC_ECHHST__WIDTH			32U
#define XHC_ECHHST_ALL_L			31U
#define XHC_ECHHST_ALL_R			0U
#define XHC_ECHHST__ALL_L			31U
#define XHC_ECHHST__ALL_R			0U
#define XHC_ECHHST_DATAMASK			0xff1fffffU
#define XHC_ECHHST_RDWRMASK			0x00e00000U
#define XHC_ECHHST_RESETVALUE			0x800104fcU

#define XHC_HSTDBG_OFFSET			0xfa4U
#define XHC_HSTDBG_BASE				0xfa4U
#define XHC_HSTDBG__ETE				31U
#define XHC_HSTDBG__ETE_L			31U
#define XHC_HSTDBG__ETE_R			31U
#define XHC_HSTDBG__ETE_WIDTH			1U
#define XHC_HSTDBG__ETE_RESETVALUE		0x0U
#define XHC_HSTDBG__reserved_L			30U
#define XHC_HSTDBG__reserved_R			16U
#define XHC_HSTDBG__reserved_WIDTH		15U
#define XHC_HSTDBG__reserved_RESETVALUE		0x0U
#define XHC_HSTDBG__OUTP_L			15U
#define XHC_HSTDBG__OUTP_R			8U
#define XHC_HSTDBG__OUTP_WIDTH			8U
#define XHC_HSTDBG__OUTP_RESETVALUE		0x00U
#define XHC_HSTDBG__INP_L			7U
#define XHC_HSTDBG__INP_R			0U
#define XHC_HSTDBG__INP_WIDTH			8U
#define XHC_HSTDBG__INP_RESETVALUE		0x00U
#define XHC_HSTDBG_WIDTH			32U
#define XHC_HSTDBG__WIDTH			32U
#define XHC_HSTDBG_ALL_L			31U
#define XHC_HSTDBG_ALL_R			0U
#define XHC_HSTDBG__ALL_L			31U
#define XHC_HSTDBG__ALL_R			0U
#define XHC_HSTDBG_DATAMASK			0xffffffffU
#define XHC_HSTDBG_RDWRMASK			0x00000000U
#define XHC_HSTDBG_RESETVALUE			0x00000000U

#define XHC_HSTNPL_OFFSET			0xfa8U
#define XHC_HSTNPL_BASE				0xfa8U
#define XHC_HSTNPL__NPL_L			31U
#define XHC_HSTNPL__NPL_R			9U
#define XHC_HSTNPL__NPL_WIDTH			23U
#define XHC_HSTNPL__NPL_RESETVALUE		0x0U
#define XHC_HSTNPL__reserved_L			8U
#define XHC_HSTNPL__reserved_R			0U
#define XHC_HSTNPL__reserved_WIDTH		9U
#define XHC_HSTNPL__reserved_RESETVALUE		0x0U
#define XHC_HSTNPL_WIDTH			32U
#define XHC_HSTNPL__WIDTH			32U
#define XHC_HSTNPL_ALL_L			31U
#define XHC_HSTNPL_ALL_R			0U
#define XHC_HSTNPL__ALL_L			31U
#define XHC_HSTNPL__ALL_R			0U
#define XHC_HSTNPL_DATAMASK			0xffffffffU
#define XHC_HSTNPL_RDWRMASK			0x00000000U
#define XHC_HSTNPL_RESETVALUE			0x00000000U

#define XHC_HSTNPH_OFFSET			0xfacU
#define XHC_HSTNPH_BASE				0xfacU
#define XHC_HSTNPH__NPH_L			31U
#define XHC_HSTNPH__NPH_R			0U
#define XHC_HSTNPH__NPH_WIDTH			32U
#define XHC_HSTNPH__NPH_RESETVALUE		0x00000000U
#define XHC_HSTNPH_WIDTH			32U
#define XHC_HSTNPH__WIDTH			32U
#define XHC_HSTNPH_ALL_L			31U
#define XHC_HSTNPH_ALL_R			0U
#define XHC_HSTNPH__ALL_L			31U
#define XHC_HSTNPH__ALL_R			0U
#define XHC_HSTNPH_DATAMASK			0xffffffffU
#define XHC_HSTNPH_RDWRMASK			0x00000000U
#define XHC_HSTNPH_RESETVALUE			0x00000000U

#define XHC_ECHRBV_OFFSET			0xfb0U
#define XHC_ECHRBV_BASE				0xfb0U
#define XHC_ECHRBV__MAJ_L			31U
#define XHC_ECHRBV__MAJ_R			28U
#define XHC_ECHRBV__MAJ_WIDTH			4U
#define XHC_ECHRBV__MAJ_RESETVALUE		0x0U
#define XHC_ECHRBV__MIN_L			27U
#define XHC_ECHRBV__MIN_R			24U
#define XHC_ECHRBV__MIN_WIDTH			4U
#define XHC_ECHRBV__MIN_RESETVALUE		0x0U
#define XHC_ECHRBV__RLS_L			23U
#define XHC_ECHRBV__RLS_R			16U
#define XHC_ECHRBV__RLS_WIDTH			8U
#define XHC_ECHRBV__RLS_RESETVALUE		0x00U
#define XHC_ECHRBV__NCP_L			15U
#define XHC_ECHRBV__NCP_R			8U
#define XHC_ECHRBV__NCP_WIDTH			8U
#define XHC_ECHRBV__NCP_RESETVALUE		0x00U
#define XHC_ECHRBV__CID_L			7U
#define XHC_ECHRBV__CID_R			0U
#define XHC_ECHRBV__CID_WIDTH			8U
#define XHC_ECHRBV__CID_RESETVALUE		0xfeU
#define XHC_ECHRBV_WIDTH			32U
#define XHC_ECHRBV__WIDTH			32U
#define XHC_ECHRBV_ALL_L			31U
#define XHC_ECHRBV_ALL_R			0U
#define XHC_ECHRBV__ALL_L			31U
#define XHC_ECHRBV__ALL_R			0U
#define XHC_ECHRBV_DATAMASK			0xffffffffU
#define XHC_ECHRBV_RDWRMASK			0x00000000U
#define XHC_ECHRBV_RESETVALUE			0x000000feU

#define XHC_RBVPDT_OFFSET			0xfb4U
#define XHC_RBVPDT_BASE				0xfb4U
#define XHC_RBVPDT__VDR_L			31U
#define XHC_RBVPDT__VDR_R			16U
#define XHC_RBVPDT__VDR_WIDTH			16U
#define XHC_RBVPDT__VDR_RESETVALUE		0x0a5cU
#define XHC_RBVPDT__PDT_L			15U
#define XHC_RBVPDT__PDT_R			0U
#define XHC_RBVPDT__PDT_WIDTH			16U
#define XHC_RBVPDT__PDT_RESETVALUE		0x0000U
#define XHC_RBVPDT_WIDTH			32U
#define XHC_RBVPDT__WIDTH			32U
#define XHC_RBVPDT_ALL_L			31U
#define XHC_RBVPDT_ALL_R			0U
#define XHC_RBVPDT__ALL_L			31U
#define XHC_RBVPDT__ALL_R			0U
#define XHC_RBVPDT_DATAMASK			0xffffffffU
#define XHC_RBVPDT_RDWRMASK			0x00000000U
#define XHC_RBVPDT_RESETVALUE			0x0a5c0000U

#define XHC_RBVMGN_OFFSET			0xfbcU
#define XHC_RBVMGN_BASE				0xfbcU
#define XHC_RBVMGN__MGN_L			31U
#define XHC_RBVMGN__MGN_R			0U
#define XHC_RBVMGN__MGN_WIDTH			32U
#define XHC_RBVMGN__MGN_RESETVALUE		0x52535354U
#define XHC_RBVMGN_WIDTH			32U
#define XHC_RBVMGN__WIDTH			32U
#define XHC_RBVMGN_ALL_L			31U
#define XHC_RBVMGN_ALL_R			0U
#define XHC_RBVMGN__ALL_L			31U
#define XHC_RBVMGN__ALL_R			0U
#define XHC_RBVMGN_DATAMASK			0xffffffffU
#define XHC_RBVMGN_RDWRMASK			0x00000000U
#define XHC_RBVMGN_RESETVALUE			0x52535354U

/* PORTSC field defines */
#define XHC_PORTSC__PS_LINK_STATE_U0		0U
#define XHC_PORTSC__PS_LINK_STATE_U1		1U
#define XHC_PORTSC__PS_LINK_STATE_U2		2U
#define XHC_PORTSC__PS_LINK_STATE_U3		3U
#define XHC_PORTSC__PS_LINK_STATE_DISABLED	4U
#define XHC_PORTSC__PS_LINK_STATE_RX_DETECT	5U
#define XHC_PORTSC__PS_LINK_STATE_INACTIVE	6U
#define XHC_PORTSC__PS_LINK_STATE_POLLING	7U
#define XHC_PORTSC__PS_LINK_STATE_RECOVERY	8U
#define XHC_PORTSC__PS_LINK_STATE_HOT_RESET	9U
#define XHC_PORTSC__PS_LINK_STATE_COMPLIANCE	10U
#define XHC_PORTSC__PS_LINK_STATE_TEST		11U
#define XHC_PORTSC__PS_LINK_STATE_RESUME	15U

#define XHC_PORTSC__PS_SPEED_UNDEFINED		0U
#define XHC_PORTSC__PS_FS			1U
#define XHC_PORTSC__PS_LS			2U
#define XHC_PORTSC__PS_HS			3U
#define XHC_PORTSC__PS_SS			4U

/* macros and inline functions */

/* write 64bit ptr 'p' to destination 'd' with offset 'v' */
inline void WRITE64_REG_PTRL(uint32_t r, uint32_t *p)
{
	uint32_t *ptr = (uint32_t *) (uint64_t) (XHC_BASE + r);

	*ptr = (uint32_t) ((uint64_t) p & (uint64_t) 0xffffffffU);
}

inline void WRITE64_REG_PTRH(uint32_t r, uint32_t *p)
{
	uint32_t *ptr = (uint32_t *) (uint64_t) (XHC_BASE + r);

	*ptr = (uint32_t) ((uint64_t) p >> 32U);
}

#define XHC_REG_RD(addr)   mmio_read_32(XHC_BASE + addr)

#define XHC_REG_WR(addr, val) mmio_write_32(XHC_BASE+addr, val)

#endif				/* USBH_XHCI_REGS_H */

