/*
 * macutils.c -- contributed by Harry Lakser, May 11, 1993.
 *
 */

#include <console.h>   /* for definition of _fcreator */

#define strID 128
#define stackItem 1
#define creatorItem 2

void AdjustStack(void)
{
	long stackSize;
	unsigned char stackStr[10];
	Ptr newLimit;

	GetIndString(stackStr,strID,stackItem);
	StringToNum(stackStr, &stackSize);
	stackSize *= 1024;
	newLimit = CurStackBase - stackSize;
	if ( newLimit < GetApplLimit() )
		SetApplLimit( newLimit ); /* to give stack of stackSize */
}

void SetCreator(void)
{
	unsigned char creatorStr[5];
	
	GetIndString( creatorStr, strID, creatorItem);
	PtoCstr( creatorStr );
	_fcreator = * (OSType *)creatorStr;
}


/*

[Notes from Harry Lakser on how to compile on Mac with THINK C 5.0.]

	First, we must use 4-byte ints.  Following the instructions
on page 13 in the THINK C Standard Libraries Reference, make
a copy of ANSI, name it ANSI-4, say. Open ANSI-4, and in Compiler
Settings in Options.. under the Edit menu, set 4-byte ints, and Update
the project.

	I had to modify two of the source files of Otter.  In io.c in the
function str_to_sequence, I had to change all the "return(NULL)" to
"return((int)NULL)" to stop the compiler from yelling at me.  Also,
on a Mac Plus (but not on my Quadra) I got a stack overflow.  I thus
implemented a user-modifiable stack setting.  While I was at it, I
also enabled the user to set the Creator type of the files created
by Otter--I prefer EDIT.  To do this I wrote a small file MacUtils.c:

[REFER TO ABOVE CODE -- wwm]

	This reads a STR# resource, created by ResEdit in a resource file,
with two strings, the first being the absolute minimum stack size in K
(in ASCII), and the second the Creator type of the output file produced.
I set the resource ID to 128. In my version, the first string is 32 (giving
a stack of at least 32K), and the second string is EDIT.

	I then modified main.c by adding the following two lines just before
the "ccommand" line:

-------------------------------------------------------------------
	AdjustStack();
	SetCreator();

--------------------------------------------------------------------

	Now create a project for Otter-- I called mine Otterxa.<pi> ( the
"<pi>" is option-p, printing as the letter pi---I don't know how to
produce it for mail). I thus had to call the above ResEdit resource
file  Otterxa.<pi>.rsrc . I then segmented the project as follows:


clocks.c
fpa.c
imd.c
index.c
is.c
linkhyp.c
lpro.c
MacUtils.c  -- this is new
main.c      -- this was modified
options.c
paramod.c
process.c
share.c
unify.c
weight.c
----------
MacTraps
resolve.c
---------
clause.c
formula.c
---------
linkur.c
misc.c
---------
ac.c
demod.c
io.c    -- this was modified
--------
ANSI-4
--------

	In this project, I set 4-byte ints in Compiler Settings in
Options... under the Edit menu, and, in Set project type under
the Project Menu, I set Separate STRS, set the Partition to 1000K,
and set Size Flags to 0880, that is, I set Multi-Finder Aware
and 32-Bit Compatible.  I then compiled the application.  The STR#
resource loaded automatically into the Otter application, and the stack
size and Creator type can be modified any time by using ResEdit on the
Otter application--by modifying the strings in the STR# ID 128 resource.
So, if you encounter a Stack Overflow error, number 28, just increase
the stack size.

*/
