#!/bin/sh
#
# Copyright (C) 2011-2020 ABINIT group (Yann Pouillon)
#
# This file is part of the Abinit Documentation software package. For license
# information, please see the COPYING file in the top-level directory of
# the source distribution.
#

#
# IMPORTANT NOTE:
#
#   For maintainer use only!
#
#   PLEASE DO NOT EDIT THIS FILE, AS IT COULD CAUSE A SERIOUS LOSS OF DATA.
#   *** YOU HAVE BEEN WARNED! ***
#

# Check that we are in the right directory
if test ! -s "./configure.ac" -o ! -s "config/specs/documents.conf"; then
  echo "[docclean]   Cowardly refusing to remove something from here!" >&2
  exit 1
fi
chmod -R u+w .

# Remove temporary directories and files
echo "[docclean]   Removing temporary directories and files"
rm -rf tmp*
find . -depth -name 'tmp-*' -exec rm -rf {} \;

# Remove autotools files
echo "[docclean]   Removing autotools files"
rm -f core config.log config.status stamp-h1 config.h config.h.in*
rm -rf aclocal.m4 autom4te.cache configure confstat*
(cd config/gnu && rm -f config.guess config.sub depcomp install-sh ltmain.sh missing)
(cd config/m4 && rm -f libtool.m4 ltoptions.m4 ltsugar.m4 ltversion.m4 lt~obsolete.m4)

# Remove Makefiles and machine-generated files
echo "[docclean]   Removing files produced by the configure script"
rm -f libtool
find . -name Makefile -exec rm {} \;
find . -name Makefile.in -exec rm {} \;
find . -name Makefile.am -exec rm {} \;

# Remove machine-generated build-system files
rm -f config/m4/auto-*.m4

# Remove compiled files
echo "[docclean]   Removing compiled files and auxiliary data"
for ext in aux blg dvi fdb_latexmk fls ilg log nav snm tmp toc vrb; do
  find . -name "*.${ext}" -exec rm {} \;
done
rm -f \
  build/build-system-guide.out \
  build/build-system-guide.pdf \
  build/connectors.out \
  build/connectors.pdf \
  macroave/macroave.out \
  macroave/macroave.pdf \
  theory/ELF/test_report/test_report_elf.out \
  theory/ELF/wf_elecden_kinden_elf.out \
  theory/KDEN/test_report_kden.out \
  theory/MGGA/report_MGGA.out \
  theory/fixd_theory.out \
  theory/fixd_theory.pdf \
  theory/geometry.out \
  theory/geometry.pdf \
  theory/gwa.out \
  theory/gwa.pdf \
  theory/noncol.out \
  theory/noncol.pdf \
  theory/set_WFs.out \
  theory/set_WFs.pdf \
  theory/vanderbilt-anaddb-notes.out \
  theory/vanderbilt-anaddb-notes.pdf \
  theory/wavefunction.out \
  theory/wavefunction.pdf \
  guide/AbinitBandStructureMaker_manual.out \
  guide/AbinitBandStructureMaker_manual.pdf \
  guide/aimhelp.out \
  guide/aimhelp.pdf \
  guide/conducti_manual.out \
  guide/conducti_manual.pdf \
  guide/conductivity_paw_manu.out \
  guide/conductivity_paw_manu.pdf \
  guide/elphon_manual.out \
  guide/elphon_manual.pdf \
  guide/linear_optics_paw.out \
  guide/linear_optics_paw.pdf \
  guide/xtalinput.out \
  guide/xtalinput.pdf \
  versioning/bzr-quickref.out \
  versioning/bzr-quickref.pdf
rm -rf abinit-doc-[0-9]*
